/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.zip;

import com.android.tools.build.apkzlib.utils.IOExceptionWrapper;
import com.android.tools.build.apkzlib.zip.CentralDirectory;
import com.android.tools.build.apkzlib.zip.Eocd;
import com.android.tools.build.apkzlib.zip.FileUseMap;
import com.android.tools.build.apkzlib.zip.FileUseMapEntry;
import com.android.tools.build.apkzlib.zip.VerifyLog;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.Zip64Eocd;
import com.android.tools.build.apkzlib.zip.Zip64EocdLocator;
import com.android.tools.build.apkzlib.zip.Zip64ExtensibleDataSector;
import com.android.tools.build.apkzlib.zip.utils.LittleEndianUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class EocdGroup {
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_COMMENT_SIZE = 65535;
    private static final int LAST_BYTES_TO_READ = 65557;
    private static final int ZIP64_EOCD_LOCATOR_SIGNATURE = 117853008;
    private static final long EOCD_SIGNATURE = 101010256L;
    @Nullable
    private FileUseMapEntry<Eocd> eocdEntry = null;
    @Nullable
    private FileUseMapEntry<Zip64EocdLocator> eocd64Locator = null;
    @Nullable
    private FileUseMapEntry<Zip64Eocd> eocd64Entry = null;
    @Nullable
    private byte[] eocdComment = new byte[0];
    @Nullable
    private Zip64ExtensibleDataSector eocdDataSector = new Zip64ExtensibleDataSector();
    private boolean useVersion2Header;
    private final ZFile file;
    private final FileUseMap map;
    private final VerifyLog verifyLog;

    EocdGroup(ZFile file, FileUseMap map) {
        this.file = file;
        this.map = map;
        this.verifyLog = file.getVerifyLog();
        this.useVersion2Header = false;
    }

    void readRecord(long fileLength) throws IOException {
        int lastToRead = 65557;
        if ((long)lastToRead > fileLength) {
            lastToRead = Ints.checkedCast(fileLength);
        }
        byte[] last = new byte[lastToRead];
        this.file.directFullyRead(fileLength - (long)lastToRead, last);
        Eocd eocd = null;
        int foundEocdSignatureIdx = -1;
        IOException errorFindingSignature = null;
        long eocdStart = -1L;
        for (int endIdx = last.length - 22; endIdx >= 0 && foundEocdSignatureIdx == -1; --endIdx) {
            ByteBuffer potentialLocator = ByteBuffer.wrap(last, endIdx, 4);
            if (LittleEndianUtils.readUnsigned4Le(potentialLocator) != 101010256L) continue;
            foundEocdSignatureIdx = endIdx;
            ByteBuffer eocdBytes = ByteBuffer.wrap(last, foundEocdSignatureIdx, last.length - foundEocdSignatureIdx);
            try {
                eocd = new Eocd(eocdBytes);
                eocdStart = fileLength - (long)lastToRead + (long)foundEocdSignatureIdx;
                if (eocdStart + eocd.getEocdSize() == fileLength) continue;
                this.verifyLog.log("EOCD starts at " + eocdStart + " and has " + eocd.getEocdSize() + " bytes, but file ends at " + fileLength + ".");
                continue;
            }
            catch (IOException e5) {
                if (errorFindingSignature != null) {
                    e5.addSuppressed(errorFindingSignature);
                }
                errorFindingSignature = e5;
                foundEocdSignatureIdx = -1;
                eocd = null;
            }
        }
        if (foundEocdSignatureIdx == -1) {
            throw new IOException("EOCD signature not found in the last " + lastToRead + " bytes of the file.", errorFindingSignature);
        }
        Verify.verify(eocdStart >= 0L);
        this.eocdEntry = this.map.add(eocdStart, eocdStart + eocd.getEocdSize(), eocd);
        long zip64LocatorStart = eocdStart - (long)Zip64EocdLocator.LOCATOR_SIZE;
        if (zip64LocatorStart >= 0L) {
            byte[] possibleZip64Locator = new byte[Zip64EocdLocator.LOCATOR_SIZE];
            this.file.directFullyRead(zip64LocatorStart, possibleZip64Locator);
            if (LittleEndianUtils.readUnsigned4Le(ByteBuffer.wrap(possibleZip64Locator)) == 117853008L) {
                Zip64EocdLocator locator = new Zip64EocdLocator(ByteBuffer.wrap(possibleZip64Locator));
                this.eocd64Locator = this.map.add(zip64LocatorStart, zip64LocatorStart + locator.getSize(), locator);
                byte[] zip64EocdSizeHolder = new byte[8];
                this.file.directFullyRead(locator.getZ64EocdOffset() + (long)Zip64Eocd.SIZE_OFFSET, zip64EocdSizeHolder);
                long zip64EocdSize = LittleEndianUtils.readUnsigned8Le(ByteBuffer.wrap(zip64EocdSizeHolder)) + (long)Zip64Eocd.TRUE_SIZE_DIFFERENCE;
                byte[] zip64EocdBytes = new byte[Ints.checkedCast(zip64EocdSize)];
                this.file.directFullyRead(locator.getZ64EocdOffset(), zip64EocdBytes);
                Zip64Eocd zip64Eocd = new Zip64Eocd(ByteBuffer.wrap(zip64EocdBytes));
                this.useVersion2Header = zip64Eocd.getVersionToExtract() >= 62L;
                long zip64EocdEnd = locator.getZ64EocdOffset() + zip64EocdSize;
                if (zip64EocdEnd != zip64LocatorStart) {
                    String msg = "Zip64 EOCD record is stored in [" + locator.getZ64EocdOffset() + " - " + zip64EocdEnd + "] and EOCD starts at " + zip64LocatorStart + ".";
                    if (zip64EocdEnd > zip64LocatorStart) {
                        throw new IOException(msg);
                    }
                    this.verifyLog.log(msg);
                }
                this.eocd64Entry = this.map.add(locator.getZ64EocdOffset(), zip64EocdEnd, zip64Eocd);
            }
        }
    }

    void computeRecord(@Nullable FileUseMapEntry<CentralDirectory> directoryEntry, long extraDirectoryOffset) throws IOException {
        boolean useZip64Eocd;
        long dirNumEntries;
        long dirSize;
        long dirStart;
        if (directoryEntry != null) {
            dirStart = directoryEntry.getStart();
            dirSize = directoryEntry.getSize();
            dirNumEntries = directoryEntry.getStore().getEntries().size();
        } else {
            dirStart = extraDirectoryOffset;
            dirSize = 0L;
            dirNumEntries = 0L;
        }
        boolean bl = useZip64Eocd = dirStart > 0xFFFFFFFFL || dirSize > 0xFFFFFFFFL || dirNumEntries > 65535L || directoryEntry != null && directoryEntry.getStore().containsZip64Files();
        if (useZip64Eocd) {
            Verify.verify(this.eocdDataSector != null);
            Zip64Eocd zip64Eocd = new Zip64Eocd(dirNumEntries, dirStart, dirSize, this.useVersion2Header, this.eocdDataSector);
            this.eocdDataSector = null;
            byte[] zip64EocdBytes = zip64Eocd.toBytes();
            long zip64Offset = this.map.size();
            this.map.extend(zip64Offset + (long)zip64EocdBytes.length);
            this.eocd64Entry = this.map.add(zip64Offset, zip64Offset + (long)zip64EocdBytes.length, zip64Eocd);
            Zip64EocdLocator locator = new Zip64EocdLocator(this.eocd64Entry.getStart());
            byte[] locatorBytes = locator.toBytes();
            long locatorOffset = this.map.size();
            this.map.extend(locatorOffset + (long)locatorBytes.length);
            this.eocd64Locator = this.map.add(locatorOffset, locatorOffset + (long)locatorBytes.length, locator);
        }
        Verify.verify(this.eocdComment != null);
        Eocd eocd = new Eocd(Math.min(dirNumEntries, 65535L), Math.min(dirStart, 0xFFFFFFFFL), Math.min(dirSize, 0xFFFFFFFFL), this.eocdComment);
        this.eocdComment = null;
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.map.size();
        this.map.extend(eocdOffset + (long)eocdBytes.length);
        this.eocdEntry = this.map.add(eocdOffset, eocdOffset + (long)eocdBytes.length, eocd);
    }

    void appendToFile() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry, "eocdEntry == null");
        if (this.eocd64Entry != null) {
            Zip64Eocd zip64Eocd = this.eocd64Entry.getStore();
            Preconditions.checkNotNull(zip64Eocd);
            Zip64EocdLocator locator = this.eocd64Locator.getStore();
            Preconditions.checkNotNull(locator);
            this.file.directWrite(this.eocd64Entry.getStart(), zip64Eocd.toBytes());
            this.file.directWrite(this.eocd64Locator.getStart(), locator.toBytes());
        }
        Eocd eocd = this.eocdEntry.getStore();
        Preconditions.checkNotNull(eocd, "eocd == null");
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.eocdEntry.getStart();
        this.file.directWrite(eocdOffset, eocdBytes);
    }

    byte[] getEocdBytes() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry, "eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        Preconditions.checkNotNull(eocd, "eocd == null");
        return eocd.toBytes();
    }

    @Nullable
    @VisibleForTesting
    byte[] getEocdLocatorBytes() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry);
        if (this.eocd64Locator == null) {
            return null;
        }
        return this.eocd64Locator.getStore().toBytes();
    }

    @Nullable
    @VisibleForTesting
    byte[] getZ64EocdBytes() throws IOException {
        Preconditions.checkNotNull(this.eocdEntry);
        if (this.eocd64Entry == null) {
            return null;
        }
        return this.eocd64Entry.getStore().toBytes();
    }

    boolean isEmpty() {
        return this.eocdEntry == null;
    }

    void setUseVersion2Header(boolean useVersion2Header) {
        this.verifyLog.verify(this.eocdEntry == null, "eocdEntry != null", new Object[0]);
        this.useVersion2Header = useVersion2Header;
    }

    boolean usingVersion2Header() {
        return this.useVersion2Header;
    }

    void deleteRecord() {
        if (this.eocdEntry != null) {
            this.map.remove(this.eocdEntry);
            Eocd eocd = this.eocdEntry.getStore();
            Verify.verify(eocd != null);
            this.eocdComment = eocd.getComment();
            this.eocdEntry = null;
        }
        if (this.eocd64Locator != null) {
            Verify.verify(this.eocd64Entry != null);
            this.eocdDataSector = this.eocd64Entry.getStore().getExtraFields();
            this.map.remove(this.eocd64Locator);
            this.map.remove(this.eocd64Entry);
            this.eocd64Locator = null;
            this.eocd64Entry = null;
        } else {
            this.eocdDataSector = new Zip64ExtensibleDataSector();
        }
    }

    void setEocdComment(byte[] comment) {
        if (comment.length > 65535) {
            throw new IllegalArgumentException("EOCD comment size (" + comment.length + ") is larger than the maximum allowed (" + 65535 + ")");
        }
        for (int i4 = 0; i4 < comment.length - 22; ++i4) {
            ByteBuffer potentialSignature = ByteBuffer.wrap(comment, i4, 4);
            try {
                if (LittleEndianUtils.readUnsigned4Le(potentialSignature) != 101010256L) continue;
                ByteBuffer bytes = ByteBuffer.wrap(comment, i4, comment.length - i4);
                try {
                    new Eocd(bytes);
                    throw new IllegalArgumentException("Position " + i4 + " of the comment contains a valid EOCD record.");
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            catch (IOException e5) {
                throw new IOExceptionWrapper(e5);
            }
        }
        this.deleteRecord();
        this.eocdComment = new byte[comment.length];
        System.arraycopy(comment, 0, this.eocdComment, 0, comment.length);
    }

    long getOffset() {
        if (this.eocdEntry == null) {
            return -1L;
        }
        return this.getRecordStart();
    }

    byte[] getEocdComment() {
        if (this.eocdEntry == null) {
            Verify.verify(this.eocdComment != null);
            byte[] eocdCommentCopy = (byte[])this.eocdComment.clone();
            return eocdCommentCopy;
        }
        Eocd eocd = this.eocdEntry.getStore();
        Verify.verify(eocd != null);
        return eocd.getComment();
    }

    long getDirectorySize() {
        Preconditions.checkNotNull(this.eocdEntry, "eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        if (this.eocd64Entry != null && eocd.getDirectorySize() == 0xFFFFFFFFL) {
            return this.eocd64Entry.getStore().getDirectorySize();
        }
        return eocd.getDirectorySize();
    }

    long getDirectoryOffset() {
        Preconditions.checkNotNull(this.eocdEntry, "eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        if (this.eocd64Entry != null && eocd.getDirectoryOffset() == 0xFFFFFFFFL) {
            return this.eocd64Entry.getStore().getDirectoryOffset();
        }
        return eocd.getDirectoryOffset();
    }

    long getTotalDirectoryRecords() {
        Preconditions.checkNotNull(this.eocdEntry, "eocdEntry == null");
        Eocd eocd = this.eocdEntry.getStore();
        if (this.eocd64Entry != null && eocd.getTotalRecords() == 65535L) {
            return this.eocd64Entry.getStore().getTotalRecords();
        }
        return eocd.getTotalRecords();
    }

    long getRecordStart() {
        Verify.verify(this.eocdEntry != null, "eocdEntry == null", new Object[0]);
        if (this.eocd64Entry != null) {
            return this.eocd64Entry.getStart();
        }
        return this.eocdEntry.getStart();
    }

    public long getRecordSize() {
        if (this.eocd64Entry != null) {
            Verify.verify(this.eocdEntry != null);
            return this.eocdEntry.getEnd() - this.eocd64Entry.getStart();
        }
        if (this.eocdEntry == null) {
            return -1L;
        }
        return this.eocdEntry.getSize();
    }

    @Nullable
    public Zip64ExtensibleDataSector getExtensibleData() {
        Verify.verify(this.eocdEntry != null);
        if (this.eocd64Entry != null) {
            return this.eocd64Entry.getStore().getExtraFields();
        }
        return null;
    }
}

