/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.apksig.ApkSigner;
import com.android.apksig.apk.ApkFormatException;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

class ApkSigner {
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";
    private final Optional<SigningConfiguration> optSigningConfig;
    private final Optional<SigningConfiguration> optStampSigningConfig;
    private final Version bundletoolVersion;
    private final TempDirectory tempDirectory;

    @Inject
    ApkSigner(@BuildApksModule.ApkSigningConfig Optional<SigningConfiguration> signingConfig, @BuildApksModule.StampSigningConfig Optional<SigningConfiguration> stampSigningConfig, Version bundletoolVersion, TempDirectory tempDirectory) {
        this.optSigningConfig = signingConfig;
        this.optStampSigningConfig = stampSigningConfig;
        this.bundletoolVersion = bundletoolVersion;
        this.tempDirectory = tempDirectory;
    }

    public void signApk(Path apkPath, ModuleSplit split) {
        if (!this.optSigningConfig.isPresent()) {
            return;
        }
        SigningConfiguration signingConfiguration = this.optSigningConfig.get();
        boolean signWithV1 = this.shouldSignWithV1Scheme(split);
        boolean signWithV3 = this.shouldSignWithV3Scheme(split);
        int minSdkVersion = split.getAndroidManifest().getEffectiveMinSdkVersion();
        try (TempDirectory tempDirectory = new TempDirectory(this.getClass().getSimpleName());){
            Path signedApkPath = tempDirectory.getPath().resolve("signed.apk");
            ApkSigner.Builder apkSigner = new ApkSigner.Builder(ApkSigner.extractSignerConfigs(signingConfiguration, signWithV3)).setInputApk(apkPath.toFile()).setOutputApk(signedApkPath.toFile()).setV1SigningEnabled(signWithV1).setV2SigningEnabled(true).setV3SigningEnabled(signWithV3).setOtherSignersSignaturesPreserved(false).setMinSdkVersion(minSdkVersion);
            this.optStampSigningConfig.ifPresent(stampConfig -> apkSigner.setSourceStampSignerConfig(ApkSigner.convertToApksigSignerConfig(stampConfig.getSignerConfig())));
            apkSigner.build().sign();
            Files.move(signedApkPath, apkPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (ApkFormatException | IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e5) {
            throw CommandExecutionException.builder().withCause(e5).withInternalMessage("Unable to sign APK.").build();
        }
    }

    @CheckReturnValue
    public ModuleSplit signEmbeddedApks(ModuleSplit split) {
        ImmutableSet<ZipPath> wear1ApkPaths = ImmutableSet.copyOf(WearApkLocator.findEmbeddedWearApkPaths(split));
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (entry.getShouldSign() || wear1ApkPaths.contains(pathInApk)) {
                newEntries.add(this.signModuleEntry(split, entry));
                continue;
            }
            newEntries.add(entry);
        }
        return split.toBuilder().setEntries((List<ModuleEntry>)((Object)newEntries.build())).build();
    }

    private ModuleEntry signModuleEntry(ModuleSplit split, ModuleEntry entry) {
        try {
            Path tempDir = Files.createTempDirectory(this.tempDirectory.getPath(), this.getClass().getSimpleName(), new FileAttribute[0]);
            Path embeddedApk = tempDir.resolve("embedded.apk");
            try (InputStream entryContent = entry.getContent().openStream();){
                Files.copy(entryContent, embeddedApk, new CopyOption[0]);
            }
            this.signApk(embeddedApk, split);
            return entry.toBuilder().setContent(embeddedApk).setShouldSign(false).build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    private static ImmutableList<ApkSigner.SignerConfig> extractSignerConfigs(SigningConfiguration signingConfiguration, boolean signWithV3) {
        if (!signWithV3) {
            return ImmutableList.of(ApkSigner.convertToApksigSignerConfig(signingConfiguration.getSignerConfigForV1AndV2()));
        }
        ImmutableList.Builder signerConfigs = ImmutableList.builder();
        signerConfigs.add(ApkSigner.convertToApksigSignerConfig(signingConfiguration.getSignerConfig()));
        return signerConfigs.build();
    }

    private static ApkSigner.SignerConfig convertToApksigSignerConfig(SignerConfig signerConfig) {
        return new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signerConfig.getPrivateKey(), signerConfig.getCertificates()).build();
    }

    private boolean shouldSignWithV1Scheme(ModuleSplit split) {
        return split.getAndroidManifest().getEffectiveMinSdkVersion() < 24 || !VersionGuardedFeature.NO_V1_SIGNING_WHEN_POSSIBLE.enabledForVersion(this.bundletoolVersion);
    }

    private boolean shouldSignWithV3Scheme(ModuleSplit split) {
        int minApkTargetingSdkVersion;
        if (!this.optSigningConfig.isPresent()) {
            return false;
        }
        if (!this.optSigningConfig.get().getMinimumV3SigningApiVersion().isPresent()) {
            return true;
        }
        int minimumV3signingApiVersion = this.optSigningConfig.get().getMinimumV3SigningApiVersion().get();
        int minManifestSdkVersion = split.getAndroidManifest().getEffectiveMinSdkVersion();
        return Math.max(minManifestSdkVersion, minApkTargetingSdkVersion = TargetingUtils.getMinSdk(split.getApkTargeting().getSdkVersionTargeting())) >= minimumV3signingApiVersion;
    }
}

