/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.aapt.Resources;
import com.android.bundle.Config;
import com.android.bundle.Files;
import com.android.tools.build.bundletool.mergers.FusingAndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class BundleModuleMerger {
    public static AppBundle mergeNonRemovableInstallTimeModules(AppBundle appBundle, boolean overrideBundleToolVersion) throws IOException {
        ImmutableSet<BundleModule> bundleModulesToFuse = Stream.concat(Stream.of(appBundle.getBaseModule()), appBundle.getFeatureModules().values().stream().filter(module -> BundleModuleMerger.shouldMerge(module, appBundle.getBundleConfig(), overrideBundleToolVersion))).collect(ImmutableSet.toImmutableSet());
        if (bundleModulesToFuse.size() == 1) {
            return appBundle;
        }
        BundleModule.Builder mergedBaseModule = BundleModule.builder().setName(BundleModuleName.BASE_MODULE_NAME).setBundleConfig(appBundle.getBundleConfig());
        BundleModuleMerger.mergeApexTable(bundleModulesToFuse).ifPresent(mergedBaseModule::setApexConfig);
        BundleModuleMerger.mergeAssetsTable(bundleModulesToFuse).ifPresent(mergedBaseModule::setAssetsConfig);
        BundleModuleMerger.mergeNativeLibraryTable(bundleModulesToFuse).ifPresent(mergedBaseModule::setNativeConfig);
        BundleModuleMerger.mergeResourceTable(bundleModulesToFuse).ifPresent(mergedBaseModule::setResourceTable);
        BundleModuleMerger.mergeAndroidManifest(bundleModulesToFuse, mergedBaseModule);
        ImmutableList<ModuleEntry> renamedDexEntries = ModuleSplitsToShardMerger.renameDexFromAllModulesToSingleShard(BundleModuleMerger.getDexEntries(bundleModulesToFuse));
        mergedBaseModule.addEntries(BundleModuleMerger.getAllEntriesExceptDexAndSpecial(bundleModulesToFuse)).addEntries(renamedDexEntries);
        return appBundle.toBuilder().setRawModules(Stream.concat(Stream.of(mergedBaseModule.build()), appBundle.getModules().values().stream().filter(module -> !bundleModulesToFuse.contains(module))).collect(ImmutableSet.toImmutableSet())).build();
    }

    private static boolean shouldMerge(BundleModule module, Config.BundleConfig bundleConfig, boolean overrideBundleToolVersion) {
        return module.getAndroidManifest().getManifestDeliveryElement().map(manifestDeliveryElement -> {
            Version bundleToolVersion = BundleToolVersion.getVersionFromBundleConfig(bundleConfig);
            if (overrideBundleToolVersion && !VersionGuardedFeature.MERGE_INSTALL_TIME_MODULES_INTO_BASE.enabledForVersion(bundleToolVersion)) {
                return manifestDeliveryElement.hasInstallTimeElement() && !manifestDeliveryElement.hasModuleConditions();
            }
            return !manifestDeliveryElement.isInstallTimeRemovable(bundleToolVersion);
        }).orElse(false);
    }

    private static ImmutableSet<ModuleEntry> getAllEntriesExceptDexAndSpecial(Set<BundleModule> bundleModulesToFuse) {
        HashMap mergedEntriesByPath = new HashMap();
        bundleModulesToFuse.stream().flatMap(module -> module.getEntries().stream()).filter(moduleEntry -> !moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY) && !moduleEntry.isSpecialEntry()).forEach(moduleEntry -> {
            ModuleEntry existingModuleEntry = mergedEntriesByPath.putIfAbsent(moduleEntry.getPath(), moduleEntry);
            if (existingModuleEntry != null && !existingModuleEntry.equals(moduleEntry)) {
                throw InvalidBundleException.builder().withUserMessage("Existing module entry '%s' with different contents.", moduleEntry.getPath()).build();
            }
        });
        return ImmutableSet.copyOf(mergedEntriesByPath.values());
    }

    private static ImmutableListMultimap<BundleModuleName, ModuleEntry> getDexEntries(Set<BundleModule> bundleModulesToFuse) {
        return bundleModulesToFuse.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(BundleModule::getName, module -> module.getEntries().stream().filter(moduleEntry -> moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY))));
    }

    private static void mergeAndroidManifest(ImmutableSet<BundleModule> bundleModulesToFuse, BundleModule.Builder mergedBaseModule) {
        HashMultimap manifests = bundleModulesToFuse.stream().collect(Multimaps.toMultimap(BundleModule::getName, BundleModule::getAndroidManifest, HashMultimap::create));
        AndroidManifest mergedManifest = new FusingAndroidManifestMerger().merge(manifests);
        mergedManifest = mergedManifest.toEditor().setFusedModuleNames(bundleModulesToFuse.stream().map(module -> module.getName().getName()).collect(ImmutableList.toImmutableList())).save();
        mergedBaseModule.setAndroidManifest(mergedManifest);
    }

    private static Optional<Resources.ResourceTable> mergeResourceTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch(module -> module.getResourceTable().isPresent())) {
            return Optional.empty();
        }
        Resources.ResourceTable.Builder resourceTableMerged = Resources.ResourceTable.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getResourceTable().ifPresent(resourceTableMerged::mergeFrom);
        }
        return Optional.of(resourceTableMerged.build());
    }

    private static Optional<Files.NativeLibraries> mergeNativeLibraryTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch(module -> module.getNativeConfig().isPresent())) {
            return Optional.empty();
        }
        Files.NativeLibraries.Builder nativeLibrariesMerged = Files.NativeLibraries.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getNativeConfig().ifPresent(nativeLibrariesMerged::mergeFrom);
        }
        return Optional.of(nativeLibrariesMerged.build());
    }

    private static Optional<Files.Assets> mergeAssetsTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch(module -> module.getAssetsConfig().isPresent())) {
            return Optional.empty();
        }
        Files.Assets.Builder assetsMerged = Files.Assets.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getAssetsConfig().ifPresent(assetsMerged::mergeFrom);
        }
        return Optional.of(assetsMerged.build());
    }

    private static Optional<Files.ApexImages> mergeApexTable(ImmutableSet<BundleModule> bundleModulesToFuse) {
        if (bundleModulesToFuse.stream().noneMatch(module -> module.getApexConfig().isPresent())) {
            return Optional.empty();
        }
        Files.ApexImages.Builder apexImagesMerged = Files.ApexImages.newBuilder();
        for (BundleModule bundleModule : bundleModulesToFuse) {
            bundleModule.getApexConfig().ifPresent(apexImagesMerged::mergeFrom);
        }
        return Optional.of(apexImagesMerged.build());
    }

    private BundleModuleMerger() {
    }
}

