/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.AutoValue_TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.utils.DeviceTargetingUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class TargetedDirectorySegment {
    private static final Pattern DIRECTORY_SEGMENT_PATTERN = Pattern.compile("(?<base>.+?)#(?<key>.+?)_(?<value>.+)");
    private static final Pattern LANGUAGE_CODE_PATTERN = Pattern.compile("^[a-zA-Z]{2,3}$");
    private static final String LANG_KEY = "lang";
    private static final String TCF_KEY = "tcf";
    private static final String DEVICE_TIER_KEY = "tier";
    private static final ImmutableMap<String, TargetingDimension> KEY_TO_DIMENSION = ImmutableMap.builder().put("lang", TargetingDimension.LANGUAGE).put("tcf", TargetingDimension.TEXTURE_COMPRESSION_FORMAT).put("tier", TargetingDimension.DEVICE_TIER).build();
    private static final ImmutableSetMultimap<TargetingDimension, String> DIMENSION_TO_KEY = KEY_TO_DIMENSION.asMultimap().inverse();

    public abstract String getName();

    public abstract Targeting.AssetsDirectoryTargeting getTargeting();

    public Optional<TargetingDimension> getTargetingDimension() {
        ImmutableList<TargetingDimension> dimensions = TargetingUtils.getTargetingDimensions(this.getTargeting());
        Preconditions.checkState(dimensions.size() <= 1);
        if (dimensions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(dimensions.get(0));
    }

    @CheckReturnValue
    public TargetedDirectorySegment removeTargeting(TargetingDimension dimension) {
        Targeting.AssetsDirectoryTargeting.Builder newTargeting = this.getTargeting().toBuilder();
        if (dimension.equals((Object)TargetingDimension.ABI) && this.getTargeting().hasAbi()) {
            newTargeting.clearAbi();
        } else if (dimension.equals((Object)TargetingDimension.LANGUAGE) && this.getTargeting().hasLanguage()) {
            newTargeting.clearLanguage();
        } else if (dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT) && this.getTargeting().hasTextureCompressionFormat()) {
            newTargeting.clearTextureCompressionFormat();
        } else if (dimension.equals((Object)TargetingDimension.DEVICE_TIER) && this.getTargeting().hasDeviceTier()) {
            newTargeting.clearDeviceTier();
        } else {
            return this;
        }
        return new AutoValue_TargetedDirectorySegment(this.getName(), newTargeting.build());
    }

    public static TargetedDirectorySegment parse(String directorySegment) {
        if (!directorySegment.contains("#")) {
            return TargetedDirectorySegment.create(directorySegment);
        }
        Matcher matcher = DIRECTORY_SEGMENT_PATTERN.matcher(directorySegment);
        if (matcher.matches()) {
            return TargetedDirectorySegment.create(matcher.group("base"), matcher.group("key"), matcher.group("value"));
        }
        throw InvalidBundleException.builder().withUserMessage("Cannot tokenize targeted directory '%s'. Expecting either '<name>' or '<name>#<key>_<value>' format.", directorySegment).build();
    }

    public String toPathSegment() {
        ImmutableList<TargetingDimension> dimensions = TargetingUtils.getTargetingDimensions(this.getTargeting());
        Preconditions.checkState(dimensions.size() <= 1);
        Optional<String> key = TargetedDirectorySegment.getTargetingKey(this.getTargeting());
        Optional<String> value = TargetedDirectorySegment.getTargetingValue(this.getTargeting());
        if (!key.isPresent() || !value.isPresent()) {
            return this.getName();
        }
        return String.format("%s#%s_%s", this.getName(), key.get(), value.get());
    }

    public static boolean pathMayContain(String path, TargetingDimension dimension) {
        ImmutableCollection keys2 = DIMENSION_TO_KEY.get((Object)dimension);
        return keys2.stream().anyMatch(key -> path.contains("#" + key + "_"));
    }

    private static TargetedDirectorySegment create(String name) {
        return new AutoValue_TargetedDirectorySegment(name, Targeting.AssetsDirectoryTargeting.getDefaultInstance());
    }

    private static TargetedDirectorySegment create(String name, String key, String value) {
        return new AutoValue_TargetedDirectorySegment(name, TargetedDirectorySegment.toAssetsDirectoryTargeting(name, key, value));
    }

    private static Optional<String> getTargetingKey(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList<TargetingDimension> dimensions = TargetingUtils.getTargetingDimensions(targeting);
        Preconditions.checkArgument(dimensions.size() <= 1, "Multiple targeting for a same directory is not supported");
        if (targeting.hasLanguage()) {
            return Optional.of(LANG_KEY);
        }
        if (targeting.hasTextureCompressionFormat()) {
            return Optional.of(TCF_KEY);
        }
        if (targeting.hasDeviceTier()) {
            return Optional.of(DEVICE_TIER_KEY);
        }
        return Optional.empty();
    }

    private static Optional<String> getTargetingValue(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList<TargetingDimension> dimensions = TargetingUtils.getTargetingDimensions(targeting);
        Preconditions.checkArgument(dimensions.size() <= 1, "Multiple targeting for a same directory is not supported");
        if (targeting.hasLanguage()) {
            return Optional.of(Iterables.getOnlyElement(targeting.getLanguage().getValueList()));
        }
        if (targeting.hasTextureCompressionFormat()) {
            return Optional.ofNullable(TextureCompressionUtils.TARGETING_TO_TEXTURE.getOrDefault(Iterables.getOnlyElement(targeting.getTextureCompressionFormat().getValueList()).getAlias(), null));
        }
        if (targeting.hasDeviceTier()) {
            return Optional.of(Iterables.getOnlyElement(targeting.getDeviceTier().getValueList()));
        }
        return Optional.empty();
    }

    private static Targeting.AssetsDirectoryTargeting toAssetsDirectoryTargeting(String name, String key, String value) {
        if (!KEY_TO_DIMENSION.containsKey(key)) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' contains unsupported key '%s'.", name, key).build();
        }
        switch (KEY_TO_DIMENSION.get(key)) {
            case LANGUAGE: {
                return TargetedDirectorySegment.parseLanguage(name, value);
            }
            case TEXTURE_COMPRESSION_FORMAT: {
                return TargetedDirectorySegment.parseTextureCompressionFormat(name, value);
            }
            case DEVICE_TIER: {
                return TargetedDirectorySegment.parseDeviceTier(name, value);
            }
        }
        throw InvalidBundleException.builder().withUserMessage("Unrecognized key: '%s'.", key).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseTextureCompressionFormat(String name, String value) {
        if (!TextureCompressionUtils.TEXTURE_TO_TARGETING.containsKey(value)) {
            throw InvalidBundleException.builder().withUserMessage("Unrecognized value of the texture compression format targeting '%s' for directory '%s'.", value, name).build();
        }
        return Targeting.AssetsDirectoryTargeting.newBuilder().setTextureCompressionFormat(TextureCompressionUtils.TEXTURE_TO_TARGETING.get(value)).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseLanguage(String name, String value) {
        Matcher matcher = LANGUAGE_CODE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw InvalidBundleException.builder().withUserMessage("Expected 2- or 3-character language directory but got '%s' for directory '%s'.", value, name).build();
        }
        return Targeting.AssetsDirectoryTargeting.newBuilder().setLanguage(Targeting.LanguageTargeting.newBuilder().addValue(value.toLowerCase())).build();
    }

    private static Targeting.AssetsDirectoryTargeting parseDeviceTier(String name, String value) {
        DeviceTargetingUtils.validateDeviceTierForAssetsDirectory(name, value);
        return Targeting.AssetsDirectoryTargeting.newBuilder().setDeviceTier(Targeting.DeviceTierTargeting.newBuilder().addValue(value)).build();
    }
}

