/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.path;

import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.path.CertPathUtils;
import org.bouncycastle.cert.path.CertPathValidation;
import org.bouncycastle.cert.path.CertPathValidationContext;
import org.bouncycastle.cert.path.CertPathValidationException;
import org.bouncycastle.cert.path.CertPathValidationResult;
import org.bouncycastle.cert.path.CertPathValidationResultBuilder;

public class CertPath {
    private final X509CertificateHolder[] certificates;

    public CertPath(X509CertificateHolder[] x509CertificateHolderArray) {
        this.certificates = this.copyArray(x509CertificateHolderArray);
    }

    public X509CertificateHolder[] getCertificates() {
        return this.copyArray(this.certificates);
    }

    public CertPathValidationResult validate(CertPathValidation[] certPathValidationArray) {
        CertPathValidationContext certPathValidationContext = new CertPathValidationContext(CertPathUtils.getCriticalExtensionsOIDs(this.certificates));
        for (int i4 = 0; i4 != certPathValidationArray.length; ++i4) {
            for (int i5 = this.certificates.length - 1; i5 >= 0; --i5) {
                try {
                    certPathValidationContext.setIsEndEntity(i5 == 0);
                    certPathValidationArray[i4].validate(certPathValidationContext, this.certificates[i5]);
                    continue;
                }
                catch (CertPathValidationException certPathValidationException) {
                    return new CertPathValidationResult(certPathValidationContext, i5, i4, certPathValidationException);
                }
            }
        }
        return new CertPathValidationResult(certPathValidationContext);
    }

    public CertPathValidationResult evaluate(CertPathValidation[] certPathValidationArray) {
        CertPathValidationContext certPathValidationContext = new CertPathValidationContext(CertPathUtils.getCriticalExtensionsOIDs(this.certificates));
        CertPathValidationResultBuilder certPathValidationResultBuilder = new CertPathValidationResultBuilder();
        for (int i4 = 0; i4 != certPathValidationArray.length; ++i4) {
            for (int i5 = this.certificates.length - 1; i5 >= 0; --i5) {
                try {
                    certPathValidationContext.setIsEndEntity(i5 == 0);
                    certPathValidationArray[i4].validate(certPathValidationContext, this.certificates[i5]);
                    continue;
                }
                catch (CertPathValidationException certPathValidationException) {
                    certPathValidationResultBuilder.addException(certPathValidationException);
                }
            }
        }
        return certPathValidationResultBuilder.build();
    }

    private X509CertificateHolder[] copyArray(X509CertificateHolder[] x509CertificateHolderArray) {
        X509CertificateHolder[] x509CertificateHolderArray2 = new X509CertificateHolder[x509CertificateHolderArray.length];
        System.arraycopy(x509CertificateHolderArray, 0, x509CertificateHolderArray2, 0, x509CertificateHolderArray2.length);
        return x509CertificateHolderArray2;
    }

    public int length() {
        return this.certificates.length;
    }
}

