/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.util.Memoable;

public class MD4Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 16;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] X = new int[16];
    private int xOff;
    private static final int S11 = 3;
    private static final int S12 = 7;
    private static final int S13 = 11;
    private static final int S14 = 19;
    private static final int S21 = 3;
    private static final int S22 = 5;
    private static final int S23 = 9;
    private static final int S24 = 13;
    private static final int S31 = 3;
    private static final int S32 = 9;
    private static final int S33 = 11;
    private static final int S34 = 15;

    public MD4Digest() {
        this.reset();
    }

    public MD4Digest(MD4Digest mD4Digest) {
        super(mD4Digest);
        this.copyIn(mD4Digest);
    }

    private void copyIn(MD4Digest mD4Digest) {
        super.copyIn(mD4Digest);
        this.H1 = mD4Digest.H1;
        this.H2 = mD4Digest.H2;
        this.H3 = mD4Digest.H3;
        this.H4 = mD4Digest.H4;
        System.arraycopy(mD4Digest.X, 0, this.X, 0, mD4Digest.X.length);
        this.xOff = mD4Digest.xOff;
    }

    public String getAlgorithmName() {
        return "MD4";
    }

    public int getDigestSize() {
        return 16;
    }

    protected void processWord(byte[] byArray, int n4) {
        this.X[this.xOff++] = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long l4) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l4 & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(l4 >>> 32);
    }

    private void unpackWord(int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)n4;
        byArray[n5 + 1] = (byte)(n4 >>> 8);
        byArray[n5 + 2] = (byte)(n4 >>> 16);
        byArray[n5 + 3] = (byte)(n4 >>> 24);
    }

    public int doFinal(byte[] byArray, int n4) {
        this.finish();
        this.unpackWord(this.H1, byArray, n4);
        this.unpackWord(this.H2, byArray, n4 + 4);
        this.unpackWord(this.H3, byArray, n4 + 8);
        this.unpackWord(this.H4, byArray, n4 + 12);
        this.reset();
        return 16;
    }

    public void reset() {
        super.reset();
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.xOff = 0;
        for (int i4 = 0; i4 != this.X.length; ++i4) {
            this.X[i4] = 0;
        }
    }

    private int rotateLeft(int n4, int n5) {
        return n4 << n5 | n4 >>> 32 - n5;
    }

    private int F(int n4, int n5, int n6) {
        return n4 & n5 | ~n4 & n6;
    }

    private int G(int n4, int n5, int n6) {
        return n4 & n5 | n4 & n6 | n5 & n6;
    }

    private int H(int n4, int n5, int n6) {
        return n4 ^ n5 ^ n6;
    }

    protected void processBlock() {
        int n4 = this.H1;
        int n5 = this.H2;
        int n6 = this.H3;
        int n7 = this.H4;
        n4 = this.rotateLeft(n4 + this.F(n5, n6, n7) + this.X[0], 3);
        n7 = this.rotateLeft(n7 + this.F(n4, n5, n6) + this.X[1], 7);
        n6 = this.rotateLeft(n6 + this.F(n7, n4, n5) + this.X[2], 11);
        n5 = this.rotateLeft(n5 + this.F(n6, n7, n4) + this.X[3], 19);
        n4 = this.rotateLeft(n4 + this.F(n5, n6, n7) + this.X[4], 3);
        n7 = this.rotateLeft(n7 + this.F(n4, n5, n6) + this.X[5], 7);
        n6 = this.rotateLeft(n6 + this.F(n7, n4, n5) + this.X[6], 11);
        n5 = this.rotateLeft(n5 + this.F(n6, n7, n4) + this.X[7], 19);
        n4 = this.rotateLeft(n4 + this.F(n5, n6, n7) + this.X[8], 3);
        n7 = this.rotateLeft(n7 + this.F(n4, n5, n6) + this.X[9], 7);
        n6 = this.rotateLeft(n6 + this.F(n7, n4, n5) + this.X[10], 11);
        n5 = this.rotateLeft(n5 + this.F(n6, n7, n4) + this.X[11], 19);
        n4 = this.rotateLeft(n4 + this.F(n5, n6, n7) + this.X[12], 3);
        n7 = this.rotateLeft(n7 + this.F(n4, n5, n6) + this.X[13], 7);
        n6 = this.rotateLeft(n6 + this.F(n7, n4, n5) + this.X[14], 11);
        n5 = this.rotateLeft(n5 + this.F(n6, n7, n4) + this.X[15], 19);
        n4 = this.rotateLeft(n4 + this.G(n5, n6, n7) + this.X[0] + 1518500249, 3);
        n7 = this.rotateLeft(n7 + this.G(n4, n5, n6) + this.X[4] + 1518500249, 5);
        n6 = this.rotateLeft(n6 + this.G(n7, n4, n5) + this.X[8] + 1518500249, 9);
        n5 = this.rotateLeft(n5 + this.G(n6, n7, n4) + this.X[12] + 1518500249, 13);
        n4 = this.rotateLeft(n4 + this.G(n5, n6, n7) + this.X[1] + 1518500249, 3);
        n7 = this.rotateLeft(n7 + this.G(n4, n5, n6) + this.X[5] + 1518500249, 5);
        n6 = this.rotateLeft(n6 + this.G(n7, n4, n5) + this.X[9] + 1518500249, 9);
        n5 = this.rotateLeft(n5 + this.G(n6, n7, n4) + this.X[13] + 1518500249, 13);
        n4 = this.rotateLeft(n4 + this.G(n5, n6, n7) + this.X[2] + 1518500249, 3);
        n7 = this.rotateLeft(n7 + this.G(n4, n5, n6) + this.X[6] + 1518500249, 5);
        n6 = this.rotateLeft(n6 + this.G(n7, n4, n5) + this.X[10] + 1518500249, 9);
        n5 = this.rotateLeft(n5 + this.G(n6, n7, n4) + this.X[14] + 1518500249, 13);
        n4 = this.rotateLeft(n4 + this.G(n5, n6, n7) + this.X[3] + 1518500249, 3);
        n7 = this.rotateLeft(n7 + this.G(n4, n5, n6) + this.X[7] + 1518500249, 5);
        n6 = this.rotateLeft(n6 + this.G(n7, n4, n5) + this.X[11] + 1518500249, 9);
        n5 = this.rotateLeft(n5 + this.G(n6, n7, n4) + this.X[15] + 1518500249, 13);
        n4 = this.rotateLeft(n4 + this.H(n5, n6, n7) + this.X[0] + 1859775393, 3);
        n7 = this.rotateLeft(n7 + this.H(n4, n5, n6) + this.X[8] + 1859775393, 9);
        n6 = this.rotateLeft(n6 + this.H(n7, n4, n5) + this.X[4] + 1859775393, 11);
        n5 = this.rotateLeft(n5 + this.H(n6, n7, n4) + this.X[12] + 1859775393, 15);
        n4 = this.rotateLeft(n4 + this.H(n5, n6, n7) + this.X[2] + 1859775393, 3);
        n7 = this.rotateLeft(n7 + this.H(n4, n5, n6) + this.X[10] + 1859775393, 9);
        n6 = this.rotateLeft(n6 + this.H(n7, n4, n5) + this.X[6] + 1859775393, 11);
        n5 = this.rotateLeft(n5 + this.H(n6, n7, n4) + this.X[14] + 1859775393, 15);
        n4 = this.rotateLeft(n4 + this.H(n5, n6, n7) + this.X[1] + 1859775393, 3);
        n7 = this.rotateLeft(n7 + this.H(n4, n5, n6) + this.X[9] + 1859775393, 9);
        n6 = this.rotateLeft(n6 + this.H(n7, n4, n5) + this.X[5] + 1859775393, 11);
        n5 = this.rotateLeft(n5 + this.H(n6, n7, n4) + this.X[13] + 1859775393, 15);
        n4 = this.rotateLeft(n4 + this.H(n5, n6, n7) + this.X[3] + 1859775393, 3);
        n7 = this.rotateLeft(n7 + this.H(n4, n5, n6) + this.X[11] + 1859775393, 9);
        n6 = this.rotateLeft(n6 + this.H(n7, n4, n5) + this.X[7] + 1859775393, 11);
        n5 = this.rotateLeft(n5 + this.H(n6, n7, n4) + this.X[15] + 1859775393, 15);
        this.H1 += n4;
        this.H2 += n5;
        this.H3 += n6;
        this.H4 += n7;
        this.xOff = 0;
        for (int i4 = 0; i4 != this.X.length; ++i4) {
            this.X[i4] = 0;
        }
    }

    public Memoable copy() {
        return new MD4Digest(this);
    }

    public void reset(Memoable memoable) {
        MD4Digest mD4Digest = (MD4Digest)memoable;
        this.copyIn(mD4Digest);
    }
}

