/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Pack;

public class SipHash
implements Mac {
    protected final int c;
    protected final int d;
    protected long k0;
    protected long k1;
    protected long v0;
    protected long v1;
    protected long v2;
    protected long v3;
    protected long m = 0L;
    protected int wordPos = 0;
    protected int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int n4, int n5) {
        this.c = n4;
        this.d = n5;
    }

    public String getAlgorithmName() {
        return "SipHash-" + this.c + "-" + this.d;
    }

    public int getMacSize() {
        return 8;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
        }
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        byte[] byArray = keyParameter.getKey();
        if (byArray.length != 16) {
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        this.k0 = Pack.littleEndianToLong(byArray, 0);
        this.k1 = Pack.littleEndianToLong(byArray, 8);
        this.reset();
    }

    public void update(byte by) throws IllegalStateException {
        this.m >>>= 8;
        this.m |= ((long)by & 0xFFL) << 56;
        if (++this.wordPos == 8) {
            this.processMessageWord();
            this.wordPos = 0;
        }
    }

    public void update(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalStateException {
        int n6;
        int n7 = n5 & 0xFFFFFFF8;
        if (this.wordPos == 0) {
            for (n6 = 0; n6 < n7; n6 += 8) {
                this.m = Pack.littleEndianToLong(byArray, n4 + n6);
                this.processMessageWord();
            }
            while (n6 < n5) {
                this.m >>>= 8;
                this.m |= ((long)byArray[n4 + n6] & 0xFFL) << 56;
                ++n6;
            }
            this.wordPos = n5 - n7;
        } else {
            int n8 = this.wordPos << 3;
            while (n6 < n7) {
                long l4 = Pack.littleEndianToLong(byArray, n4 + n6);
                this.m = l4 << n8 | this.m >>> -n8;
                this.processMessageWord();
                this.m = l4;
                n6 += 8;
            }
            while (n6 < n5) {
                this.m >>>= 8;
                this.m |= ((long)byArray[n4 + n6] & 0xFFL) << 56;
                if (++this.wordPos == 8) {
                    this.processMessageWord();
                    this.wordPos = 0;
                }
                ++n6;
            }
        }
    }

    public long doFinal() throws DataLengthException, IllegalStateException {
        this.m >>>= 7 - this.wordPos << 3;
        this.m >>>= 8;
        this.m |= ((long)((this.wordCount << 3) + this.wordPos) & 0xFFL) << 56;
        this.processMessageWord();
        this.v2 ^= 0xFFL;
        this.applySipRounds(this.d);
        long l4 = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return l4;
    }

    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        long l4 = this.doFinal();
        Pack.longToLittleEndian(l4, byArray, n4);
        return 8;
    }

    public void reset() {
        this.v0 = this.k0 ^ 0x736F6D6570736575L;
        this.v1 = this.k1 ^ 0x646F72616E646F6DL;
        this.v2 = this.k0 ^ 0x6C7967656E657261L;
        this.v3 = this.k1 ^ 0x7465646279746573L;
        this.m = 0L;
        this.wordPos = 0;
        this.wordCount = 0;
    }

    protected void processMessageWord() {
        ++this.wordCount;
        this.v3 ^= this.m;
        this.applySipRounds(this.c);
        this.v0 ^= this.m;
    }

    protected void applySipRounds(int n4) {
        long l4 = this.v0;
        long l5 = this.v1;
        long l6 = this.v2;
        long l7 = this.v3;
        for (int i4 = 0; i4 < n4; ++i4) {
            l4 += l5;
            l6 += l7;
            l5 = SipHash.rotateLeft(l5, 13);
            l7 = SipHash.rotateLeft(l7, 16);
            l5 ^= l4;
            l7 ^= l6;
            l4 = SipHash.rotateLeft(l4, 32);
            l6 += l5;
            l4 += l7;
            l5 = SipHash.rotateLeft(l5, 17);
            l7 = SipHash.rotateLeft(l7, 21);
            l5 ^= l6;
            l7 ^= l4;
            l6 = SipHash.rotateLeft(l6, 32);
        }
        this.v0 = l4;
        this.v1 = l5;
        this.v2 = l6;
        this.v3 = l7;
    }

    protected static long rotateLeft(long l4, int n4) {
        return l4 << n4 | l4 >>> -n4;
    }
}

