/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public abstract class Primes {
    public static final int SMALL_FACTOR_LIMIT = 211;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);

    public static STOutput generateSTRandomPrime(Digest digest, int n4, byte[] byArray) {
        if (digest == null) {
            throw new IllegalArgumentException("'hash' cannot be null");
        }
        if (n4 < 2) {
            throw new IllegalArgumentException("'length' must be >= 2");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("'inputSeed' cannot be null or empty");
        }
        return Primes.implSTRandomPrime(digest, n4, Arrays.clone(byArray));
    }

    public static MROutput enhancedMRProbablePrimeTest(BigInteger bigInteger, SecureRandom secureRandom, int n4) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom == null) {
            throw new IllegalArgumentException("'random' cannot be null");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        if (bigInteger.bitLength() == 2) {
            return MROutput.probablyPrime();
        }
        if (!bigInteger.testBit(0)) {
            return MROutput.provablyCompositeWithFactor(Primes.TWO);
        }
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        int n5 = bigInteger3.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger3.shiftRight(n5);
        for (int i4 = 0; i4 < n4; ++i4) {
            BigInteger bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger4, secureRandom);
            BigInteger bigInteger7 = bigInteger6.gcd(bigInteger2);
            if (bigInteger7.compareTo(ONE) > 0) {
                return MROutput.provablyCompositeWithFactor(bigInteger7);
            }
            BigInteger bigInteger8 = bigInteger6.modPow(bigInteger5, bigInteger2);
            if (bigInteger8.equals(ONE) || bigInteger8.equals(bigInteger3)) continue;
            boolean bl = false;
            BigInteger bigInteger9 = bigInteger8;
            for (int i5 = 1; i5 < n5; ++i5) {
                if ((bigInteger8 = bigInteger8.modPow(TWO, bigInteger2)).equals(bigInteger3)) {
                    bl = true;
                    break;
                }
                if (bigInteger8.equals(ONE)) break;
                bigInteger9 = bigInteger8;
            }
            if (bl) continue;
            if (!bigInteger8.equals(ONE)) {
                bigInteger9 = bigInteger8;
                if (!(bigInteger8 = bigInteger8.modPow(TWO, bigInteger2)).equals(ONE)) {
                    bigInteger9 = bigInteger8;
                }
            }
            if ((bigInteger7 = bigInteger9.subtract(ONE).gcd(bigInteger2)).compareTo(ONE) > 0) {
                return MROutput.provablyCompositeWithFactor(bigInteger7);
            }
            return MROutput.provablyCompositeNotPrimePower();
        }
        return MROutput.probablyPrime();
    }

    public static boolean hasAnySmallFactors(BigInteger bigInteger) {
        Primes.checkCandidate(bigInteger, "candidate");
        return Primes.implHasAnySmallFactors(bigInteger);
    }

    public static boolean isMRProbablePrime(BigInteger bigInteger, SecureRandom secureRandom, int n4) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom == null) {
            throw new IllegalArgumentException("'random' cannot be null");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        if (bigInteger.bitLength() == 2) {
            return true;
        }
        if (!bigInteger.testBit(0)) {
            return false;
        }
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        BigInteger bigInteger4 = bigInteger.subtract(TWO);
        int n5 = bigInteger3.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger3.shiftRight(n5);
        for (int i4 = 0; i4 < n4; ++i4) {
            BigInteger bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger4, secureRandom);
            if (Primes.implMRProbablePrimeToBase(bigInteger2, bigInteger3, bigInteger5, n5, bigInteger6)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2) {
        Primes.checkCandidate(bigInteger, "candidate");
        Primes.checkCandidate(bigInteger2, "base");
        if (bigInteger2.compareTo(bigInteger.subtract(ONE)) >= 0) {
            throw new IllegalArgumentException("'base' must be < ('candidate' - 1)");
        }
        if (bigInteger.bitLength() == 2) {
            return true;
        }
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger.subtract(ONE);
        int n4 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger4.shiftRight(n4);
        return Primes.implMRProbablePrimeToBase(bigInteger3, bigInteger4, bigInteger5, n4, bigInteger2);
    }

    private static void checkCandidate(BigInteger bigInteger, String string) {
        if (bigInteger == null || bigInteger.signum() < 1 || bigInteger.bitLength() < 2) {
            throw new IllegalArgumentException("'" + string + "' must be non-null and >= 2");
        }
    }

    private static boolean implHasAnySmallFactors(BigInteger bigInteger) {
        int n4 = 223092870;
        int n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 2 == 0 || n5 % 3 == 0 || n5 % 5 == 0 || n5 % 7 == 0 || n5 % 11 == 0 || n5 % 13 == 0 || n5 % 17 == 0 || n5 % 19 == 0 || n5 % 23 == 0) {
            return true;
        }
        n4 = 58642669;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 29 == 0 || n5 % 31 == 0 || n5 % 37 == 0 || n5 % 41 == 0 || n5 % 43 == 0) {
            return true;
        }
        n4 = 600662303;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 47 == 0 || n5 % 53 == 0 || n5 % 59 == 0 || n5 % 61 == 0 || n5 % 67 == 0) {
            return true;
        }
        n4 = 33984931;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 71 == 0 || n5 % 73 == 0 || n5 % 79 == 0 || n5 % 83 == 0) {
            return true;
        }
        n4 = 89809099;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 89 == 0 || n5 % 97 == 0 || n5 % 101 == 0 || n5 % 103 == 0) {
            return true;
        }
        n4 = 167375713;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 107 == 0 || n5 % 109 == 0 || n5 % 113 == 0 || n5 % 127 == 0) {
            return true;
        }
        n4 = 371700317;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 131 == 0 || n5 % 137 == 0 || n5 % 139 == 0 || n5 % 149 == 0) {
            return true;
        }
        n4 = 645328247;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 151 == 0 || n5 % 157 == 0 || n5 % 163 == 0 || n5 % 167 == 0) {
            return true;
        }
        n4 = 1070560157;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        if (n5 % 173 == 0 || n5 % 179 == 0 || n5 % 181 == 0 || n5 % 191 == 0) {
            return true;
        }
        n4 = 1596463769;
        n5 = bigInteger.mod(BigInteger.valueOf(n4)).intValue();
        return n5 % 193 == 0 || n5 % 197 == 0 || n5 % 199 == 0 || n5 % 211 == 0;
    }

    private static boolean implMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n4, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
        if (bigInteger5.equals(ONE) || bigInteger5.equals(bigInteger2)) {
            return true;
        }
        boolean bl = false;
        for (int i4 = 1; i4 < n4; ++i4) {
            if ((bigInteger5 = bigInteger5.modPow(TWO, bigInteger)).equals(bigInteger2)) {
                bl = true;
                break;
            }
            if (!bigInteger5.equals(ONE)) continue;
            return false;
        }
        return bl;
    }

    private static STOutput implSTRandomPrime(Digest digest, int n4, byte[] byArray) {
        int n5 = digest.getDigestSize();
        if (n4 < 33) {
            int n6 = 0;
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = new byte[n5];
            do {
                Primes.hash(digest, byArray, byArray2, 0);
                Primes.inc(byArray, 1);
                Primes.hash(digest, byArray, byArray3, 0);
                Primes.inc(byArray, 1);
                int n7 = Primes.extract32(byArray2) ^ Primes.extract32(byArray3);
                n7 &= -1 >>> 32 - n4;
                ++n6;
                long l4 = (long)(n7 |= 1 << n4 - 1 | 1) & 0xFFFFFFFFL;
                if (!Primes.isPrime32(l4)) continue;
                return new STOutput(BigInteger.valueOf(l4), byArray, n6);
            } while (n6 <= 4 * n4);
            throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
        }
        STOutput sTOutput = Primes.implSTRandomPrime(digest, (n4 + 3) / 2, byArray);
        BigInteger bigInteger = sTOutput.getPrime();
        byArray = sTOutput.getPrimeSeed();
        int n8 = sTOutput.getPrimeGenCounter();
        int n9 = 8 * n5;
        int n10 = (n4 - 1) / n9;
        int n11 = n8;
        BigInteger bigInteger2 = Primes.hashGen(digest, byArray, n10 + 1);
        bigInteger2 = bigInteger2.mod(ONE.shiftLeft(n4 - 1)).setBit(n4 - 1);
        BigInteger bigInteger3 = bigInteger.shiftLeft(1);
        BigInteger bigInteger4 = bigInteger2.subtract(ONE).divide(bigInteger3).add(ONE).shiftLeft(1);
        int n12 = 0;
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger).add(ONE);
        while (true) {
            if (bigInteger5.bitLength() > n4) {
                bigInteger4 = ONE.shiftLeft(n4 - 1).subtract(ONE).divide(bigInteger3).add(ONE).shiftLeft(1);
                bigInteger5 = bigInteger4.multiply(bigInteger).add(ONE);
            }
            ++n8;
            if (!Primes.implHasAnySmallFactors(bigInteger5)) {
                BigInteger bigInteger6 = Primes.hashGen(digest, byArray, n10 + 1);
                bigInteger6 = bigInteger6.mod(bigInteger5.subtract(THREE)).add(TWO);
                bigInteger4 = bigInteger4.add(BigInteger.valueOf(n12));
                n12 = 0;
                BigInteger bigInteger7 = bigInteger6.modPow(bigInteger4, bigInteger5);
                if (bigInteger5.gcd(bigInteger7.subtract(ONE)).equals(ONE) && bigInteger7.modPow(bigInteger, bigInteger5).equals(ONE)) {
                    return new STOutput(bigInteger5, byArray, n8);
                }
            } else {
                Primes.inc(byArray, n10 + 1);
            }
            if (n8 >= 4 * n4 + n11) {
                throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
            }
            n12 += 2;
            bigInteger5 = bigInteger5.add(bigInteger3);
        }
    }

    private static int extract32(byte[] byArray) {
        int n4 = 0;
        int n5 = Math.min(4, byArray.length);
        for (int i4 = 0; i4 < n5; ++i4) {
            int n6 = byArray[byArray.length - (i4 + 1)] & 0xFF;
            n4 |= n6 << 8 * i4;
        }
        return n4;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n4) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n4);
    }

    private static BigInteger hashGen(Digest digest, byte[] byArray, int n4) {
        int n5 = digest.getDigestSize();
        int n6 = n4 * n5;
        byte[] byArray2 = new byte[n6];
        for (int i4 = 0; i4 < n4; ++i4) {
            Primes.hash(digest, byArray, byArray2, n6 -= n5);
            Primes.inc(byArray, 1);
        }
        return new BigInteger(1, byArray2);
    }

    private static void inc(byte[] byArray, int n4) {
        int n5 = byArray.length;
        while (n4 > 0 && --n5 >= 0) {
            byArray[n5] = (byte)(n4 += byArray[n5] & 0xFF);
            n4 >>>= 8;
        }
    }

    private static boolean isPrime32(long l4) {
        if (l4 >>> 32 != 0L) {
            throw new IllegalArgumentException("Size limit exceeded");
        }
        if (l4 <= 5L) {
            return l4 == 2L || l4 == 3L || l4 == 5L;
        }
        if ((l4 & 1L) == 0L || l4 % 3L == 0L || l4 % 5L == 0L) {
            return false;
        }
        long[] lArray = new long[]{1L, 7L, 11L, 13L, 17L, 19L, 23L, 29L};
        long l5 = 0L;
        int n4 = 1;
        while (true) {
            if (n4 < lArray.length) {
                long l6 = l5 + lArray[n4];
                if (l4 % l6 == 0L) {
                    return l4 < 30L;
                }
                ++n4;
                continue;
            }
            if ((l5 += 30L) * l5 >= l4) {
                return true;
            }
            n4 = 0;
        }
    }

    public static class MROutput {
        private boolean provablyComposite;
        private BigInteger factor;

        private static MROutput probablyPrime() {
            return new MROutput(false, null);
        }

        private static MROutput provablyCompositeWithFactor(BigInteger bigInteger) {
            return new MROutput(true, bigInteger);
        }

        private static MROutput provablyCompositeNotPrimePower() {
            return new MROutput(true, null);
        }

        private MROutput(boolean bl, BigInteger bigInteger) {
            this.provablyComposite = bl;
            this.factor = bigInteger;
        }

        public BigInteger getFactor() {
            return this.factor;
        }

        public boolean isProvablyComposite() {
            return this.provablyComposite;
        }

        public boolean isNotPrimePower() {
            return this.provablyComposite && this.factor == null;
        }
    }

    public static class STOutput {
        private BigInteger prime;
        private byte[] primeSeed;
        private int primeGenCounter;

        private STOutput(BigInteger bigInteger, byte[] byArray, int n4) {
            this.prime = bigInteger;
            this.primeSeed = byArray;
            this.primeGenCounter = n4;
        }

        public BigInteger getPrime() {
            return this.prime;
        }

        public byte[] getPrimeSeed() {
            return this.primeSeed;
        }

        public int getPrimeGenCounter() {
            return this.primeGenCounter;
        }
    }
}

