/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import org.bouncycastle.math.raw.Nat256;

public abstract class Mont256 {
    private static final long M = 0xFFFFFFFFL;

    public static int inverse32(int n4) {
        int n5 = n4;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        return n5;
    }

    public static void multAdd(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n4) {
        int n5 = 0;
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int i4 = 0; i4 < 8; ++i4) {
            long l5 = (long)nArray3[0] & 0xFFFFFFFFL;
            long l6 = (long)nArray[i4] & 0xFFFFFFFFL;
            long l7 = l6 * l4;
            long l8 = (l7 & 0xFFFFFFFFL) + l5;
            long l9 = (long)((int)l8 * n4) & 0xFFFFFFFFL;
            long l10 = l9 * ((long)nArray4[0] & 0xFFFFFFFFL);
            l8 += l10 & 0xFFFFFFFFL;
            l8 = (l8 >>> 32) + (l7 >>> 32) + (l10 >>> 32);
            for (int i5 = 1; i5 < 8; ++i5) {
                l7 = l6 * ((long)nArray2[i5] & 0xFFFFFFFFL);
                l10 = l9 * ((long)nArray4[i5] & 0xFFFFFFFFL);
                nArray3[i5 - 1] = (int)(l8 += (l7 & 0xFFFFFFFFL) + (l10 & 0xFFFFFFFFL) + ((long)nArray3[i5] & 0xFFFFFFFFL));
                l8 = (l8 >>> 32) + (l7 >>> 32) + (l10 >>> 32);
            }
            nArray3[7] = (int)(l8 += (long)n5 & 0xFFFFFFFFL);
            n5 = (int)(l8 >>> 32);
        }
        if (n5 != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void multAddXF(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n4 = 0;
        long l4 = (long)nArray2[0] & 0xFFFFFFFFL;
        for (int i4 = 0; i4 < 8; ++i4) {
            long l5 = (long)nArray[i4] & 0xFFFFFFFFL;
            long l6 = l5 * l4 + ((long)nArray3[0] & 0xFFFFFFFFL);
            long l7 = l6 & 0xFFFFFFFFL;
            l6 = (l6 >>> 32) + l7;
            for (int i5 = 1; i5 < 8; ++i5) {
                long l8 = l5 * ((long)nArray2[i5] & 0xFFFFFFFFL);
                long l9 = l7 * ((long)nArray4[i5] & 0xFFFFFFFFL);
                nArray3[i5 - 1] = (int)(l6 += (l8 & 0xFFFFFFFFL) + (l9 & 0xFFFFFFFFL) + ((long)nArray3[i5] & 0xFFFFFFFFL));
                l6 = (l6 >>> 32) + (l8 >>> 32) + (l9 >>> 32);
            }
            nArray3[7] = (int)(l6 += (long)n4 & 0xFFFFFFFFL);
            n4 = (int)(l6 >>> 32);
        }
        if (n4 != 0 || Nat256.gte(nArray3, nArray4)) {
            Nat256.sub(nArray3, nArray4, nArray3);
        }
    }

    public static void reduce(int[] nArray, int[] nArray2, int n4) {
        for (int i4 = 0; i4 < 8; ++i4) {
            int n5 = nArray[0];
            long l4 = (long)(n5 * n4) & 0xFFFFFFFFL;
            long l5 = l4 * ((long)nArray2[0] & 0xFFFFFFFFL) + ((long)n5 & 0xFFFFFFFFL);
            l5 >>>= 32;
            for (int i5 = 1; i5 < 8; ++i5) {
                nArray[i5 - 1] = (int)(l5 += l4 * ((long)nArray2[i5] & 0xFFFFFFFFL) + ((long)nArray[i5] & 0xFFFFFFFFL));
                l5 >>>= 32;
            }
            nArray[7] = (int)l5;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }

    public static void reduceXF(int[] nArray, int[] nArray2) {
        for (int i4 = 0; i4 < 8; ++i4) {
            long l4;
            int n4 = nArray[0];
            long l5 = l4 = (long)n4 & 0xFFFFFFFFL;
            for (int i5 = 1; i5 < 8; ++i5) {
                nArray[i5 - 1] = (int)(l5 += l4 * ((long)nArray2[i5] & 0xFFFFFFFFL) + ((long)nArray[i5] & 0xFFFFFFFFL));
                l5 >>>= 32;
            }
            nArray[7] = (int)l5;
        }
        if (Nat256.gte(nArray, nArray2)) {
            Nat256.sub(nArray, nArray2, nArray);
        }
    }
}

