/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss;

import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import org.bouncycastle.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import org.bouncycastle.pqc.crypto.gmss.Treehash;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import org.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;

public class GMSSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GMSSRandom gmssRandom;
    private Digest messDigestTree;
    private byte[][] currentSeeds;
    private byte[][] nextNextSeeds;
    private byte[][] currentRootSigs;
    private GMSSDigestProvider digestProvider;
    private int mdLength;
    private int numLayer;
    private boolean initialized = false;
    private GMSSParameters gmssPS;
    private int[] heightOfTrees;
    private int[] otsIndex;
    private int[] K;
    private GMSSKeyGenerationParameters gmssParams;
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.3";

    public GMSSKeyPairGenerator(GMSSDigestProvider gMSSDigestProvider) {
        this.digestProvider = gMSSDigestProvider;
        this.messDigestTree = gMSSDigestProvider.get();
        this.mdLength = this.messDigestTree.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTree);
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        int n4;
        Object object;
        int n5;
        if (!this.initialized) {
            this.initializeDefault();
        }
        byte[][][] byArrayArray = new byte[this.numLayer][][];
        byte[][][] byArrayArray2 = new byte[this.numLayer - 1][][];
        Treehash[][] treehashArray = new Treehash[this.numLayer][];
        Treehash[][] treehashArray2 = new Treehash[this.numLayer - 1][];
        Vector[] vectorArray = new Vector[this.numLayer];
        Vector[] vectorArray2 = new Vector[this.numLayer - 1];
        Vector[][] vectorArray3 = new Vector[this.numLayer][];
        Vector[][] vectorArray4 = new Vector[this.numLayer - 1][];
        for (int i4 = 0; i4 < this.numLayer; ++i4) {
            byArrayArray[i4] = new byte[this.heightOfTrees[i4]][this.mdLength];
            treehashArray[i4] = new Treehash[this.heightOfTrees[i4] - this.K[i4]];
            if (i4 > 0) {
                byArrayArray2[i4 - 1] = new byte[this.heightOfTrees[i4]][this.mdLength];
                treehashArray2[i4 - 1] = new Treehash[this.heightOfTrees[i4] - this.K[i4]];
            }
            vectorArray[i4] = new Vector();
            if (i4 <= 0) continue;
            vectorArray2[i4 - 1] = new Vector();
        }
        byte[][] byArray = new byte[this.numLayer][this.mdLength];
        byte[][] byArray2 = new byte[this.numLayer - 1][this.mdLength];
        byte[][] byArray3 = new byte[this.numLayer][this.mdLength];
        for (n5 = 0; n5 < this.numLayer; ++n5) {
            System.arraycopy(this.currentSeeds[n5], 0, byArray3[n5], 0, this.mdLength);
        }
        this.currentRootSigs = new byte[this.numLayer - 1][this.mdLength];
        for (n5 = this.numLayer - 1; n5 >= 0; --n5) {
            object = new GMSSRootCalc(this.heightOfTrees[n5], this.K[n5], this.digestProvider);
            try {
                object = n5 == this.numLayer - 1 ? this.generateCurrentAuthpathAndRoot(null, vectorArray[n5], byArray3[n5], n5) : this.generateCurrentAuthpathAndRoot(byArray[n5 + 1], vectorArray[n5], byArray3[n5], n5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (n4 = 0; n4 < this.heightOfTrees[n5]; ++n4) {
                System.arraycopy(((GMSSRootCalc)object).getAuthPath()[n4], 0, byArrayArray[n5][n4], 0, this.mdLength);
            }
            vectorArray3[n5] = ((GMSSRootCalc)object).getRetain();
            treehashArray[n5] = ((GMSSRootCalc)object).getTreehash();
            System.arraycopy(((GMSSRootCalc)object).getRoot(), 0, byArray[n5], 0, this.mdLength);
        }
        for (n5 = this.numLayer - 2; n5 >= 0; --n5) {
            object = this.generateNextAuthpathAndRoot(vectorArray2[n5], byArray3[n5 + 1], n5 + 1);
            for (n4 = 0; n4 < this.heightOfTrees[n5 + 1]; ++n4) {
                System.arraycopy(((GMSSRootCalc)object).getAuthPath()[n4], 0, byArrayArray2[n5][n4], 0, this.mdLength);
            }
            vectorArray4[n5] = ((GMSSRootCalc)object).getRetain();
            treehashArray2[n5] = ((GMSSRootCalc)object).getTreehash();
            System.arraycopy(((GMSSRootCalc)object).getRoot(), 0, byArray2[n5], 0, this.mdLength);
            System.arraycopy(byArray3[n5 + 1], 0, this.nextNextSeeds[n5], 0, this.mdLength);
        }
        GMSSPublicKeyParameters gMSSPublicKeyParameters = new GMSSPublicKeyParameters(byArray[0], this.gmssPS);
        object = new GMSSPrivateKeyParameters(this.currentSeeds, this.nextNextSeeds, byArrayArray, byArrayArray2, treehashArray, treehashArray2, vectorArray, vectorArray2, vectorArray3, vectorArray4, byArray2, this.currentRootSigs, this.gmssPS, this.digestProvider);
        return new AsymmetricCipherKeyPair(gMSSPublicKeyParameters, (AsymmetricKeyParameter)object);
    }

    private GMSSRootCalc generateCurrentAuthpathAndRoot(byte[] byArray, Vector vector, byte[] byArray2, int n4) {
        WinternitzOTSignature winternitzOTSignature;
        byte[] byArray3 = new byte[this.mdLength];
        byte[] byArray4 = new byte[this.mdLength];
        byArray4 = this.gmssRandom.nextSeed(byArray2);
        GMSSRootCalc gMSSRootCalc = new GMSSRootCalc(this.heightOfTrees[n4], this.K[n4], this.digestProvider);
        gMSSRootCalc.initialize(vector);
        if (n4 == this.numLayer - 1) {
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n4]);
            byArray3 = winternitzOTSignature.getPublicKey();
        } else {
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n4]);
            this.currentRootSigs[n4] = winternitzOTSignature.getSignature(byArray);
            WinternitzOTSVerify winternitzOTSVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.otsIndex[n4]);
            byArray3 = winternitzOTSVerify.Verify(byArray, this.currentRootSigs[n4]);
        }
        gMSSRootCalc.update(byArray3);
        int n5 = 3;
        int n6 = 0;
        for (int i4 = 1; i4 < 1 << this.heightOfTrees[n4]; ++i4) {
            if (i4 == n5 && n6 < this.heightOfTrees[n4] - this.K[n4]) {
                gMSSRootCalc.initializeTreehashSeed(byArray2, n6);
                n5 *= 2;
                ++n6;
            }
            byArray4 = this.gmssRandom.nextSeed(byArray2);
            winternitzOTSignature = new WinternitzOTSignature(byArray4, this.digestProvider.get(), this.otsIndex[n4]);
            gMSSRootCalc.update(winternitzOTSignature.getPublicKey());
        }
        if (gMSSRootCalc.wasFinished()) {
            return gMSSRootCalc;
        }
        System.err.println("Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    private GMSSRootCalc generateNextAuthpathAndRoot(Vector vector, byte[] byArray, int n4) {
        byte[] byArray2 = new byte[this.numLayer];
        GMSSRootCalc gMSSRootCalc = new GMSSRootCalc(this.heightOfTrees[n4], this.K[n4], this.digestProvider);
        gMSSRootCalc.initialize(vector);
        int n5 = 3;
        int n6 = 0;
        for (int i4 = 0; i4 < 1 << this.heightOfTrees[n4]; ++i4) {
            if (i4 == n5 && n6 < this.heightOfTrees[n4] - this.K[n4]) {
                gMSSRootCalc.initializeTreehashSeed(byArray, n6);
                n5 *= 2;
                ++n6;
            }
            byArray2 = this.gmssRandom.nextSeed(byArray);
            WinternitzOTSignature winternitzOTSignature = new WinternitzOTSignature(byArray2, this.digestProvider.get(), this.otsIndex[n4]);
            gMSSRootCalc.update(winternitzOTSignature.getPublicKey());
        }
        if (gMSSRootCalc.wasFinished()) {
            return gMSSRootCalc;
        }
        System.err.println("N\ufffdchster Baum noch nicht fertig konstruiert!!!");
        return null;
    }

    public void initialize(int n4, SecureRandom secureRandom) {
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters;
        if (n4 <= 10) {
            int[] nArray = new int[]{10};
            int[] nArray2 = new int[]{3};
            int[] nArray3 = new int[]{2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray2, nArray3));
        } else if (n4 <= 20) {
            int[] nArray = new int[]{10, 10};
            int[] nArray4 = new int[]{5, 4};
            int[] nArray5 = new int[]{2, 2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray4, nArray5));
        } else {
            int[] nArray = new int[]{10, 10, 10, 10};
            int[] nArray6 = new int[]{9, 9, 9, 3};
            int[] nArray7 = new int[]{2, 2, 2, 2};
            gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(secureRandom, new GMSSParameters(nArray.length, nArray, nArray6, nArray7));
        }
        this.initialize(gMSSKeyGenerationParameters);
    }

    public void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.gmssParams = (GMSSKeyGenerationParameters)keyGenerationParameters;
        this.gmssPS = new GMSSParameters(this.gmssParams.getParameters().getNumOfLayers(), this.gmssParams.getParameters().getHeightOfTrees(), this.gmssParams.getParameters().getWinternitzParameter(), this.gmssParams.getParameters().getK());
        this.numLayer = this.gmssPS.getNumOfLayers();
        this.heightOfTrees = this.gmssPS.getHeightOfTrees();
        this.otsIndex = this.gmssPS.getWinternitzParameter();
        this.K = this.gmssPS.getK();
        this.currentSeeds = new byte[this.numLayer][this.mdLength];
        this.nextNextSeeds = new byte[this.numLayer - 1][this.mdLength];
        SecureRandom secureRandom = new SecureRandom();
        for (int i4 = 0; i4 < this.numLayer; ++i4) {
            secureRandom.nextBytes(this.currentSeeds[i4]);
            this.gmssRandom.nextSeed(this.currentSeeds[i4]);
        }
        this.initialized = true;
    }

    private void initializeDefault() {
        int[] nArray = new int[]{10, 10, 10, 10};
        int[] nArray2 = new int[]{3, 3, 3, 3};
        int[] nArray3 = new int[]{2, 2, 2, 2};
        GMSSKeyGenerationParameters gMSSKeyGenerationParameters = new GMSSKeyGenerationParameters(new SecureRandom(), new GMSSParameters(nArray.length, nArray, nArray2, nArray3));
        this.initialize(gMSSKeyGenerationParameters);
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

