/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] byArray, Digest digest, int n4) {
        this.w = n4;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int n5 = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)n5 / (double)n4);
        this.checksumsize = this.getLog((this.messagesize << n4) + 1);
        this.keysize = this.messagesize + (int)Math.ceil((double)this.checksumsize / (double)n4);
        this.privateKeyOTS = new byte[this.keysize][this.mdsize];
        byte[] byArray2 = new byte[this.mdsize];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        for (int i4 = 0; i4 < this.keysize; ++i4) {
            this.privateKeyOTS[i4] = this.gmssRandom.nextSeed(byArray2);
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] byArray = new byte[this.keysize * this.mdsize];
        byte[] byArray2 = new byte[this.mdsize];
        int n4 = 1 << this.w;
        for (int i4 = 0; i4 < this.keysize; ++i4) {
            this.messDigestOTS.update(this.privateKeyOTS[i4], 0, this.privateKeyOTS[i4].length);
            byArray2 = new byte[this.messDigestOTS.getDigestSize()];
            this.messDigestOTS.doFinal(byArray2, 0);
            for (int i5 = 2; i5 < n4; ++i5) {
                this.messDigestOTS.update(byArray2, 0, byArray2.length);
                byArray2 = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(byArray2, 0);
            }
            System.arraycopy(byArray2, 0, byArray, this.mdsize * i4, this.mdsize);
        }
        this.messDigestOTS.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(byArray3, 0);
        return byArray3;
    }

    public byte[] getSignature(byte[] byArray) {
        byte[] byArray2;
        block23: {
            long l4;
            int n4;
            int n5;
            long l5;
            int n6;
            int n7;
            int n8;
            int n9;
            byte[] byArray3;
            block24: {
                long l6;
                int n10;
                int n11;
                block22: {
                    int n12;
                    byArray2 = new byte[this.keysize * this.mdsize];
                    byArray3 = new byte[this.mdsize];
                    n9 = 0;
                    n8 = 0;
                    n11 = 0;
                    this.messDigestOTS.update(byArray, 0, byArray.length);
                    byArray3 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray3, 0);
                    if (8 % this.w != 0) break block22;
                    int n13 = 8 / this.w;
                    int n14 = (1 << this.w) - 1;
                    byte[] byArray4 = new byte[this.mdsize];
                    for (n12 = 0; n12 < byArray3.length; ++n12) {
                        for (int i4 = 0; i4 < n13; ++i4) {
                            n8 += n11;
                            System.arraycopy(this.privateKeyOTS[n9], 0, byArray4, 0, this.mdsize);
                            for (n11 = byArray3[n12] & n14; n11 > 0; --n11) {
                                this.messDigestOTS.update(byArray4, 0, byArray4.length);
                                byArray4 = new byte[this.messDigestOTS.getDigestSize()];
                                this.messDigestOTS.doFinal(byArray4, 0);
                            }
                            System.arraycopy(byArray4, 0, byArray2, n9 * this.mdsize, this.mdsize);
                            byArray3[n12] = (byte)(byArray3[n12] >>> this.w);
                            ++n9;
                        }
                    }
                    n8 = (this.messagesize << this.w) - n8;
                    for (n12 = 0; n12 < this.checksumsize; n12 += this.w) {
                        System.arraycopy(this.privateKeyOTS[n9], 0, byArray4, 0, this.mdsize);
                        for (n11 = n8 & n14; n11 > 0; --n11) {
                            this.messDigestOTS.update(byArray4, 0, byArray4.length);
                            byArray4 = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(byArray4, 0);
                        }
                        System.arraycopy(byArray4, 0, byArray2, n9 * this.mdsize, this.mdsize);
                        n8 >>>= this.w;
                        ++n9;
                    }
                    break block23;
                }
                if (this.w >= 8) break block24;
                int n15 = this.mdsize / this.w;
                int n16 = (1 << this.w) - 1;
                byte[] byArray5 = new byte[this.mdsize];
                int n17 = 0;
                for (n10 = 0; n10 < n15; ++n10) {
                    int n18;
                    l6 = 0L;
                    for (n18 = 0; n18 < this.w; ++n18) {
                        l6 ^= (long)((byArray3[n17] & 0xFF) << (n18 << 3));
                        ++n17;
                    }
                    for (n18 = 0; n18 < 8; ++n18) {
                        n8 += n11;
                        System.arraycopy(this.privateKeyOTS[n9], 0, byArray5, 0, this.mdsize);
                        for (n11 = (int)(l6 & (long)n16); n11 > 0; --n11) {
                            this.messDigestOTS.update(byArray5, 0, byArray5.length);
                            byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(byArray5, 0);
                        }
                        System.arraycopy(byArray5, 0, byArray2, n9 * this.mdsize, this.mdsize);
                        l6 >>>= this.w;
                        ++n9;
                    }
                }
                n15 = this.mdsize % this.w;
                l6 = 0L;
                for (n10 = 0; n10 < n15; ++n10) {
                    l6 ^= (long)((byArray3[n17] & 0xFF) << (n10 << 3));
                    ++n17;
                }
                n15 <<= 3;
                for (n10 = 0; n10 < n15; n10 += this.w) {
                    n8 += n11;
                    System.arraycopy(this.privateKeyOTS[n9], 0, byArray5, 0, this.mdsize);
                    for (n11 = (int)(l6 & (long)n16); n11 > 0; --n11) {
                        this.messDigestOTS.update(byArray5, 0, byArray5.length);
                        byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(byArray5, 0);
                    }
                    System.arraycopy(byArray5, 0, byArray2, n9 * this.mdsize, this.mdsize);
                    l6 >>>= this.w;
                    ++n9;
                }
                n8 = (this.messagesize << this.w) - n8;
                for (n10 = 0; n10 < this.checksumsize; n10 += this.w) {
                    System.arraycopy(this.privateKeyOTS[n9], 0, byArray5, 0, this.mdsize);
                    for (n11 = n8 & n16; n11 > 0; --n11) {
                        this.messDigestOTS.update(byArray5, 0, byArray5.length);
                        byArray5 = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(byArray5, 0);
                    }
                    System.arraycopy(byArray5, 0, byArray2, n9 * this.mdsize, this.mdsize);
                    n8 >>>= this.w;
                    ++n9;
                }
                break block23;
            }
            if (this.w >= 57) break block23;
            int n19 = (this.mdsize << 3) - this.w;
            int n20 = (1 << this.w) - 1;
            byte[] byArray6 = new byte[this.mdsize];
            int n21 = 0;
            while (n21 <= n19) {
                n7 = n21 >>> 3;
                n6 = n21 % 8;
                int n22 = (n21 += this.w) + 7 >>> 3;
                l5 = 0L;
                n5 = 0;
                for (n4 = n7; n4 < n22; ++n4) {
                    l5 ^= (long)((byArray3[n4] & 0xFF) << (n5 << 3));
                    ++n5;
                }
                n8 = (int)((long)n8 + l4);
                System.arraycopy(this.privateKeyOTS[n9], 0, byArray6, 0, this.mdsize);
                for (l4 = (l5 >>>= n6) & (long)n20; l4 > 0L; --l4) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n9 * this.mdsize, this.mdsize);
                ++n9;
            }
            n7 = n21 >>> 3;
            if (n7 < this.mdsize) {
                n6 = n21 % 8;
                l5 = 0L;
                n5 = 0;
                for (n4 = n7; n4 < this.mdsize; ++n4) {
                    l5 ^= (long)((byArray3[n4] & 0xFF) << (n5 << 3));
                    ++n5;
                }
                n8 = (int)((long)n8 + l4);
                System.arraycopy(this.privateKeyOTS[n9], 0, byArray6, 0, this.mdsize);
                for (l4 = (l5 >>>= n6) & (long)n20; l4 > 0L; --l4) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n9 * this.mdsize, this.mdsize);
                ++n9;
            }
            n8 = (this.messagesize << this.w) - n8;
            for (n4 = 0; n4 < this.checksumsize; n4 += this.w) {
                System.arraycopy(this.privateKeyOTS[n9], 0, byArray6, 0, this.mdsize);
                for (l4 = (long)(n8 & n20); l4 > 0L; --l4) {
                    this.messDigestOTS.update(byArray6, 0, byArray6.length);
                    byArray6 = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(byArray6, 0);
                }
                System.arraycopy(byArray6, 0, byArray2, n9 * this.mdsize, this.mdsize);
                n8 >>>= this.w;
                ++n9;
            }
        }
        return byArray2;
    }

    public int getLog(int n4) {
        int n5 = 1;
        int n6 = 2;
        while (n6 < n4) {
            n6 <<= 1;
            ++n5;
        }
        return n5;
    }
}

