/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;

public class GF2mField {
    private int degree = 0;
    private int polynomial;

    public GF2mField(int n4) {
        if (n4 >= 32) {
            throw new IllegalArgumentException(" Error: the degree of field is too large ");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException(" Error: the degree of field is non-positive ");
        }
        this.degree = n4;
        this.polynomial = PolynomialRingGF2.getIrreduciblePolynomial(n4);
    }

    public GF2mField(int n4, int n5) {
        if (n4 != PolynomialRingGF2.degree(n5)) {
            throw new IllegalArgumentException(" Error: the degree is not correct");
        }
        if (!PolynomialRingGF2.isIrreducible(n5)) {
            throw new IllegalArgumentException(" Error: given polynomial is reducible");
        }
        this.degree = n4;
        this.polynomial = n5;
    }

    public GF2mField(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.polynomial = LittleEndianConversions.OS2IP(byArray);
        if (!PolynomialRingGF2.isIrreducible(this.polynomial)) {
            throw new IllegalArgumentException("byte array is not an encoded finite field");
        }
        this.degree = PolynomialRingGF2.degree(this.polynomial);
    }

    public GF2mField(GF2mField gF2mField) {
        this.degree = gF2mField.degree;
        this.polynomial = gF2mField.polynomial;
    }

    public int getDegree() {
        return this.degree;
    }

    public int getPolynomial() {
        return this.polynomial;
    }

    public byte[] getEncoded() {
        return LittleEndianConversions.I2OSP(this.polynomial);
    }

    public int add(int n4, int n5) {
        return n4 ^ n5;
    }

    public int mult(int n4, int n5) {
        return PolynomialRingGF2.modMultiply(n4, n5, this.polynomial);
    }

    public int exp(int n4, int n5) {
        if (n5 == 0) {
            return 1;
        }
        if (n4 == 0) {
            return 0;
        }
        if (n4 == 1) {
            return 1;
        }
        int n6 = 1;
        if (n5 < 0) {
            n4 = this.inverse(n4);
            n5 = -n5;
        }
        while (n5 != 0) {
            if ((n5 & 1) == 1) {
                n6 = this.mult(n6, n4);
            }
            n4 = this.mult(n4, n4);
            n5 >>>= 1;
        }
        return n6;
    }

    public int inverse(int n4) {
        int n5 = (1 << this.degree) - 2;
        return this.exp(n4, n5);
    }

    public int sqRoot(int n4) {
        for (int i4 = 1; i4 < this.degree; ++i4) {
            n4 = this.mult(n4, n4);
        }
        return n4;
    }

    public int getRandomElement(SecureRandom secureRandom) {
        int n4 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        return n4;
    }

    public int getRandomNonZeroElement() {
        return this.getRandomNonZeroElement(new SecureRandom());
    }

    public int getRandomNonZeroElement(SecureRandom secureRandom) {
        int n4;
        int n5 = 0x100000;
        int n6 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        for (n4 = 0; n6 == 0 && n4 < n5; ++n4) {
            n6 = RandUtils.nextInt(secureRandom, 1 << this.degree);
        }
        if (n4 == n5) {
            n6 = 1;
        }
        return n6;
    }

    public boolean isElementOfThisField(int n4) {
        if (this.degree == 31) {
            return n4 >= 0;
        }
        return n4 >= 0 && n4 < 1 << this.degree;
    }

    public String elementToStr(int n4) {
        String string = "";
        for (int i4 = 0; i4 < this.degree; ++i4) {
            string = ((byte)n4 & 1) == 0 ? "0" + string : "1" + string;
            n4 >>>= 1;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mField)) {
            return false;
        }
        GF2mField gF2mField = (GF2mField)object;
        return this.degree == gF2mField.degree && this.polynomial == gF2mField.polynomial;
    }

    public int hashCode() {
        return this.polynomial;
    }

    public String toString() {
        String string = "Finite Field GF(2^" + this.degree + ") = " + "GF(2)[X]/<" + GF2mField.polyToString(this.polynomial) + "> ";
        return string;
    }

    private static String polyToString(int n4) {
        String string = "";
        if (n4 == 0) {
            string = "0";
        } else {
            byte by = (byte)(n4 & 1);
            if (by == 1) {
                string = "1";
            }
            n4 >>>= 1;
            int n5 = 1;
            while (n4 != 0) {
                by = (byte)(n4 & 1);
                if (by == 1) {
                    string = string + "+x^" + n5;
                }
                n4 >>>= 1;
                ++n5;
            }
        }
        return string;
    }
}

