/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        Object[] args2 = argArray;
        if (throwableCandidate != null) {
            args2 = MessageFormatter.trimmedCopy(argArray);
        }
        return MessageFormatter.arrayFormat(messagePattern, args2, throwableCandidate);
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray, Throwable throwable) {
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwable);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i4 = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int L4 = 0; L4 < argArray.length; ++L4) {
            int j4 = messagePattern.indexOf(DELIM_STR, i4);
            if (j4 == -1) {
                if (i4 == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwable);
                }
                sbuf.append(messagePattern, i4, messagePattern.length());
                return new FormattingTuple(sbuf.toString(), argArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j4)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j4)) {
                    --L4;
                    sbuf.append(messagePattern, i4, j4 - 1);
                    sbuf.append('{');
                    i4 = j4 + 1;
                    continue;
                }
                sbuf.append(messagePattern, i4, j4 - 1);
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L4], new HashMap<Object[], Object>());
                i4 = j4 + 2;
                continue;
            }
            sbuf.append(messagePattern, i4, j4);
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L4], new HashMap<Object[], Object>());
            i4 = j4 + 2;
        }
        sbuf.append(messagePattern, i4, messagePattern.length());
        return new FormattingTuple(sbuf.toString(), argArray, throwable);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o4, Map<Object[], Object> seenMap) {
        if (o4 == null) {
            sbuf.append("null");
            return;
        }
        if (!o4.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o4);
        } else if (o4 instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o4);
        } else if (o4 instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o4);
        } else if (o4 instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o4);
        } else if (o4 instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o4);
        } else if (o4 instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o4);
        } else if (o4 instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o4);
        } else if (o4 instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o4);
        } else if (o4 instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o4);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o4, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o4) {
        try {
            String oAsString = o4.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t4) {
            Util.report("SLF4J: Failed toString() invocation on an object of type [" + o4.getClass().getName() + "]", t4);
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a5, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a5)) {
            seenMap.put(a5, null);
            int len = a5.length;
            for (int i4 = 0; i4 < len; ++i4) {
                MessageFormatter.deeplyAppendParameter(sbuf, a5[i4], seenMap);
                if (i4 == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a5);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a5) {
        sbuf.append('[');
        int len = a5.length;
        for (int i4 = 0; i4 < len; ++i4) {
            sbuf.append(a5[i4]);
            if (i4 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("non-sensical empty or null argument array");
        }
        int trimmedLen = argArray.length - 1;
        Object[] trimmed = new Object[trimmedLen];
        if (trimmedLen > 0) {
            System.arraycopy(argArray, 0, trimmed, 0, trimmedLen);
        }
        return trimmed;
    }
}

