/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResID;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.StringBlock;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlResourceParser {
    private ExtDataInput m_reader;
    private ResAttrDecoder mAttrDecoder;
    private AndrolibException mFirstError;
    private boolean m_operational = false;
    private StringBlock m_strings;
    private int[] m_resourceIDs;
    private NamespaceStack m_namespaces = new NamespaceStack();
    private String android_ns = "http://schemas.android.com/apk/res/android";
    private boolean m_decreaseDepth;
    private int m_event;
    private int m_lineNumber;
    private int m_name;
    private int m_namespaceUri;
    private int[] m_attributes;
    private int m_idAttribute;
    private int m_classAttribute;
    private int m_styleAttribute;
    private static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());

    public AXmlResourceParser() {
        this.resetEventInfo();
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    public ResAttrDecoder getAttrDecoder() {
        return this.mAttrDecoder;
    }

    public void setAttrDecoder(ResAttrDecoder attrDecoder) {
        this.mAttrDecoder = attrDecoder;
    }

    public void open(InputStream stream) {
        this.close();
        if (stream != null) {
            this.m_reader = new ExtDataInput(new LittleEndianDataInputStream(stream));
        }
    }

    public void close() {
        if (!this.m_operational) {
            return;
        }
        this.m_operational = false;
        this.m_reader = null;
        this.m_strings = null;
        this.m_resourceIDs = null;
        this.m_namespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.m_reader == null) {
            throw new XmlPullParserException("Parser is not opened.", this, null);
        }
        try {
            this.doNext();
            return this.m_event;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public int getDepth() {
        return this.m_namespaces.getDepth() - 1;
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        return this.m_event;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public String getName() {
        if (this.m_name == -1 || this.m_event != 2 && this.m_event != 3) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    @Override
    public String getText() {
        if (this.m_name == -1 || this.m_event != 4) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    @Override
    public String getNamespace() {
        return this.m_strings.getString(this.m_namespaceUri);
    }

    @Override
    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    @Override
    public int getNamespaceCount(int depth) throws XmlPullParserException {
        return this.m_namespaces.getAccumulatedCount(depth);
    }

    @Override
    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        int prefix = this.m_namespaces.getPrefix(pos);
        return this.m_strings.getString(prefix);
    }

    @Override
    public String getNamespaceUri(int pos) throws XmlPullParserException {
        int uri = this.m_namespaces.getUri(pos);
        return this.m_strings.getString(uri);
    }

    @Override
    public int getAttributeCount() {
        if (this.m_event != 2) {
            return -1;
        }
        return this.m_attributes.length / 5;
    }

    @Override
    public String getAttributeNamespace(int index) {
        int offset = this.getAttributeOffset(index);
        int namespace = this.m_attributes[offset + 0];
        if (namespace == -1) {
            return "";
        }
        String value = this.m_strings.getString(namespace);
        if (value.length() == 0) {
            ResID resourceId = new ResID(this.getAttributeNameResource(index));
            value = resourceId.package_ == 127 ? this.getNonDefaultNamespaceUri() : this.android_ns;
        }
        return value;
    }

    private String getNonDefaultNamespaceUri() {
        int offset = this.m_namespaces.getCurrentCount() + 1;
        String prefix = this.m_strings.getString(this.m_namespaces.get(offset, true));
        if (!prefix.equalsIgnoreCase("android")) {
            return this.m_strings.getString(this.m_namespaces.get(offset, false));
        }
        return this.android_ns;
    }

    public String getAttributePrefix(int index) {
        int offset = this.getAttributeOffset(index);
        int uri = this.m_attributes[offset + 0];
        int prefix = this.m_namespaces.findPrefix(uri);
        if (prefix == -1) {
            return "";
        }
        return this.m_strings.getString(prefix);
    }

    @Override
    public String getAttributeName(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.m_attributes[offset + 1];
        if (name == -1) {
            return "";
        }
        String value = this.m_strings.getString(name);
        if (value.length() != 0 && !this.android_ns.equals(this.getAttributeNamespace(index))) {
            return value;
        }
        try {
            value = this.mAttrDecoder.decodeManifestAttr(this.getAttributeNameResource(index));
        }
        catch (AndrolibException androlibException) {
            // empty catch block
        }
        return value;
    }

    public int getAttributeNameResource(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.m_attributes[offset + 1];
        if (this.m_resourceIDs == null || name < 0 || name >= this.m_resourceIDs.length) {
            return 0;
        }
        return this.m_resourceIDs[name];
    }

    @Override
    public String getAttributeValue(int index) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.m_attributes[offset + 3];
        int valueData = this.m_attributes[offset + 4];
        int valueRaw = this.m_attributes[offset + 2];
        if (this.mAttrDecoder != null) {
            try {
                return this.mAttrDecoder.decode(valueType, valueData, valueRaw == -1 ? null : ResXmlEncoders.escapeXmlChars(this.m_strings.getString(valueRaw)), this.getAttributeNameResource(index));
            }
            catch (AndrolibException ex) {
                this.setFirstError(ex);
                LOGGER.log(Level.WARNING, String.format("Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x", this.getAttributePrefix(index), this.getAttributeName(index), valueData), ex);
            }
        }
        return TypedValue.coerceToString(valueType, valueData);
    }

    @Override
    public void setInput(InputStream stream, String inputEncoding) throws XmlPullParserException {
        this.open(stream);
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public boolean getFeature(String feature) {
        return false;
    }

    private final int getAttributeOffset(int index) {
        if (this.m_event != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int offset = index * 5;
        if (offset >= this.m_attributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + index + ").");
        }
        return offset;
    }

    private final void resetEventInfo() {
        this.m_event = -1;
        this.m_lineNumber = -1;
        this.m_name = -1;
        this.m_namespaceUri = -1;
        this.m_attributes = null;
        this.m_idAttribute = -1;
        this.m_classAttribute = -1;
        this.m_styleAttribute = -1;
    }

    private final void doNext() throws IOException {
        block14: {
            if (this.m_strings == null) {
                this.m_reader.skipCheckInt(524291, 524289);
                this.m_reader.skipInt();
                this.m_strings = StringBlock.read(this.m_reader);
                this.m_namespaces.increaseDepth();
                this.m_operational = true;
            }
            if (this.m_event == 1) {
                return;
            }
            int event = this.m_event;
            this.resetEventInfo();
            while (true) {
                if (this.m_decreaseDepth) {
                    this.m_decreaseDepth = false;
                    this.m_namespaces.decreaseDepth();
                }
                if (event == 3 && this.m_namespaces.getDepth() == 1 && this.m_namespaces.getCurrentCount() == 0) {
                    this.m_event = 1;
                    break block14;
                }
                int chunkType = event == 0 ? 0x100102 : this.m_reader.readInt();
                if (chunkType == 524672) {
                    int chunkSize = this.m_reader.readInt();
                    if (chunkSize < 8 || chunkSize % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + chunkSize + ").");
                    }
                    this.m_resourceIDs = this.m_reader.readIntArray(chunkSize / 4 - 2);
                    continue;
                }
                if (chunkType < 0x100100 || chunkType > 0x100104) {
                    throw new IOException("Invalid chunk type (" + chunkType + ").");
                }
                if (chunkType == 0x100102 && event == -1) {
                    this.m_event = 0;
                    break block14;
                }
                this.m_reader.skipInt();
                int lineNumber = this.m_reader.readInt();
                this.m_reader.skipInt();
                if (chunkType == 0x100100 || chunkType == 0x100101) {
                    if (chunkType == 0x100100) {
                        int prefix = this.m_reader.readInt();
                        int uri = this.m_reader.readInt();
                        this.m_namespaces.push(prefix, uri);
                        continue;
                    }
                    this.m_reader.skipInt();
                    this.m_reader.skipInt();
                    this.m_namespaces.pop();
                    continue;
                }
                this.m_lineNumber = lineNumber;
                if (chunkType == 0x100102) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_reader.skipInt();
                    int attributeCount = this.m_reader.readInt();
                    this.m_idAttribute = (attributeCount >>> 16) - 1;
                    this.m_classAttribute = this.m_reader.readInt();
                    this.m_styleAttribute = (this.m_classAttribute >>> 16) - 1;
                    this.m_classAttribute = (this.m_classAttribute & 0xFFFF) - 1;
                    this.m_attributes = this.m_reader.readIntArray((attributeCount &= 0xFFFF) * 5);
                    for (int i = 3; i < this.m_attributes.length; i += 5) {
                        this.m_attributes[i] = this.m_attributes[i] >>> 24;
                    }
                    this.m_namespaces.increaseDepth();
                    this.m_event = 2;
                    break block14;
                }
                if (chunkType == 0x100103) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_event = 3;
                    this.m_decreaseDepth = true;
                    break block14;
                }
                if (chunkType == 0x100104) break;
            }
            this.m_name = this.m_reader.readInt();
            this.m_reader.skipInt();
            this.m_reader.skipInt();
            this.m_event = 4;
        }
    }

    private void setFirstError(AndrolibException error) {
        if (this.mFirstError == null) {
            this.mFirstError = error;
        }
    }

    private static final class NamespaceStack {
        private int[] m_data = new int[32];
        private int m_dataLength;
        private int m_count;
        private int m_depth;

        public final void reset() {
            this.m_dataLength = 0;
            this.m_count = 0;
            this.m_depth = 0;
        }

        public final int getCurrentCount() {
            if (this.m_dataLength == 0) {
                return 0;
            }
            int offset = this.m_dataLength - 1;
            return this.m_data[offset];
        }

        public final int getAccumulatedCount(int depth) {
            if (this.m_dataLength == 0 || depth < 0) {
                return 0;
            }
            if (depth > this.m_depth) {
                depth = this.m_depth;
            }
            int accumulatedCount = 0;
            int offset = 0;
            while (depth != 0) {
                int count = this.m_data[offset];
                accumulatedCount += count;
                offset += 2 + count * 2;
                --depth;
            }
            return accumulatedCount;
        }

        public final void push(int prefix, int uri) {
            if (this.m_depth == 0) {
                this.increaseDepth();
            }
            this.ensureDataCapacity(2);
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            this.m_data[offset - 1 - count * 2] = count + 1;
            this.m_data[offset] = prefix;
            this.m_data[offset + 1] = uri;
            this.m_data[offset + 2] = count + 1;
            this.m_dataLength += 2;
            ++this.m_count;
        }

        public final boolean pop() {
            if (this.m_dataLength == 0) {
                return false;
            }
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            if (count == 0) {
                return false;
            }
            this.m_data[offset -= 2] = --count;
            this.m_data[offset -= 1 + count * 2] = count;
            this.m_dataLength -= 2;
            --this.m_count;
            return true;
        }

        public final int getPrefix(int index) {
            return this.get(index, true);
        }

        public final int getUri(int index) {
            return this.get(index, false);
        }

        public final int findPrefix(int uri) {
            return this.find(uri, false);
        }

        public final int getDepth() {
            return this.m_depth;
        }

        public final void increaseDepth() {
            this.ensureDataCapacity(2);
            int offset = this.m_dataLength;
            this.m_data[offset] = 0;
            this.m_data[offset + 1] = 0;
            this.m_dataLength += 2;
            ++this.m_depth;
        }

        public final void decreaseDepth() {
            if (this.m_dataLength == 0) {
                return;
            }
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            if (offset - 1 - count * 2 == 0) {
                return;
            }
            this.m_dataLength -= 2 + count * 2;
            this.m_count -= count;
            --this.m_depth;
        }

        private void ensureDataCapacity(int capacity) {
            int available = this.m_data.length - this.m_dataLength;
            if (available > capacity) {
                return;
            }
            int newLength = (this.m_data.length + available) * 2;
            int[] newData = new int[newLength];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_dataLength);
            this.m_data = newData;
        }

        private final int find(int prefixOrUri, boolean prefix) {
            if (this.m_dataLength == 0) {
                return -1;
            }
            int offset = this.m_dataLength - 1;
            for (int i = this.m_depth; i != 0; --i) {
                int count = this.m_data[offset];
                offset -= 2;
                while (count != 0) {
                    if (prefix) {
                        if (this.m_data[offset] == prefixOrUri) {
                            return this.m_data[offset + 1];
                        }
                    } else if (this.m_data[offset + 1] == prefixOrUri) {
                        return this.m_data[offset];
                    }
                    offset -= 2;
                    --count;
                }
            }
            return -1;
        }

        private final int get(int index, boolean prefix) {
            if (this.m_dataLength == 0 || index < 0) {
                return -1;
            }
            int offset = 0;
            for (int i = this.m_depth; i != 0; --i) {
                int count = this.m_data[offset];
                if (index >= count) {
                    index -= count;
                    offset += 2 + count * 2;
                    continue;
                }
                offset += 1 + index * 2;
                if (!prefix) {
                    ++offset;
                }
                return this.m_data[offset];
            }
            return -1;
        }
    }
}

