#!/bin/bash
#===============================================================================
#
#          FILE: goldspammer.sh
#
#         USAGE: goldspammer.sh
#
#   DESCRIPTION: Detect gold spammers by whitelist and write result to:
#                /var/www/html/goldspammer/
#
#  REQUIREMENTS: sendscript
#
#         NOTES: This script must work with allwzban, and put into crontab like:
# Gold spammer list
#*/5 * * * * ~/bin/goldspammer.sh > /dev/null 2>&1;~/bin/allwzban /tmp/goldspammer-IP_to_ban.txt 20 no_empty_list > /dev/null 2>&1
#
#          BUGS:  ---
#        AUTHOR: rickz (Rick Zhang), xlrickz@gmail.com
#       COMPANY: X-LEGEND Entertainment Corp.
#       CREATED: Sun Jul 17 21:53:13 EDT 2011
#      REVISION: 1.0
#
#          TODO:
#
#===============================================================================

#set -o nounset                              # Treat unset variables as an error
#set -m                                      # Enable job control

source ~/.gamerc

gold-spammer () {
	sendscript set${1}wz nosave -p nohostname <<< 'source ~/.gamerc;for i in ZoneDir;do cat $(ls -tr $i/Message*|tail -1)|egrep -ih " \[GENERAL:| \[SAY:| \[TELL:| \[NODE:"|awk -FLIFE: "{print \$2}"|sed "s/POS:[0-9\.]*//g;s/\([A-Z]:\)...................../\1/g;s/...........$//g"|LC_ALL=C sed -n "/^.\{120,\}/p"|tr -d "\r"|egrep -vi "Looking for|Slot Bag|[Ll][Vv][lL 0-9][ 0-9]*|STOP SPAMMING|EHUEUHE|dagger|each|guild|pm |newbie|wts|wtb|recuiting|anything wrong|LF[a-z] |Whisper|GROUP| ea |>x|please|need|tank|mage|noob|loot|color|armor|gonna|look|staff|bow|axe |mono|snobs|recruiting|friendly|community|member|> [0-9]\+g|crystal|talk|issue|[^[:blank:],:]{50,}|slot|fullset|revive|pls |star|energy|Nighthowl|heart|apart|Blueprint|Magic|Holy|Platinium|Pride|Platin|voor|Enige|naar|een|active|preparing|hate|REBEL| se | nn | su | NA | KA |> x|ported |end|\.{15,}|transform|RUSH|PST|OBO|OFFER|Somebody|bag|something|help| PA |GQ|Ch[0-9]|what ";done|LC_ALL=C sed "s/\ \+/ /g"|sort|LC_ALL=C uniq -c|sort -gr|grep -v "      [0-2] "|sed "s/ \+\([0-9]\+\)\+ /\1,/g;s/\]\[/,/g"|LC_ALL=C sed "s/\x0d//g";true'|sort -t , -k 1 -gr
}

gold-nonspammer () {
	sendscript set${1}wz nosave -p nohostname <<< 'source ~/.gamerc;for i in ZoneDir;do cat $(ls -tr $i/Message*|tail -1)|egrep -ih " \[GENERAL:| \[SAY:| \[TELL:| \[NODE:"|awk -FLIFE: "{print \$2}"|sed "s/POS:[0-9\.]*//g;s/\([A-Z]:\)...................../\1/g;s/...........$//g"|LC_ALL=C sed -n "/^.\{120,\}/p"|tr -d "\r"|egrep -i  "Looking for|Slot Bag|[Ll][Vv][lL 0-9][ 0-9]*|STOP SPAMMING|EHUEUHE|dagger|each|guild|pm |newbie|wts|wtb|recuiting|anything wrong|LF[a-z] |Whisper|GROUP| ea |>x|please|need|tank|mage|noob|loot|color|armor|gonna|look|staff|bow|axe |mono|snobs|recruiting|friendly|community|member|> [0-9]\+g|crystal|talk|issue|[^[:blank:],:]{50,}|slot|fullset|revive|pls |star|energy|Nighthowl|heart|apart|Blueprint|Magic|Holy|Platinium|Pride|Platin|voor|Enige|naar|een|active|preparing|hate|REBEL| se | nn | su | NA | KA |> x|ported |end|\.{15,}|transform|RUSH|PST|OBO|OFFER|Somebody|bag|something|help| PA |GQ|Ch[0-9]|what ";done|LC_ALL=C sed "s/\ \+/ /g"|sort|LC_ALL=C uniq -c|sort -gr|grep -v "      [0-2] "|sed "s/ \+\([0-9]\+\)\+ /\1,/g;s/\]\[/,/g"|LC_ALL=C sed "s/\x0d//g";true'|sort -t , -k 1 -gr
}

DATE_OF_OLD_DATA="$(date -d @$(stat -c %Z /var/www/html/goldspammer/spammer-set-1.txt) +%Y%m%dT%H%M)"

mkdir -p /var/www/html/goldspammer/Old/$DATE_OF_OLD_DATA
mv /var/www/html/goldspammer/*.txt /var/www/html/goldspammer/Old/$DATE_OF_OLD_DATA

for((SET=1;SET<=$(max_set);SET++));do
	gold-spammer $SET > /tmp/goldspammer-$SET.txt
	gold-nonspammer    $SET > /tmp/goldspammer-nonspammer-$SET.txt
	mkdir -p /var/www/html/goldspammer/
	cat /tmp/goldspammer-$SET.txt > /var/www/html/goldspammer/spammer-set-$SET.txt
	cat /tmp/goldspammer-nonspammer-$SET.txt > /var/www/html/goldspammer/non-spammer-set-$SET.txt
done

#awk -F, '{print "select clientip from currentuser where char_id="$3" and strcharid='\''"$2"'\'';"}' /tmp/goldspammer-[0-9].txt|sort|uniq|
echo "select distinct  on (clientip) clientip from game_log where $(awk -F, '{print "( char_id="$3" and strcharid='\''"$2"'\'') or "}' /tmp/goldspammer-[0-9].txt | tr -d '\n'|sed 's/ or $//g') order by clientip,logoutdate;" | \
psql -h accountdb -t $MEMBER_DB_NAME|sed 's/ //g'|grep -v "^$"|sort -g|uniq > /tmp/goldspammer-IP_to_ban.txt
cat /tmp/goldspammer-IP_to_ban.txt > /var/www/html/goldspammer/goldspammer-IP_to_ban.txt
