/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.SdkConstants;
import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutRemainder;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.DeviceMonitor;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleAppName;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHeap;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHello;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleNativeHeap;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleProfiling;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleTest;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleViewDebug;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleWait;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class AndroidDebugBridge {
    public static final AdbVersion MIN_ADB_VERSION = AdbVersion.parseFrom("1.0.20");
    public static final int DEFAULT_START_ADB_TIMEOUT_MILLIS = 20000;
    private static final String ADB = "adb";
    private static final String DDMS = "ddms";
    private static final String SERVER_PORT_ENV_VAR = "ANDROID_ADB_SERVER_PORT";
    static final int DEFAULT_ADB_PORT = 5037;
    private static final int STATUS_DLL_NOT_FOUND = -1073741515;
    private static boolean sUnitTestMode;
    private static int sAdbServerPort;
    private static boolean sUserManagedAdbMode;
    private static final Object sLastKnownGoodAddressLock;
    private static InetSocketAddress sLastKnownGoodAddress;
    private static AndroidDebugBridge sThis;
    private static boolean sInitialized;
    private static boolean sClientSupport;
    private static Map<String, String> sAdbEnvVars;
    private String mAdbOsLocation = null;
    private boolean mVersionCheck;
    private boolean mStarted = false;
    private DeviceMonitor mDeviceMonitor;
    private static final Object sLock;
    private static final Set<IDebugBridgeChangeListener> sBridgeListeners;
    private static final Set<IDeviceChangeListener> sDeviceListeners;
    private static final Set<IClientChangeListener> sClientListeners;

    @Deprecated
    public static synchronized void initIfNeeded(boolean clientSupport) {
        if (sInitialized) {
            return;
        }
        AndroidDebugBridge.init(clientSupport);
    }

    public static synchronized void init(boolean clientSupport) {
        AndroidDebugBridge.init(clientSupport, false, ImmutableMap.of());
    }

    public static synchronized void init(boolean clientSupport, boolean useLibusb, Map<String, String> env) {
        AndroidDebugBridge.init(AdbInitOptions.builder().withEnv(env).setClientSupportEnabled(clientSupport).withEnv("ADB_LIBUSB", useLibusb ? "1" : "0").build());
    }

    public static synchronized void init(AdbInitOptions options) {
        Preconditions.checkState(!sInitialized, "AndroidDebugBridge.init() has already been called.");
        sInitialized = true;
        sClientSupport = options.clientSupport;
        sAdbEnvVars = options.adbEnvVars;
        sUserManagedAdbMode = options.userManagedAdbMode;
        sLastKnownGoodAddress = null;
        DdmPreferences.enableJdwpProxyService(options.useJdwpProxyService);
        AndroidDebugBridge.initAdbPort(options.userManagedAdbPort);
        MonitorThread monitorThread = MonitorThread.createInstance();
        monitorThread.start();
        HandleHello.register(monitorThread);
        HandleAppName.register(monitorThread);
        HandleTest.register(monitorThread);
        HandleThread.register(monitorThread);
        HandleHeap.register(monitorThread);
        HandleWait.register(monitorThread);
        HandleProfiling.register(monitorThread);
        HandleNativeHeap.register(monitorThread);
        HandleViewDebug.register(monitorThread);
    }

    @VisibleForTesting
    public static void enableFakeAdbServerMode(int port) {
        Preconditions.checkState(!sInitialized, "AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
        sUnitTestMode = true;
        sAdbServerPort = port;
    }

    @VisibleForTesting
    public static void disableFakeAdbServerMode() {
        Preconditions.checkState(!sInitialized, "AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
        sUnitTestMode = false;
        sAdbServerPort = 0;
    }

    public static synchronized void terminate() {
        MonitorThread monitorThread;
        if (sThis != null && AndroidDebugBridge.sThis.mDeviceMonitor != null) {
            AndroidDebugBridge.sThis.mDeviceMonitor.stop();
            AndroidDebugBridge.sThis.mDeviceMonitor = null;
        }
        if ((monitorThread = MonitorThread.getInstance()) != null) {
            monitorThread.quit();
        }
        sInitialized = false;
        sThis = null;
        sLastKnownGoodAddress = null;
    }

    public static boolean getClientSupport() {
        return sClientSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static InetSocketAddress getSocketAddress() {
        if (!sUnitTestMode) {
            Object object = sLastKnownGoodAddressLock;
            synchronized (object) {
                InetSocketAddress inetSocketAddress;
                block14: {
                    if (sLastKnownGoodAddress != null) {
                        return sLastKnownGoodAddress;
                    }
                    SocketChannel adbChannel = AndroidDebugBridge.openConnection();
                    try {
                        inetSocketAddress = sLastKnownGoodAddress = (InetSocketAddress)adbChannel.getRemoteAddress();
                        if (adbChannel == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (adbChannel != null) {
                                try {
                                    adbChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                        }
                    }
                    adbChannel.close();
                }
                return inetSocketAddress;
            }
        }
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), sAdbServerPort);
    }

    public static SocketChannel openConnection() throws IOException {
        SocketChannel adbChannel;
        try {
            adbChannel = SocketChannel.open(new InetSocketAddress("127.0.0.1", sAdbServerPort));
        }
        catch (IOException ipv4Exception) {
            try {
                adbChannel = SocketChannel.open(new InetSocketAddress("::1", sAdbServerPort));
            }
            catch (IOException ipv6Exception) {
                IOException combinedException = new IOException("Can't find adb server on port " + sAdbServerPort + ", IPv4 attempt: " + ipv4Exception.getMessage() + ", IPv6 attempt: " + ipv6Exception.getMessage(), ipv4Exception);
                combinedException.addSuppressed(ipv6Exception);
                throw combinedException;
            }
        }
        adbChannel.socket().setTcpNoDelay(true);
        return adbChannel;
    }

    @Deprecated
    public static AndroidDebugBridge createBridge() {
        return AndroidDebugBridge.createBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge(long timeout, TimeUnit unit) {
        AndroidDebugBridge localThis;
        Iterator<IDebugBridgeChangeListener> iterator2 = sLock;
        synchronized (iterator2) {
            if (sThis != null) {
                return sThis;
            }
            try {
                localThis = new AndroidDebugBridge();
                if (!localThis.start(timeout, unit)) {
                    return null;
                }
            }
            catch (InvalidParameterException e5) {
                return null;
            }
            sThis = localThis;
        }
        for (IDebugBridgeChangeListener listener : sBridgeListeners) {
            try {
                listener.bridgeChanged(localThis);
            }
            catch (Exception e6) {
                Log.e(DDMS, e6);
            }
        }
        return localThis;
    }

    @Deprecated
    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        return AndroidDebugBridge.createBridge(osLocation, forceNewBridge, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge, long timeout, TimeUnit unit) {
        AndroidDebugBridge localThis;
        Iterator<IDebugBridgeChangeListener> iterator2 = sLock;
        synchronized (iterator2) {
            TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
            if (!sUnitTestMode && sThis != null) {
                if (AndroidDebugBridge.sThis.mAdbOsLocation != null && AndroidDebugBridge.sThis.mAdbOsLocation.equals(osLocation) && !forceNewBridge) {
                    return sThis;
                }
                if (!sThis.stop(rem.getRemainingUnits(), unit)) {
                    return null;
                }
                sThis = null;
            }
            try {
                localThis = new AndroidDebugBridge(osLocation);
                if (!localThis.start(rem.getRemainingUnits(), unit)) {
                    localThis = null;
                }
            }
            catch (InvalidParameterException e5) {
                localThis = null;
            }
            sThis = localThis;
        }
        for (IDebugBridgeChangeListener listener : sBridgeListeners) {
            try {
                listener.bridgeChanged(localThis);
            }
            catch (Exception e6) {
                Log.e(DDMS, e6);
            }
        }
        return localThis;
    }

    public static AndroidDebugBridge getBridge() {
        return sThis;
    }

    @Deprecated
    public static void disconnectBridge() {
        AndroidDebugBridge.disconnectBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disconnectBridge(long timeout, TimeUnit unit) {
        Iterator<IDebugBridgeChangeListener> iterator2 = sLock;
        synchronized (iterator2) {
            if (sThis != null) {
                if (!sThis.stop(timeout, unit)) {
                    return false;
                }
                sThis = null;
            }
        }
        for (IDebugBridgeChangeListener listener : sBridgeListeners) {
            try {
                listener.bridgeChanged(null);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        AndroidDebugBridge localThis;
        sBridgeListeners.add(listener);
        Object object = sLock;
        synchronized (object) {
            localThis = sThis;
        }
        if (localThis != null) {
            try {
                listener.bridgeChanged(localThis);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
    }

    public static void removeDebugBridgeChangeListener(IDebugBridgeChangeListener listener) {
        sBridgeListeners.remove(listener);
    }

    @VisibleForTesting
    public static int getDebugBridgeChangeListenerCount() {
        return sBridgeListeners.size();
    }

    public static void addDeviceChangeListener(IDeviceChangeListener listener) {
        sDeviceListeners.add(listener);
    }

    public static void removeDeviceChangeListener(IDeviceChangeListener listener) {
        sDeviceListeners.remove(listener);
    }

    @VisibleForTesting
    public static int getDeviceChangeListenerCount() {
        return sDeviceListeners.size();
    }

    public static void addClientChangeListener(IClientChangeListener listener) {
        sClientListeners.add(listener);
    }

    public static void removeClientChangeListener(IClientChangeListener listener) {
        sClientListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice[] getDevices() {
        Object object = sLock;
        synchronized (object) {
            if (this.mDeviceMonitor != null) {
                return this.mDeviceMonitor.getDevices();
            }
        }
        return new IDevice[0];
    }

    public boolean hasInitialDeviceList() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.hasInitialDeviceList();
        }
        return false;
    }

    public boolean isConnected() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (this.mDeviceMonitor != null && monitorThread != null) {
            return this.mDeviceMonitor.isMonitoring() && monitorThread.getState() != Thread.State.TERMINATED;
        }
        return false;
    }

    public int getConnectionAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getConnectionAttemptCount();
        }
        return -1;
    }

    public int getRestartAttemptCount() {
        if (this.mDeviceMonitor != null) {
            return this.mDeviceMonitor.getRestartAttemptCount();
        }
        return -1;
    }

    private AndroidDebugBridge(String osLocation) throws InvalidParameterException {
        if (osLocation == null || osLocation.isEmpty()) {
            throw new InvalidParameterException();
        }
        this.mAdbOsLocation = osLocation;
        try {
            this.checkAdbVersion();
        }
        catch (IOException e5) {
            throw new IllegalArgumentException(e5);
        }
    }

    private AndroidDebugBridge() {
    }

    private void checkAdbVersion() throws IOException {
        AdbVersion version;
        this.mVersionCheck = false;
        if (this.mAdbOsLocation == null) {
            return;
        }
        File adb = new File(this.mAdbOsLocation);
        ListenableFuture<AdbVersion> future = AndroidDebugBridge.getAdbVersion(adb);
        try {
            version = (AdbVersion)future.get(20000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e5) {
            return;
        }
        catch (TimeoutException e6) {
            String msg = "Unable to obtain result of 'adb version'";
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, msg);
            return;
        }
        catch (ExecutionException e7) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, e7.getCause().getMessage());
            Throwables.propagateIfInstanceOf(e7.getCause(), IOException.class);
            return;
        }
        if (version.compareTo(MIN_ADB_VERSION) > 0) {
            this.mVersionCheck = true;
        } else {
            String message2 = String.format("Required minimum version of adb: %1$s.Current version is %2$s", MIN_ADB_VERSION, version);
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, message2);
        }
    }

    @Deprecated
    private static <T> ListenableFuture<T> runAdb(File adb, AdbOutputProcessor<T> resultParser, String ... command) {
        SettableFuture future = SettableFuture.create();
        new Thread(() -> {
            Process p4;
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(adb.getPath());
            args2.addAll(Arrays.asList(command));
            ProcessBuilder pb = new ProcessBuilder(args2);
            pb.redirectErrorStream(true);
            try {
                p4 = pb.start();
            }
            catch (IOException e5) {
                future.setException(e5);
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p4.getInputStream()));){
                future.set(resultParser.process(p4, br));
            }
            catch (IOException e6) {
                future.setException(e6);
                return;
            }
            catch (RuntimeException e7) {
                future.setException(e7);
            }
        }, "Running adb").start();
        return future;
    }

    public static ListenableFuture<AdbVersion> getAdbVersion(File adb) {
        return AndroidDebugBridge.runAdb(adb, (process, br) -> {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                AdbVersion version = AdbVersion.parseFrom(line);
                if (version != AdbVersion.UNKNOWN) {
                    return version;
                }
                sb.append(line);
                sb.append('\n');
            }
            String errorMessage = "Unable to detect adb version";
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                errorMessage = errorMessage + ", exit value: 0x" + Integer.toHexString(exitValue);
                if (exitValue == -1073741515 && SdkConstants.currentPlatform() == 2) {
                    errorMessage = errorMessage + ". ADB depends on the Windows Universal C Runtime, which is usually installed by default via Windows Update. You may need to manually fetch and install the runtime package here: https://support.microsoft.com/en-ca/help/2999226/update-for-universal-c-runtime-in-windows";
                    throw new RuntimeException(errorMessage);
                }
            }
            if (sb.length() > 0) {
                errorMessage = errorMessage + ", adb output: " + sb.toString();
            }
            throw new RuntimeException(errorMessage);
        }, "version");
    }

    private static ListenableFuture<List<AdbDevice>> getRawDeviceList(File adb) {
        return AndroidDebugBridge.runAdb(adb, (process, br) -> {
            String line;
            br.readLine();
            ArrayList<AdbDevice> result = new ArrayList<AdbDevice>();
            while ((line = br.readLine()) != null) {
                AdbDevice device = AdbDevice.parseAdbLine(line);
                if (device == null) continue;
                result.add(device);
            }
            return result;
        }, "devices", "-l");
    }

    public static ListenableFuture<String> getVirtualDeviceId(ListeningExecutorService service, File adb, IDevice device) {
        List<String> command = Arrays.asList(adb.toString(), "-s", device.getSerialNumber(), "emu", "avd", "id");
        return AndroidDebugBridge.execute(service, command, AndroidDebugBridge::processVirtualDeviceIdCommandOutput);
    }

    private static String processVirtualDeviceIdCommandOutput(Process process, BufferedReader reader) {
        List lines = reader.lines().collect(Collectors.toList());
        if (lines.size() != 2) {
            return "";
        }
        if (!((String)lines.get(1)).equals("OK")) {
            return "";
        }
        String result = (String)lines.get(0);
        assert (!result.isEmpty());
        return result;
    }

    private static <T> ListenableFuture<T> execute(ListeningExecutorService service, List<String> command, AdbOutputProcessor<T> processor) {
        return service.submit(() -> {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                Object t4 = processor.process(process, in);
                return t4;
            }
        });
    }

    public ListenableFuture<List<AdbDevice>> getRawDeviceList() {
        if (this.mAdbOsLocation == null) {
            SettableFuture<List<AdbDevice>> result = SettableFuture.create();
            result.set(Collections.emptyList());
            return result;
        }
        File adb = new File(this.mAdbOsLocation);
        return AndroidDebugBridge.getRawDeviceList(adb);
    }

    boolean start(long timeout, TimeUnit unit) {
        if (!sUserManagedAdbMode && this.mAdbOsLocation != null && sAdbServerPort != 0) {
            if (!this.mVersionCheck) {
                return false;
            }
            if (!this.startAdb(timeout, unit)) {
                return false;
            }
        }
        this.mStarted = true;
        this.mDeviceMonitor = new DeviceMonitor(this);
        this.mDeviceMonitor.start();
        return true;
    }

    boolean stop(long timeout, TimeUnit unit) {
        if (!this.mStarted) {
            return true;
        }
        TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
        if (this.mDeviceMonitor != null) {
            this.mDeviceMonitor.stop();
            this.mDeviceMonitor = null;
        }
        if (sUserManagedAdbMode) {
            Log.i(DDMS, "User managed ADB mode: Not stopping ADB server");
        } else if (!this.stopAdb(rem.getRemainingUnits(), unit)) {
            return false;
        }
        this.mStarted = false;
        return true;
    }

    @Deprecated
    public boolean restart() {
        return this.restart(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart(long timeout, TimeUnit unit) {
        boolean isSuccessful;
        if (sUserManagedAdbMode) {
            Log.e(ADB, "Cannot restart adb when using user managed ADB server.");
            return false;
        }
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot restart adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set.");
            return false;
        }
        if (!this.mVersionCheck) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Attempting to restart adb, but version check failed!");
            return false;
        }
        TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
        for (IDebugBridgeChangeListener listener : sBridgeListeners) {
            try {
                listener.restartInitiated();
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
        AndroidDebugBridge androidDebugBridge = this;
        synchronized (androidDebugBridge) {
            isSuccessful = this.stopAdb(rem.getRemainingUnits(), unit);
            if (!isSuccessful) {
                Log.w(ADB, "Error stopping ADB without specified timeout");
            }
            if (isSuccessful) {
                isSuccessful = this.startAdb(rem.getRemainingUnits(), unit);
            }
            if (isSuccessful && this.mDeviceMonitor == null) {
                this.mDeviceMonitor = new DeviceMonitor(this);
                this.mDeviceMonitor.start();
            }
        }
        for (IDebugBridgeChangeListener listener : sBridgeListeners) {
            try {
                listener.restartCompleted(isSuccessful);
            }
            catch (Exception e6) {
                Log.e(DDMS, e6);
            }
        }
        return isSuccessful;
    }

    public static void deviceConnected(IDevice device) {
        for (IDeviceChangeListener listener : sDeviceListeners) {
            try {
                listener.deviceConnected(device);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
    }

    public static void deviceDisconnected(IDevice device) {
        for (IDeviceChangeListener listener : sDeviceListeners) {
            try {
                listener.deviceDisconnected(device);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
    }

    public static void deviceChanged(IDevice device, int changeMask) {
        for (IDeviceChangeListener listener : sDeviceListeners) {
            try {
                listener.deviceChanged(device, changeMask);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
    }

    public static void clientChanged(ClientImpl client, int changeMask) {
        for (IClientChangeListener listener : sClientListeners) {
            try {
                listener.clientChanged(client, changeMask);
            }
            catch (Exception e5) {
                Log.e(DDMS, e5);
            }
        }
    }

    public static boolean isUserManagedAdbMode() {
        return sUserManagedAdbMode;
    }

    public synchronized boolean startAdb(long timeout, TimeUnit unit) {
        if (sUserManagedAdbMode) {
            Log.e(ADB, "startADB should never be called when using user managed ADB server.");
            return false;
        }
        if (sUnitTestMode) {
            return true;
        }
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot start adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.w(ADB, "ADB server port for starting AndroidDebugBridge is not set.");
            return false;
        }
        int status = -1;
        Object[] command = this.getAdbLaunchCommand("start-server");
        String commandString = Joiner.on(' ').join(command);
        try {
            String adbHostValue;
            Log.d(DDMS, String.format("Launching '%1$s' to ensure ADB is running.", commandString));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
            Map<String, String> env = processBuilder.environment();
            sAdbEnvVars.forEach(env::put);
            if (DdmPreferences.getUseAdbHost() && (adbHostValue = DdmPreferences.getAdbHostValue()) != null && !adbHostValue.isEmpty()) {
                env.put("ADBHOST", adbHostValue);
            }
            Process proc = processBuilder.start();
            ArrayList<String> errorOutput = new ArrayList<String>();
            ArrayList<String> stdOutput = new ArrayList<String>();
            status = AndroidDebugBridge.grabProcessOutput(proc, errorOutput, stdOutput, false, timeout, unit);
        }
        catch (IOException | InterruptedException ioe) {
            Log.e(DDMS, "Unable to run 'adb': " + ioe.getMessage());
        }
        if (status != 0) {
            Log.e(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
            return false;
        }
        Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
        return true;
    }

    private String[] getAdbLaunchCommand(String option) {
        ArrayList<String> command = new ArrayList<String>(4);
        command.add(this.mAdbOsLocation);
        if (sAdbServerPort != 5037) {
            command.add("-P");
            command.add(Integer.toString(sAdbServerPort));
        }
        command.add(option);
        return command.toArray(new String[0]);
    }

    private synchronized boolean stopAdb(long timeout, TimeUnit unit) {
        if (sUserManagedAdbMode) {
            Log.e(ADB, "stopADB should never be called when using user managed ADB server.");
            return false;
        }
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot stop adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set");
            return false;
        }
        int status = -1;
        Object[] command = this.getAdbLaunchCommand("kill-server");
        try {
            Process proc = Runtime.getRuntime().exec((String[])command);
            if (proc.waitFor(timeout, unit)) {
                status = proc.exitValue();
            } else {
                proc.destroy();
                status = -1;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String commandString = Joiner.on(' ').join(command);
        if (status != 0) {
            Log.w(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
            return false;
        }
        Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
        return true;
    }

    private static int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitForReaders, long timeout, TimeUnit unit) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
        Thread t12 = new Thread("adb:stderr reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream(), Charsets.UTF_8);
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        Log.e(AndroidDebugBridge.ADB, line);
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    Closeables.closeQuietly(errReader);
                }
            }
        };
        Thread t22 = new Thread("adb:stdout reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream(), Charsets.UTF_8);
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        Log.d(AndroidDebugBridge.ADB, line);
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    Closeables.closeQuietly(outReader);
                }
            }
        };
        t12.start();
        t22.start();
        if (waitForReaders) {
            long remMillis;
            try {
                remMillis = rem.getRemainingUnits(TimeUnit.MILLISECONDS);
                if (remMillis > 0L) {
                    t12.join(remMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remMillis = rem.getRemainingUnits(TimeUnit.MILLISECONDS);
            try {
                if (remMillis > 0L) {
                    t22.join(remMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (process.waitFor(rem.getRemainingUnits(), unit)) {
            return process.exitValue();
        }
        Log.w(ADB, "Process did not terminate within specified timeout, killing it");
        process.destroyForcibly();
        return -1;
    }

    private static void initAdbPort(int userManagedAdbPort) {
        if (!sUnitTestMode) {
            sAdbServerPort = sUserManagedAdbMode ? userManagedAdbPort : AndroidDebugBridge.getAdbServerPort();
        }
    }

    private static int getAdbServerPort() {
        String msg;
        Integer prop = Integer.getInteger(SERVER_PORT_ENV_VAR);
        if (prop != null) {
            try {
                return AndroidDebugBridge.validateAdbServerPort(prop.toString());
            }
            catch (IllegalArgumentException e5) {
                msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT system property.", prop);
                Log.w(DDMS, msg);
            }
        }
        try {
            String env = System.getenv(SERVER_PORT_ENV_VAR);
            if (env != null) {
                return AndroidDebugBridge.validateAdbServerPort(env);
            }
        }
        catch (SecurityException ex) {
            Log.w(DDMS, "No access to env variables allowed by current security manager. If you've set ANDROID_ADB_SERVER_PORT: it's being ignored.");
        }
        catch (IllegalArgumentException e6) {
            msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT environment variable (%2$s).", prop, e6.getMessage());
            Log.w(DDMS, msg);
        }
        return 5037;
    }

    private static int validateAdbServerPort(String adbServerPort) throws IllegalArgumentException {
        try {
            int port = Integer.decode(adbServerPort);
            if (port <= 0 || port >= 65535) {
                throw new IllegalArgumentException("Should be > 0 and < 65535");
            }
            return port;
        }
        catch (NumberFormatException e5) {
            throw new IllegalArgumentException("Not a valid port number");
        }
    }

    static {
        sAdbServerPort = 0;
        sUserManagedAdbMode = false;
        sLastKnownGoodAddressLock = new Object();
        sInitialized = false;
        sLock = new Object();
        sBridgeListeners = Sets.newCopyOnWriteArraySet();
        sDeviceListeners = Sets.newCopyOnWriteArraySet();
        sClientListeners = Sets.newCopyOnWriteArraySet();
    }

    static interface AdbOutputProcessor<T> {
        public T process(Process var1, BufferedReader var2) throws IOException;
    }

    public static interface IClientChangeListener {
        public void clientChanged(Client var1, int var2);
    }

    public static interface IDeviceChangeListener {
        public void deviceConnected(IDevice var1);

        public void deviceDisconnected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);
    }

    public static interface IDebugBridgeChangeListener {
        public void bridgeChanged(AndroidDebugBridge var1);

        default public void restartInitiated() {
        }

        default public void restartCompleted(boolean isSuccessful) {
        }
    }
}

