/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.io.CancellableFileIo;
import com.android.prefs.AbstractAndroidLocations;
import com.android.prefs.AbstractAndroidLocationsKt;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidPathLocator;
import com.android.prefs.Global;
import com.android.prefs.PathLocator;
import com.android.utils.EnvironmentProvider;
import com.android.utils.ILogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\nH\u0002R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/prefs/AbstractAndroidLocations;", "Lcom/android/prefs/AndroidLocationsProvider;", "environmentProvider", "Lcom/android/utils/EnvironmentProvider;", "logger", "Lcom/android/utils/ILogger;", "silent", "", "(Lcom/android/utils/EnvironmentProvider;Lcom/android/utils/ILogger;Z)V", "avdLocation", "Ljava/nio/file/Path;", "getAvdLocation", "()Ljava/nio/file/Path;", "avdLocation$delegate", "Lkotlin/Lazy;", "gradleAvdLocation", "getGradleAvdLocation", "gradleAvdLocation$delegate", "prefsLocation", "getPrefsLocation", "prefsLocation$delegate", "userHomeLocation", "getUserHomeLocation", "userHomeLocation$delegate", "computeAndroidFolder", "Companion", "common"})
public abstract class AbstractAndroidLocations
implements AndroidLocationsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentProvider environmentProvider;
    @NotNull
    private final ILogger logger;
    private final boolean silent;
    @NotNull
    private final Lazy prefsLocation$delegate;
    @NotNull
    private final Lazy avdLocation$delegate;
    @NotNull
    private final Lazy gradleAvdLocation$delegate;
    @NotNull
    private final Lazy userHomeLocation$delegate;
    @JvmField
    @NotNull
    public static final String FOLDER_DOT_ANDROID = ".android";
    @JvmField
    @NotNull
    public static final String FOLDER_AVD = "avd";
    @JvmField
    @NotNull
    public static final String FOLDER_GRADLE = "gradle";
    @JvmField
    @NotNull
    public static final String FOLDER_GRADLE_AVD = "avd";
    @JvmField
    @NotNull
    public static final String ANDROID_PREFS_ROOT = "ANDROID_PREFS_ROOT";
    @NotNull
    private static final String ANDROID_USER_HOME = "ANDROID_USER_HOME";

    protected AbstractAndroidLocations(@NotNull EnvironmentProvider environmentProvider, @NotNull ILogger logger, boolean silent) {
        Intrinsics.checkParameterIsNotNull(environmentProvider, "environmentProvider");
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.environmentProvider = environmentProvider;
        this.logger = logger;
        this.silent = silent;
        this.prefsLocation$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ AbstractAndroidLocations this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = AbstractAndroidLocations.access$computeAndroidFolder(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                Path it = path;
                boolean bl3 = false;
                if (CancellableFileIo.notExists(it, new LinkOption[0])) {
                    try {
                        Files.createDirectories(it, new FileAttribute[0]);
                    }
                    catch (SecurityException e5) {
                        throw new AndroidLocationsException("Unable to create folder '" + it + "'.\n|This is the path of preference folder expected by the Android tools.", e5);
                    }
                } else if (CancellableFileIo.isRegularFile(it, new LinkOption[0])) {
                    throw new AndroidLocationsException(it + " is not a directory!\nThis is the path of preference folder expected by the Android tools.", null, 2, null);
                }
                return path;
            }
        });
        this.avdLocation$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ AbstractAndroidLocations this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Path invoke() {
                Global[] globalArray = new Global[]{Global.ANDROID_AVD_HOME};
                Path path = new PathLocator(AbstractAndroidLocations.access$getEnvironmentProvider$p(this.this$0)).singlePathOf(globalArray);
                return path == null ? this.this$0.getPrefsLocation().resolve(AbstractAndroidLocations.FOLDER_AVD) : path;
            }
        });
        this.gradleAvdLocation$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ AbstractAndroidLocations this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Path invoke() {
                return this.this$0.getPrefsLocation().resolve(AbstractAndroidLocations.FOLDER_GRADLE).resolve(AbstractAndroidLocations.FOLDER_GRADLE_AVD);
            }
        });
        this.userHomeLocation$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ AbstractAndroidLocations this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                PathLocator pathLocator = new PathLocator(AbstractAndroidLocations.access$getEnvironmentProvider$p(this.this$0));
                Global[] globalArray = new Global[]{Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME};
                Path path = pathLocator.firstPathOf(globalArray);
                if (path == null) {
                    throw AndroidLocationsException.Companion.createForHomeLocation$common(pathLocator.getVisitedVariables());
                }
                return path;
            }
        });
    }

    public /* synthetic */ AbstractAndroidLocations(EnvironmentProvider environmentProvider, ILogger iLogger, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            bl = true;
        }
        this(environmentProvider, iLogger, bl);
    }

    @Override
    @NotNull
    public Path getPrefsLocation() throws AndroidLocationsException {
        Lazy lazy = this.prefsLocation$delegate;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public Path getAvdLocation() throws AndroidLocationsException {
        Lazy lazy = this.avdLocation$delegate;
        boolean bl = false;
        Object t4 = lazy.getValue();
        Intrinsics.checkExpressionValueIsNotNull(t4, "pyright (C) 2020 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.android.prefs\n\nimport com.android.io.CancellableFileIo\nimport com.android.prefs.AbstractAndroidLocations.Companion.FOLDER_DOT_ANDROID\nimport com.android.utils.EnvironmentProvider\nimport com.android.utils.ILogger\nimport java.nio.file.Files\nimport java.nio.file.Path\nimport java.nio.file.Paths\n\n/**\n * A class that computes various locations used by the Android tools.\n *\n * The values are computed once and then memoized inside the instance.\n *\n * To use as a singleton, use [AndroidLocationsSingleton].\n */\nabstract class AbstractAndroidLocations protected constructor(\n    private val environmentProvider: EnvironmentProvider,\n    private val logger: ILogger,\n    private val silent: Boolean = true\n): AndroidLocationsProvider {\n\n    companion object {\n        /**\n         * The name of the .android folder returned by [prefsLocation], unless [ANDROID_USER_HOME] is used\n         */\n        @JvmField\n        val FOLDER_DOT_ANDROID = \".android\"\n\n        /**\n         * Virtual Device folder inside the path returned by [avdLocation]\n         */\n        @JvmField\n        val FOLDER_AVD = \"avd\"\n\n        /**\n         * Folder for the Android plugin for gradle, containing managed devices.\n         */\n        @JvmField\n        val FOLDER_GRADLE = \"gradle\"\n\n        /**\n         * Virtual Device folder for devices managed by the Android plugin for gradle inside the\n         * path returned by [gradleAvdLocation].\n         */\n        @JvmField\n        val FOLDER_GRADLE_AVD = \"avd\"\n\n        @JvmField\n        @Deprecated(\"Use ANDROID_USER_HOME\")\n        val ANDROID_PREFS_ROOT = \"ANDROID_PREFS_ROOT\"\n\n        @JvmStatic\n        val ANDROID_USER_HOME = \"ANDROID_USER_HOME\"\n    }\n\n    /**\n     * Computes, memoizes in the instance, and returns the location of the .android folder\n     *\n     * To query the AVD Folder, use [avdLocation] as it could be be overridden\n     */\n    @get:Throws(AndroidLocationsException::class)\n    override val prefsLocation: Path by lazy {\n        computeAndroidFolder().also {\n            if (CancellableFileIo.notExists(it)) {\n                try {\n                    Files.createDirectories(it)\n                } catch (e: SecurityException) {\n                    throw AndroidLocationsException(\n                        \"\"\"Unable to create folder '$it'.\n|This is the path of preference folder expected by the Android tools.\"\"\",\n                        e\n                    )\n                }\n            } else if (CancellableFileIo.isRegularFile(it)) {\n                throw AndroidLocationsException(\n                    \"\"\"$it is not a directory!\nThis is the path of preference folder expected by the Android tools.\"\"\"\n                )\n            }\n        }\n    }\n\n    /**\n     * Computes, memoizes in the instance, and returns the location of the AVD folder.\n     */\n    @get:Throws(AndroidLocationsException::class)\n    override val avdLocation: Path by lazy {\n        // check if the location is overridden, if not use default\n        PathLocator(environmentProvider).singlePathOf(Global.ANDROID_AVD_HOME)\n                ?: prefsLocation.resolve(FOLDER_AVD)\n    }");
        return (Path)t4;
    }

    @Override
    @NotNull
    public Path getGradleAvdLocation() throws AndroidLocationsException {
        Lazy lazy = this.gradleAvdLocation$delegate;
        boolean bl = false;
        Object t4 = lazy.getValue();
        Intrinsics.checkExpressionValueIsNotNull(t4, "pyright (C) 2020 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.android.prefs\n\nimport com.android.io.CancellableFileIo\nimport com.android.prefs.AbstractAndroidLocations.Companion.FOLDER_DOT_ANDROID\nimport com.android.utils.EnvironmentProvider\nimport com.android.utils.ILogger\nimport java.nio.file.Files\nimport java.nio.file.Path\nimport java.nio.file.Paths\n\n/**\n * A class that computes various locations used by the Android tools.\n *\n * The values are computed once and then memoized inside the instance.\n *\n * To use as a singleton, use [AndroidLocationsSingleton].\n */\nabstract class AbstractAndroidLocations protected constructor(\n    private val environmentProvider: EnvironmentProvider,\n    private val logger: ILogger,\n    private val silent: Boolean = true\n): AndroidLocationsProvider {\n\n    companion object {\n        /**\n         * The name of the .android folder returned by [prefsLocation], unless [ANDROID_USER_HOME] is used\n         */\n        @JvmField\n        val FOLDER_DOT_ANDROID = \".android\"\n\n        /**\n         * Virtual Device folder inside the path returned by [avdLocation]\n         */\n        @JvmField\n        val FOLDER_AVD = \"avd\"\n\n        /**\n         * Folder for the Android plugin for gradle, containing managed devices.\n         */\n        @JvmField\n        val FOLDER_GRADLE = \"gradle\"\n\n        /**\n         * Virtual Device folder for devices managed by the Android plugin for gradle inside the\n         * path returned by [gradleAvdLocation].\n         */\n        @JvmField\n        val FOLDER_GRADLE_AVD = \"avd\"\n\n        @JvmField\n        @Deprecated(\"Use ANDROID_USER_HOME\")\n        val ANDROID_PREFS_ROOT = \"ANDROID_PREFS_ROOT\"\n\n        @JvmStatic\n        val ANDROID_USER_HOME = \"ANDROID_USER_HOME\"\n    }\n\n    /**\n     * Computes, memoizes in the instance, and returns the location of the .android folder\n     *\n     * To query the AVD Folder, use [avdLocation] as it could be be overridden\n     */\n    @get:Throws(AndroidLocationsException::class)\n    override val prefsLocation: Path by lazy {\n        computeAndroidFolder().also {\n            if (CancellableFileIo.notExists(it)) {\n                try {\n                    Files.createDirectories(it)\n                } catch (e: SecurityException) {\n                    throw AndroidLocationsException(\n                        \"\"\"Unable to create folder '$it'.\n|This is the path of preference folder expected by the Android tools.\"\"\",\n                        e\n                    )\n                }\n            } else if (CancellableFileIo.isRegularFile(it)) {\n                throw AndroidLocationsException(\n                    \"\"\"$it is not a directory!\nThis is the path of preference folder expected by the Android tools.\"\"\"\n                )\n            }\n        }\n    }\n\n    /**\n     * Computes, memoizes in the instance, and returns the location of the AVD folder.\n     */\n    @get:Throws(AndroidLocationsException::class)\n    override val avdLocation: Path by lazy {\n        // check if the location is overridden, if not use default\n        PathLocator(environmentProvider).singlePathOf(Global.ANDROID_AVD_HOME)\n                ?: prefsLocation.resolve(FOLDER_AVD)\n    }\n\n    @get:Throws(AndroidLocationsException::class)\n    override val gradleAvdLocation: Path by lazy {\n        prefsLocation.resolve(FOLDER_GRADLE).resolve(FOLDER_GRADLE_AVD)\n    }");
        return (Path)t4;
    }

    @Override
    @NotNull
    public Path getUserHomeLocation() {
        Lazy lazy = this.userHomeLocation$delegate;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    private final Path computeAndroidFolder() {
        Path path;
        Global[] globalArray;
        AndroidPathLocator locator = new AndroidPathLocator(this.environmentProvider, !this.silent ? this.logger : null);
        Path folder = locator.singlePathOf(globalArray = new Global[]{Global.ANDROID_USER_HOME, Global.ANDROID_PREFS_ROOT, Global.ANDROID_SDK_HOME});
        if (folder != null) {
            if (locator.getVisitedVariables().size() > 1 && !this.silent) {
                String message2 = AbstractAndroidLocationsKt.combineLocationValuesIntoMessage$default(locator.getVisitedVariables(), "More than one location points to the Android preference location\nbut only one is valid", null, computeAndroidFolder.message.1.INSTANCE, 4, null);
                this.logger.warning(message2, new Object[0]);
            }
            return folder;
        }
        PathLocator pathLocator = new PathLocator(this.environmentProvider);
        Global[] globalArray2 = new Global[]{Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME};
        Path path2 = pathLocator.firstPathOf(globalArray2);
        Path path3 = path = path2 == null ? null : path2.resolve(FOLDER_DOT_ANDROID);
        if (path == null) {
            throw new AndroidLocationsException(AbstractAndroidLocationsKt.combineLocationValuesIntoMessage$default(CollectionsKt.plus((Collection)locator.getVisitedVariables(), (Iterable)pathLocator.getVisitedVariables()), "Unable to find the location for the android preferences.\nThe following locations have been checked, but they do not exist:", null, null, 12, null), null, 2, null);
        }
        return path;
    }

    @NotNull
    public static final String getANDROID_USER_HOME() {
        return Companion.getANDROID_USER_HOME();
    }

    public static final /* synthetic */ Path access$computeAndroidFolder(AbstractAndroidLocations $this) {
        return $this.computeAndroidFolder();
    }

    public static final /* synthetic */ EnvironmentProvider access$getEnvironmentProvider$p(AbstractAndroidLocations $this) {
        return $this.environmentProvider;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u001c\u0010\u0006\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/prefs/AbstractAndroidLocations$Companion;", "", "()V", "ANDROID_PREFS_ROOT", "", "getANDROID_PREFS_ROOT$annotations", "ANDROID_USER_HOME", "getANDROID_USER_HOME$annotations", "getANDROID_USER_HOME", "()Ljava/lang/String;", "FOLDER_AVD", "FOLDER_DOT_ANDROID", "FOLDER_GRADLE", "FOLDER_GRADLE_AVD", "common"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use ANDROID_USER_HOME")
        public static /* synthetic */ void getANDROID_PREFS_ROOT$annotations() {
        }

        @NotNull
        public final String getANDROID_USER_HOME() {
            return ANDROID_USER_HOME;
        }

        @JvmStatic
        public static /* synthetic */ void getANDROID_USER_HOME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

