/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.PayloadInputStream;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class ZipReader
implements AutoCloseable {
    private final ZipMap zipMap;
    private final FileChannel fileChannel;

    private ZipReader(ZipMap zipMap, FileChannel fileChannel) {
        this.zipMap = zipMap;
        this.fileChannel = fileChannel;
    }

    @MustBeClosed
    public static ZipReader createFromFile(Path zipFile) {
        Preconditions.checkNotNull(zipFile);
        Preconditions.checkArgument(Files.exists(zipFile, new LinkOption[0]));
        try {
            return new ZipReader(ZipMap.from(zipFile.toFile()), FileChannel.open(zipFile, StandardOpenOption.READ));
        }
        catch (IllegalStateException e5) {
            throw InvalidBundleException.builder().withCause(e5).withUserMessage("The file does not seem to be a valid zip file.").build();
        }
        catch (IOException e6) {
            throw new UncheckedIOException(e6);
        }
    }

    public ImmutableMap<String, Entry> getEntries() {
        return ImmutableMap.copyOf(this.zipMap.getEntries());
    }

    public Optional<Entry> getEntry(String entryName) {
        return Optional.ofNullable(this.zipMap.getEntries().get(entryName));
    }

    public InputStream getPayload(String entryName) {
        Entry entry = this.getEntry(entryName).orElseThrow(() -> new EntryNotFoundException(this.zipMap.getFile(), entryName));
        return this.getEntryPayload(entry);
    }

    @MustBeClosed
    public InputStream getUncompressedPayload(String entryName) {
        Entry entry = this.getEntry(entryName).orElseThrow(() -> new EntryNotFoundException(this.zipMap.getFile(), entryName));
        InputStream entryPayload = this.getEntryPayload(entry);
        if (!entry.isCompressed()) {
            return entryPayload;
        }
        Inflater inflater = new Inflater(true);
        return new InflaterInputStream(entryPayload, inflater);
    }

    private InputStream getEntryPayload(Entry entry) {
        try {
            return new PayloadInputStream(this.fileChannel, entry.getPayloadLocation());
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    public void transferTo(ZipWriter zipWriter, String entryName) {
        Entry entry = this.getEntry(entryName).orElseThrow(() -> new EntryNotFoundException(this.zipMap.getFile(), entryName));
        Location payloadLocation = entry.getPayloadLocation();
        try {
            zipWriter.transferFrom(this.fileChannel, payloadLocation.first, payloadLocation.size());
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    static class EntryNotFoundException
    extends CommandExecutionException {
        EntryNotFoundException(File zipFile, String entryName) {
            super("Internal error.", String.format("Entry '%s' not found in zip file '%s'.", entryName, zipFile.getPath()));
        }
    }
}

