/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_KeystoreProperties;
import com.android.tools.build.bundletool.model.Password;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.google.auto.value.AutoValue;
import com.google.common.io.MoreFiles;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class KeystoreProperties {
    static final String KEYSTORE_PATH_PROPERTY_NAME = "ks";
    static final String KEY_ALIAS_PROPERTY_NAME = "ks-key-alias";
    static final String KEYSTORE_PASSWORD_PROPERTY_NAME = "ks-pass";
    static final String KEY_PASSWORD_PROPERTY_NAME = "key-pass";

    KeystoreProperties() {
    }

    public abstract Path getKeystorePath();

    public abstract String getKeyAlias();

    public abstract Optional<Password> getKeystorePassword();

    public abstract Optional<Password> getKeyPassword();

    public static Builder builder() {
        return new AutoValue_KeystoreProperties.Builder();
    }

    public static KeystoreProperties readFromFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        Properties properties = new Properties();
        try (InputStream inputStream = MoreFiles.asByteSource(path, new OpenOption[0]).openBufferedStream();){
            properties.load(inputStream);
        }
        catch (IOException e5) {
            throw CommandExecutionException.builder().withInternalMessage("Error while loading keystore properties from file %s.", path).withCause(e5).build();
        }
        String keystorePath = properties.getProperty(KEYSTORE_PATH_PROPERTY_NAME);
        String keyAlias = properties.getProperty(KEY_ALIAS_PROPERTY_NAME);
        String keystorePassword = properties.getProperty(KEYSTORE_PASSWORD_PROPERTY_NAME);
        String keyPassword = properties.getProperty(KEY_PASSWORD_PROPERTY_NAME);
        if (keystorePath == null) {
            throw CommandExecutionException.builder().withInternalMessage("No value was given for property '%s' in %s.", KEYSTORE_PATH_PROPERTY_NAME, path).build();
        }
        if (keyAlias == null) {
            throw CommandExecutionException.builder().withInternalMessage("No value was given for property '%s' in %s.", KEY_ALIAS_PROPERTY_NAME, path).build();
        }
        Builder keystoreProperties = KeystoreProperties.builder().setKeystorePath(FileUtils.getPath(keystorePath)).setKeyAlias(keyAlias);
        if (keystorePassword != null) {
            keystoreProperties.setKeystorePassword(Password.createFromStringValue(keystorePassword));
        }
        if (keyPassword != null) {
            keystoreProperties.setKeyPassword(Password.createFromStringValue(keyPassword));
        }
        return keystoreProperties.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setKeystorePath(Path var1);

        public abstract Builder setKeyAlias(String var1);

        public abstract Builder setKeystorePassword(Password var1);

        public abstract Builder setKeyPassword(Password var1);

        public abstract KeystoreProperties build();
    }
}

