/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.tools.build.bundletool.mergers.ModuleSplitsToShardMerger;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.android.tools.build.bundletool.shards.Sharder;
import com.android.tools.build.bundletool.splitters.CodeTransparencyInjector;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;

public class StandaloneApksGenerator {
    private final Optional<SourceStamp> stampSource;
    private final ModuleSplitterForShards moduleSplitter;
    private final Sharder sharder;
    private final ModuleSplitsToShardMerger shardsMerger;
    private final CodeTransparencyInjector codeTransparencyInjector;

    @Inject
    public StandaloneApksGenerator(Optional<SourceStamp> stampSource, ModuleSplitterForShards moduleSplitter, Sharder sharder, ModuleSplitsToShardMerger shardsMerger, AppBundle appBundle) {
        this.stampSource = stampSource;
        this.moduleSplitter = moduleSplitter;
        this.sharder = sharder;
        this.shardsMerger = shardsMerger;
        this.codeTransparencyInjector = new CodeTransparencyInjector(appBundle);
    }

    public ImmutableList<ModuleSplit> generateStandaloneApks(ImmutableList<BundleModule> modules, ApkOptimizations apkOptimizations) {
        ImmutableList<ModuleSplit> splits = modules.stream().flatMap(module -> this.moduleSplitter.generateSplits((BundleModule)module, apkOptimizations.getStandaloneDimensions()).stream()).collect(ImmutableList.toImmutableList());
        HashMap dexCache = Maps.newHashMap();
        return this.sharder.groupSplitsToShards(splits).stream().map(unfusedShard -> this.shardsMerger.mergeSingleShard((ImmutableCollection<ModuleSplit>)unfusedShard, dexCache)).map(StandaloneApksGenerator::setVariantTargetingAndSplitType).map(this::writeSourceStampInManifest).map(this.codeTransparencyInjector::inject).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit setVariantTargetingAndSplitType(ModuleSplit shard) {
        return shard.toBuilder().setVariantTargeting(TargetingUtils.standaloneApkVariantTargeting(shard)).setSplitType(ModuleSplit.SplitType.STANDALONE).build();
    }

    private ModuleSplit writeSourceStampInManifest(ModuleSplit shard) {
        return this.stampSource.map(stampSource -> shard.writeSourceStampInManifest(stampSource.getSource(), SourceStamp.StampType.STAMP_TYPE_STANDALONE_APK)).orElse(shard);
    }
}

