/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.errors.l;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.s.a.a.b.Y;
import com.android.tools.r8.utils.V;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public final class Reference {
    public static PrimitiveReference BOOL = PrimitiveReference.a;
    public static PrimitiveReference BYTE = PrimitiveReference.b;
    public static PrimitiveReference CHAR = PrimitiveReference.c;
    public static PrimitiveReference SHORT = PrimitiveReference.d;
    public static PrimitiveReference INT = PrimitiveReference.e;
    public static PrimitiveReference FLOAT = PrimitiveReference.f;
    public static PrimitiveReference LONG = PrimitiveReference.g;
    public static PrimitiveReference DOUBLE = PrimitiveReference.h;

    public static TypeReference returnTypeFromDescriptor(String string) {
        return string.equals("V") ? null : Reference.typeFromDescriptor(string);
    }

    public static TypeReference typeFromDescriptor(String string) {
        char c5 = string.charAt(0);
        if (c5 != 'L') {
            if (c5 != '[') {
                return Reference.primitiveFromDescriptor(string);
            }
            return Reference.arrayFromDescriptor(string);
        }
        return Reference.classFromDescriptor(string);
    }

    public static TypeReference typeFromTypeName(String string) {
        return Reference.typeFromDescriptor(V.A(string));
    }

    private static TypeReference a(Class<?> clazz) {
        return Reference.typeFromDescriptor(V.A(clazz.getTypeName()));
    }

    public static PrimitiveReference primitiveFromDescriptor(String object) {
        if (!PrimitiveReference.i && ((String)object).length() != 1) {
            throw new AssertionError();
        }
        switch (((String)object).charAt(0)) {
            default: {
                throw new l("Invalid primitive descriptor: " + (String)object);
            }
            case 'Z': {
                object = PrimitiveReference.a;
                break;
            }
            case 'S': {
                object = PrimitiveReference.d;
                break;
            }
            case 'J': {
                object = PrimitiveReference.g;
                break;
            }
            case 'I': {
                object = PrimitiveReference.e;
                break;
            }
            case 'F': {
                object = PrimitiveReference.f;
                break;
            }
            case 'D': {
                object = PrimitiveReference.h;
                break;
            }
            case 'C': {
                object = PrimitiveReference.c;
                break;
            }
            case 'B': {
                object = PrimitiveReference.b;
            }
        }
        return object;
    }

    public static ClassReference classFromDescriptor(String string) {
        return ClassReference.a(string);
    }

    public static ClassReference classFromBinaryName(String string) {
        return Reference.classFromDescriptor(V.k(string));
    }

    public static ClassReference classFromTypeName(String string) {
        return Reference.classFromDescriptor(V.A(string));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String string) {
        return ArrayReference.a(string);
    }

    public static ArrayReference array(TypeReference typeReference, int n4) {
        return ArrayReference.a(typeReference, n4);
    }

    public static MethodReference method(ClassReference classReference, String string, List<TypeReference> list2, TypeReference typeReference) {
        list2 = Y.a(list2);
        return new MethodReference(classReference, string, list2, typeReference);
    }

    public static MethodReference methodFromMethod(Method object) {
        Method method = object;
        String string = method.getName();
        Object object2 = method.getDeclaringClass();
        Object object3 = method.getParameterTypes();
        object = ((Method)object).getReturnType();
        Y.a<TypeReference> a5 = Y.f();
        int n4 = ((Class<?>[])object3).length;
        for (int i4 = 0; i4 < n4; ++i4) {
            a5.c(Reference.a(object3[i4]));
        }
        object2 = Reference.classFromClass(object2);
        object3 = a5.a();
        object = object == Void.TYPE ? null : Reference.a(object);
        return Reference.method((ClassReference)object2, string, object3, (TypeReference)object);
    }

    public static MethodReference methodFromMethod(Constructor<?> genericDeclaration) {
        Constructor<?> constructor = genericDeclaration;
        genericDeclaration = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        Y.a<TypeReference> a5 = Y.f();
        int n4 = classArray.length;
        for (int i4 = 0; i4 < n4; ++i4) {
            a5.c(Reference.a(classArray[i4]));
        }
        return Reference.method(Reference.classFromClass(genericDeclaration), "<init>", a5.a(), null);
    }

    public static MethodReference methodFromDescriptor(String object, String string, String object2) {
        Object object3 = Y.f();
        String[] stringArray = V.e((String)object2);
        int n4 = stringArray.length;
        for (int i4 = 0; i4 < n4; ++i4) {
            ((Y.a)object3).c(Reference.typeFromDescriptor(stringArray[i4]));
        }
        object2 = V.s((String)object2);
        object = Reference.classFromDescriptor((String)object);
        object3 = ((Y.a)object3).a();
        object2 = ((String)object2).equals("V") ? null : Reference.typeFromDescriptor((String)object2);
        return Reference.method((ClassReference)object, string, (List<TypeReference>)object3, (TypeReference)object2);
    }

    public static MethodReference classConstructor(ClassReference classReference) {
        return Reference.method(classReference, "<clinit>", Collections.emptyList(), null);
    }

    public static FieldReference field(ClassReference classReference, String string, TypeReference typeReference) {
        return new FieldReference(classReference, string, typeReference);
    }

    public static FieldReference fieldFromField(Field annotatedElement) {
        Field field = annotatedElement;
        annotatedElement = field.getDeclaringClass();
        String string = field.getName();
        Class<?> clazz = field.getType();
        return Reference.field(Reference.classFromClass(annotatedElement), string, Reference.a(clazz));
    }

    public static PackageReference packageFromString(String string) {
        return new PackageReference(string);
    }

    public static PackageReference packageFromPackage(Package package_) {
        return new PackageReference(package_.getName());
    }
}

