/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Verify {
    public static void verify(boolean expression) {
        if (!expression) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, char p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12)));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, int p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, long p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, char p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, int p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, long p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, char p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, Character.valueOf(p22)));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, char p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, int p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, long p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, int p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, char p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, int p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, long p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, long p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, char p12, @Nullable Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, Character.valueOf(p12), p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, int p12, @Nullable Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, long p12, @Nullable Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, @Nullable Object p22) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, @Nullable Object p22, @Nullable Object p32) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32));
        }
    }

    public static void verify(boolean expression, @Nullable String errorMessageTemplate, @Nullable Object p12, @Nullable Object p22, @Nullable Object p32, @Nullable Object p4) {
        if (!expression) {
            throw new VerifyException(Strings.lenientFormat(errorMessageTemplate, p12, p22, p32, p4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        Verify.verify(reference != null, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    private Verify() {
    }
}

