/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    public static final LazyStringList EMPTY;
    private final List<Object> list;

    static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>(initialCapacity));
    }

    public LazyStringArrayList(LazyStringList from) {
        this.list = new ArrayList<Object>(from.size());
        this.addAll(from);
    }

    public LazyStringArrayList(List<String> from) {
        this(new ArrayList<Object>(from));
    }

    private LazyStringArrayList(ArrayList<Object> list2) {
        this.list = list2;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> newList = new ArrayList<Object>(capacity);
        newList.addAll(this.list);
        return new LazyStringArrayList(newList);
    }

    @Override
    public String get(int index) {
        Object o4 = this.list.get(index);
        if (o4 instanceof String) {
            return (String)o4;
        }
        if (o4 instanceof ByteString) {
            ByteString bs = (ByteString)o4;
            String s4 = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
                this.list.set(index, s4);
            }
            return s4;
        }
        byte[] ba = (byte[])o4;
        String s5 = Internal.toStringUtf8(ba);
        if (Internal.isValidUtf8(ba)) {
            this.list.set(index, s5);
        }
        return s5;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index, String s4) {
        this.ensureIsMutable();
        Object o4 = this.list.set(index, s4);
        return LazyStringArrayList.asString(o4);
    }

    @Override
    public void add(int index, String element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, ByteString element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, byte[] element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c5) {
        return this.addAll(this.size(), c5);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c5) {
        this.ensureIsMutable();
        Collection<? extends String> collection = c5 instanceof LazyStringList ? ((LazyStringList)c5).getUnderlyingElements() : c5;
        boolean ret = this.list.addAll(index, collection);
        ++this.modCount;
        return ret;
    }

    @Override
    public boolean addAllByteString(Collection<? extends ByteString> values2) {
        this.ensureIsMutable();
        boolean ret = this.list.addAll(values2);
        ++this.modCount;
        return ret;
    }

    @Override
    public boolean addAllByteArray(Collection<byte[]> c5) {
        this.ensureIsMutable();
        boolean ret = this.list.addAll(c5);
        ++this.modCount;
        return ret;
    }

    @Override
    public String remove(int index) {
        this.ensureIsMutable();
        Object o4 = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(o4);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public void add(byte[] element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int index) {
        return this.list.get(index);
    }

    @Override
    public ByteString getByteString(int index) {
        Object o4 = this.list.get(index);
        ByteString b5 = LazyStringArrayList.asByteString(o4);
        if (b5 != o4) {
            this.list.set(index, b5);
        }
        return b5;
    }

    @Override
    public byte[] getByteArray(int index) {
        Object o4 = this.list.get(index);
        byte[] b5 = LazyStringArrayList.asByteArray(o4);
        if (b5 != o4) {
            this.list.set(index, b5);
        }
        return b5;
    }

    @Override
    public void set(int index, ByteString s4) {
        this.setAndReturn(index, s4);
    }

    private Object setAndReturn(int index, ByteString s4) {
        this.ensureIsMutable();
        return this.list.set(index, s4);
    }

    @Override
    public void set(int index, byte[] s4) {
        this.setAndReturn(index, s4);
    }

    private Object setAndReturn(int index, byte[] s4) {
        this.ensureIsMutable();
        return this.list.set(index, s4);
    }

    private static String asString(Object o4) {
        if (o4 instanceof String) {
            return (String)o4;
        }
        if (o4 instanceof ByteString) {
            return ((ByteString)o4).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])o4);
    }

    private static ByteString asByteString(Object o4) {
        if (o4 instanceof ByteString) {
            return (ByteString)o4;
        }
        if (o4 instanceof String) {
            return ByteString.copyFromUtf8((String)o4);
        }
        return ByteString.copyFrom((byte[])o4);
    }

    private static byte[] asByteArray(Object o4) {
        if (o4 instanceof byte[]) {
            return (byte[])o4;
        }
        if (o4 instanceof String) {
            return Internal.toByteArray((String)o4);
        }
        return ((ByteString)o4).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void mergeFrom(LazyStringList other) {
        this.ensureIsMutable();
        for (Object o4 : other.getUnderlyingElements()) {
            if (o4 instanceof byte[]) {
                byte[] b5 = (byte[])o4;
                this.list.add(Arrays.copyOf(b5, b5.length));
                continue;
            }
            this.list.add(o4);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteStringListView(LazyStringArrayList list2) {
            this.list = list2;
        }

        @Override
        public ByteString get(int index) {
            return this.list.getByteString(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public ByteString set(int index, ByteString s4) {
            Object o4 = this.list.setAndReturn(index, s4);
            ++this.modCount;
            return LazyStringArrayList.asByteString(o4);
        }

        @Override
        public void add(int index, ByteString s4) {
            this.list.add(index, s4);
            ++this.modCount;
        }

        @Override
        public ByteString remove(int index) {
            String o4 = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteString(o4);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteArrayListView(LazyStringArrayList list2) {
            this.list = list2;
        }

        @Override
        public byte[] get(int index) {
            return this.list.getByteArray(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public byte[] set(int index, byte[] s4) {
            Object o4 = this.list.setAndReturn(index, s4);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(o4);
        }

        @Override
        public void add(int index, byte[] s4) {
            this.list.add(index, s4);
            ++this.modCount;
        }

        @Override
        public byte[] remove(int index) {
            String o4 = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(o4);
        }
    }
}

