/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Generator;

public abstract class DERGenerator
extends ASN1Generator {
    private boolean _tagged = false;
    private boolean _isExplicit;
    private int _tagNo;

    protected DERGenerator(OutputStream outputStream) {
        super(outputStream);
    }

    public DERGenerator(OutputStream outputStream, int n4, boolean bl) {
        super(outputStream);
        this._tagged = true;
        this._isExplicit = bl;
        this._tagNo = n4;
    }

    private void writeLength(OutputStream outputStream, int n4) throws IOException {
        if (n4 > 127) {
            int n5 = 1;
            int n6 = n4;
            while ((n6 >>>= 8) != 0) {
                ++n5;
            }
            outputStream.write((byte)(n5 | 0x80));
            for (int i4 = (n5 - 1) * 8; i4 >= 0; i4 -= 8) {
                outputStream.write((byte)(n4 >> i4));
            }
        } else {
            outputStream.write((byte)n4);
        }
    }

    void writeDEREncoded(OutputStream outputStream, int n4, byte[] byArray) throws IOException {
        outputStream.write(n4);
        this.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    void writeDEREncoded(int n4, byte[] byArray) throws IOException {
        if (this._tagged) {
            int n5 = this._tagNo | 0x80;
            if (this._isExplicit) {
                int n6 = this._tagNo | 0x20 | 0x80;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.writeDEREncoded(byteArrayOutputStream, n4, byArray);
                this.writeDEREncoded(this._out, n6, byteArrayOutputStream.toByteArray());
            } else if ((n4 & 0x20) != 0) {
                this.writeDEREncoded(this._out, n5 | 0x20, byArray);
            } else {
                this.writeDEREncoded(this._out, n5, byArray);
            }
        } else {
            this.writeDEREncoded(this._out, n4, byArray);
        }
    }
}

