/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.util.Strings;

public abstract class X509NameEntryConverter {
    protected ASN1Primitive convertHexEncoded(String string, int n4) throws IOException {
        string = Strings.toLowerCase(string);
        byte[] byArray = new byte[(string.length() - n4) / 2];
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            char c5 = string.charAt(i4 * 2 + n4);
            char c6 = string.charAt(i4 * 2 + n4 + 1);
            byArray[i4] = c5 < 'a' ? (byte)(c5 - 48 << 4) : (byte)(c5 - 97 + 10 << 4);
            if (c6 < 'a') {
                int n5 = i4;
                byArray[n5] = (byte)(byArray[n5] | (byte)(c6 - 48));
                continue;
            }
            int n6 = i4;
            byArray[n6] = (byte)(byArray[n6] | (byte)(c6 - 97 + 10));
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String string) {
        return DERPrintableString.isPrintableString(string);
    }

    public abstract ASN1Primitive getConvertedValue(ASN1ObjectIdentifier var1, String var2);
}

