/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;

public abstract class StreamBlockCipher
implements BlockCipher,
StreamCipher {
    private final BlockCipher cipher;

    protected StreamBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public final byte returnByte(byte by) {
        return this.calculateByte(by);
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException {
        if (n6 + n5 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (n4 + n5 > byArray.length) {
            throw new DataLengthException("input buffer too small");
        }
        int n7 = n4;
        int n8 = n4 + n5;
        int n9 = n6;
        while (n7 < n8) {
            byArray2[n9++] = this.calculateByte(byArray[n7++]);
        }
        return n5;
    }

    protected abstract byte calculateByte(byte var1);
}

