/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class NoekeonEngine
implements BlockCipher {
    private static final int genericSize = 16;
    private static final int[] nullVector = new int[]{0, 0, 0, 0};
    private static final int[] roundConstants = new int[]{128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212};
    private int[] state = new int[4];
    private int[] subKeys = new int[4];
    private int[] decryptKeys = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    public String getAlgorithmName() {
        return "Noekeon";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to Noekeon init - " + cipherParameters.getClass().getName());
        }
        this._forEncryption = bl;
        this._initialised = true;
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.setKey(keyParameter.getKey());
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        if (!this._initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n4 + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n5 + 16 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(byArray, n4, byArray2, n5) : this.decryptBlock(byArray, n4, byArray2, n5);
    }

    public void reset() {
    }

    private void setKey(byte[] byArray) {
        this.subKeys[0] = this.bytesToIntBig(byArray, 0);
        this.subKeys[1] = this.bytesToIntBig(byArray, 4);
        this.subKeys[2] = this.bytesToIntBig(byArray, 8);
        this.subKeys[3] = this.bytesToIntBig(byArray, 12);
    }

    private int encryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        this.state[0] = this.bytesToIntBig(byArray, n4);
        this.state[1] = this.bytesToIntBig(byArray, n4 + 4);
        this.state[2] = this.bytesToIntBig(byArray, n4 + 8);
        this.state[3] = this.bytesToIntBig(byArray, n4 + 12);
        for (n6 = 0; n6 < 16; ++n6) {
            this.state[0] = this.state[0] ^ roundConstants[n6];
            this.theta(this.state, this.subKeys);
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
        }
        this.state[0] = this.state[0] ^ roundConstants[n6];
        this.theta(this.state, this.subKeys);
        this.intToBytesBig(this.state[0], byArray2, n5);
        this.intToBytesBig(this.state[1], byArray2, n5 + 4);
        this.intToBytesBig(this.state[2], byArray2, n5 + 8);
        this.intToBytesBig(this.state[3], byArray2, n5 + 12);
        return 16;
    }

    private int decryptBlock(byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6;
        this.state[0] = this.bytesToIntBig(byArray, n4);
        this.state[1] = this.bytesToIntBig(byArray, n4 + 4);
        this.state[2] = this.bytesToIntBig(byArray, n4 + 8);
        this.state[3] = this.bytesToIntBig(byArray, n4 + 12);
        System.arraycopy(this.subKeys, 0, this.decryptKeys, 0, this.subKeys.length);
        this.theta(this.decryptKeys, nullVector);
        for (n6 = 16; n6 > 0; --n6) {
            this.theta(this.state, this.decryptKeys);
            this.state[0] = this.state[0] ^ roundConstants[n6];
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
        }
        this.theta(this.state, this.decryptKeys);
        this.state[0] = this.state[0] ^ roundConstants[n6];
        this.intToBytesBig(this.state[0], byArray2, n5);
        this.intToBytesBig(this.state[1], byArray2, n5 + 4);
        this.intToBytesBig(this.state[2], byArray2, n5 + 8);
        this.intToBytesBig(this.state[3], byArray2, n5 + 12);
        return 16;
    }

    private void gamma(int[] nArray) {
        nArray[1] = nArray[1] ^ ~nArray[3] & ~nArray[2];
        nArray[0] = nArray[0] ^ nArray[2] & nArray[1];
        int n4 = nArray[3];
        nArray[3] = nArray[0];
        nArray[0] = n4;
        nArray[2] = nArray[2] ^ (nArray[0] ^ nArray[1] ^ nArray[3]);
        nArray[1] = nArray[1] ^ ~nArray[3] & ~nArray[2];
        nArray[0] = nArray[0] ^ nArray[2] & nArray[1];
    }

    private void theta(int[] nArray, int[] nArray2) {
        int n4 = nArray[0] ^ nArray[2];
        n4 ^= this.rotl(n4, 8) ^ this.rotl(n4, 24);
        nArray[1] = nArray[1] ^ n4;
        nArray[3] = nArray[3] ^ n4;
        for (int i4 = 0; i4 < 4; ++i4) {
            int n5 = i4;
            nArray[n5] = nArray[n5] ^ nArray2[i4];
        }
        n4 = nArray[1] ^ nArray[3];
        n4 ^= this.rotl(n4, 8) ^ this.rotl(n4, 24);
        nArray[0] = nArray[0] ^ n4;
        nArray[2] = nArray[2] ^ n4;
    }

    private void pi1(int[] nArray) {
        nArray[1] = this.rotl(nArray[1], 1);
        nArray[2] = this.rotl(nArray[2], 5);
        nArray[3] = this.rotl(nArray[3], 2);
    }

    private void pi2(int[] nArray) {
        nArray[1] = this.rotl(nArray[1], 31);
        nArray[2] = this.rotl(nArray[2], 27);
        nArray[3] = this.rotl(nArray[3], 30);
    }

    private int bytesToIntBig(byte[] byArray, int n4) {
        return byArray[n4++] << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4] & 0xFF;
    }

    private void intToBytesBig(int n4, byte[] byArray, int n5) {
        byArray[n5++] = (byte)(n4 >>> 24);
        byArray[n5++] = (byte)(n4 >>> 16);
        byArray[n5++] = (byte)(n4 >>> 8);
        byArray[n5] = (byte)n4;
    }

    private int rotl(int n4, int n5) {
        return n4 << n5 | n4 >>> 32 - n5;
    }
}

