/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.util.DigestFactory;

public class OpenSSLPBEParametersGenerator
extends PBEParametersGenerator {
    private Digest digest = DigestFactory.createMD5();

    public void init(byte[] byArray, byte[] byArray2) {
        super.init(byArray, byArray2, 1);
    }

    private byte[] generateDerivedKey(int n4) {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            this.digest.doFinal(byArray, 0);
            int n6 = n4 > byArray.length ? byArray.length : n4;
            System.arraycopy(byArray, 0, byArray2, n5, n6);
            n5 += n6;
            if ((n4 -= n6) == 0) break;
            this.digest.reset();
            this.digest.update(byArray, 0, byArray.length);
        }
        return byArray2;
    }

    public CipherParameters generateDerivedParameters(int n4) {
        byte[] byArray = this.generateDerivedKey(n4 /= 8);
        return new KeyParameter(byArray, 0, n4);
    }

    public CipherParameters generateDerivedParameters(int n4, int n5) {
        byte[] byArray = this.generateDerivedKey((n4 /= 8) + (n5 /= 8));
        return new ParametersWithIV(new KeyParameter(byArray, 0, n4), byArray, n4, n5);
    }

    public CipherParameters generateDerivedMacParameters(int n4) {
        return this.generateDerivedParameters(n4);
    }
}

