/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.io.CipherIOException;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private AEADBlockCipher aeadBlockCipher;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.bufferedBlockCipher = bufferedBlockCipher;
    }

    public CipherOutputStream(OutputStream outputStream, StreamCipher streamCipher) {
        super(outputStream);
        this.streamCipher = streamCipher;
    }

    public CipherOutputStream(OutputStream outputStream, AEADBlockCipher aEADBlockCipher) {
        super(outputStream);
        this.aeadBlockCipher = aEADBlockCipher;
    }

    public void write(int n4) throws IOException {
        this.oneByte[0] = (byte)n4;
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)n4));
        } else {
            this.write(this.oneByte, 0, 1);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n4, int n5) throws IOException {
        this.ensureCapacity(n5, false);
        if (this.bufferedBlockCipher != null) {
            int n6 = this.bufferedBlockCipher.processBytes(byArray, n4, n5, this.buf, 0);
            if (n6 != 0) {
                this.out.write(this.buf, 0, n6);
            }
        } else if (this.aeadBlockCipher != null) {
            int n7 = this.aeadBlockCipher.processBytes(byArray, n4, n5, this.buf, 0);
            if (n7 != 0) {
                this.out.write(this.buf, 0, n7);
            }
        } else {
            this.streamCipher.processBytes(byArray, n4, n5, this.buf, 0);
            this.out.write(this.buf, 0, n5);
        }
    }

    private void ensureCapacity(int n4, boolean bl) {
        int n5 = n4;
        if (bl) {
            if (this.bufferedBlockCipher != null) {
                n5 = this.bufferedBlockCipher.getOutputSize(n4);
            } else if (this.aeadBlockCipher != null) {
                n5 = this.aeadBlockCipher.getOutputSize(n4);
            }
        } else if (this.bufferedBlockCipher != null) {
            n5 = this.bufferedBlockCipher.getUpdateOutputSize(n4);
        } else if (this.aeadBlockCipher != null) {
            n5 = this.aeadBlockCipher.getUpdateOutputSize(n4);
        }
        if (this.buf == null || this.buf.length < n5) {
            this.buf = new byte[n5];
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        IOException iOException;
        block13: {
            this.ensureCapacity(0, true);
            iOException = null;
            try {
                int n4;
                if (this.bufferedBlockCipher != null) {
                    n4 = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (n4 != 0) {
                        this.out.write(this.buf, 0, n4);
                    }
                } else if (this.aeadBlockCipher != null) {
                    n4 = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (n4 != 0) {
                        this.out.write(this.buf, 0, n4);
                    }
                } else if (this.streamCipher != null) {
                    this.streamCipher.reset();
                }
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                iOException = new InvalidCipherTextIOException("Error finalising cipher data", invalidCipherTextException);
            }
            catch (Exception exception) {
                iOException = new CipherIOException("Error closing stream: ", exception);
            }
            try {
                this.flush();
                this.out.close();
            }
            catch (IOException iOException2) {
                if (iOException != null) break block13;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }
}

