/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import org.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] byArray) {
        super(byArray);
        if (DESedeParameters.isWeakKey(byArray, 0, byArray.length)) {
            throw new IllegalArgumentException("attempt to create weak DESede key");
        }
    }

    public static boolean isWeakKey(byte[] byArray, int n4, int n5) {
        for (int i4 = n4; i4 < n5; i4 += 8) {
            if (!DESParameters.isWeakKey(byArray, i4)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] byArray, int n4) {
        return DESedeParameters.isWeakKey(byArray, n4, byArray.length - n4);
    }

    public static boolean isRealEDEKey(byte[] byArray, int n4) {
        return byArray.length == 16 ? DESedeParameters.isReal2Key(byArray, n4) : DESedeParameters.isReal3Key(byArray, n4);
    }

    public static boolean isReal2Key(byte[] byArray, int n4) {
        boolean bl = false;
        for (int i4 = n4; i4 != n4 + 8; ++i4) {
            if (byArray[i4] == byArray[i4 + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray, int n4) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i4 = n4; i4 != n4 + 8; ++i4) {
            bl |= byArray[i4] != byArray[i4 + 8];
            bl2 |= byArray[i4] != byArray[i4 + 16];
            bl3 |= byArray[i4 + 8] != byArray[i4 + 16];
        }
        return bl && bl2 && bl3;
    }
}

