/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

public class Interleave {
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;

    public static int expand8to16(int n4) {
        n4 &= 0xFF;
        n4 = (n4 | n4 << 4) & 0xF0F;
        n4 = (n4 | n4 << 2) & 0x3333;
        n4 = (n4 | n4 << 1) & 0x5555;
        return n4;
    }

    public static int expand16to32(int n4) {
        n4 &= 0xFFFF;
        n4 = (n4 | n4 << 8) & 0xFF00FF;
        n4 = (n4 | n4 << 4) & 0xF0F0F0F;
        n4 = (n4 | n4 << 2) & 0x33333333;
        n4 = (n4 | n4 << 1) & 0x55555555;
        return n4;
    }

    public static long expand32to64(int n4) {
        int n5 = (n4 ^ n4 >>> 8) & 0xFF00;
        n4 ^= n5 ^ n5 << 8;
        n5 = (n4 ^ n4 >>> 4) & 0xF000F0;
        n4 ^= n5 ^ n5 << 4;
        n5 = (n4 ^ n4 >>> 2) & 0xC0C0C0C;
        n4 ^= n5 ^ n5 << 2;
        n5 = (n4 ^ n4 >>> 1) & 0x22222222;
        return ((long)((n4 ^= n5 ^ n5 << 1) >>> 1) & 0x55555555L) << 32 | (long)n4 & 0x55555555L;
    }

    public static void expand64To128(long l4, long[] lArray, int n4) {
        long l5 = (l4 ^ l4 >>> 16) & 0xFFFF0000L;
        l4 ^= l5 ^ l5 << 16;
        l5 = (l4 ^ l4 >>> 8) & 0xFF000000FF00L;
        l4 ^= l5 ^ l5 << 8;
        l5 = (l4 ^ l4 >>> 4) & 0xF000F000F000F0L;
        l4 ^= l5 ^ l5 << 4;
        l5 = (l4 ^ l4 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        l4 ^= l5 ^ l5 << 2;
        l5 = (l4 ^ l4 >>> 1) & 0x2222222222222222L;
        lArray[n4] = (l4 ^= l5 ^ l5 << 1) & 0x5555555555555555L;
        lArray[n4 + 1] = l4 >>> 1 & 0x5555555555555555L;
    }

    public static long unshuffle(long l4) {
        long l5 = (l4 ^ l4 >>> 1) & 0x2222222222222222L;
        l4 ^= l5 ^ l5 << 1;
        l5 = (l4 ^ l4 >>> 2) & 0xC0C0C0C0C0C0C0CL;
        l4 ^= l5 ^ l5 << 2;
        l5 = (l4 ^ l4 >>> 4) & 0xF000F000F000F0L;
        l4 ^= l5 ^ l5 << 4;
        l5 = (l4 ^ l4 >>> 8) & 0xFF000000FF00L;
        l4 ^= l5 ^ l5 << 8;
        l5 = (l4 ^ l4 >>> 16) & 0xFFFF0000L;
        return l4 ^= l5 ^ l5 << 16;
    }
}

