/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.util.Random;
import org.bouncycastle.math.raw.Nat;

public abstract class Mod {
    public static int inverse32(int n4) {
        int n5 = n4;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        n5 *= 2 - n4 * n5;
        return n5;
    }

    public static void invert(int[] nArray, int[] nArray2, int[] nArray3) {
        int n4 = nArray.length;
        if (Nat.isZero(n4, nArray2)) {
            throw new IllegalArgumentException("'x' cannot be 0");
        }
        if (Nat.isOne(n4, nArray2)) {
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
            return;
        }
        int[] nArray4 = Nat.copy(n4, nArray2);
        int[] nArray5 = Nat.create(n4);
        nArray5[0] = 1;
        int n5 = 0;
        if ((nArray4[0] & 1) == 0) {
            n5 = Mod.inversionStep(nArray, nArray4, n4, nArray5, n5);
        }
        if (Nat.isOne(n4, nArray4)) {
            Mod.inversionResult(nArray, n5, nArray5, nArray3);
            return;
        }
        int[] nArray6 = Nat.copy(n4, nArray);
        int[] nArray7 = Nat.create(n4);
        int n6 = 0;
        int n7 = n4;
        while (true) {
            if (nArray4[n7 - 1] == 0 && nArray6[n7 - 1] == 0) {
                --n7;
                continue;
            }
            if (Nat.gte(n7, nArray4, nArray6)) {
                Nat.subFrom(n7, nArray6, nArray4);
                n5 += Nat.subFrom(n4, nArray7, nArray5) - n6;
                n5 = Mod.inversionStep(nArray, nArray4, n7, nArray5, n5);
                if (!Nat.isOne(n7, nArray4)) continue;
                Mod.inversionResult(nArray, n5, nArray5, nArray3);
                return;
            }
            Nat.subFrom(n7, nArray4, nArray6);
            n6 += Nat.subFrom(n4, nArray5, nArray7) - n5;
            n6 = Mod.inversionStep(nArray, nArray6, n7, nArray7, n6);
            if (Nat.isOne(n7, nArray6)) break;
        }
        Mod.inversionResult(nArray, n6, nArray7, nArray3);
    }

    public static int[] random(int[] nArray) {
        int n4 = nArray.length;
        Random random = new Random();
        int[] nArray2 = Nat.create(n4);
        int n5 = nArray[n4 - 1];
        n5 |= n5 >>> 1;
        n5 |= n5 >>> 2;
        n5 |= n5 >>> 4;
        n5 |= n5 >>> 8;
        n5 |= n5 >>> 16;
        do {
            for (int i4 = 0; i4 != n4; ++i4) {
                nArray2[i4] = random.nextInt();
            }
            int n6 = n4 - 1;
            nArray2[n6] = nArray2[n6] & n5;
        } while (Nat.gte(n4, nArray2, nArray));
        return nArray2;
    }

    public static void add(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n4 = nArray.length;
        int n5 = Nat.add(n4, nArray2, nArray3, nArray4);
        if (n5 != 0) {
            Nat.subFrom(n4, nArray, nArray4);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n4 = nArray.length;
        int n5 = Nat.sub(n4, nArray2, nArray3, nArray4);
        if (n5 != 0) {
            Nat.addTo(n4, nArray, nArray4);
        }
    }

    private static void inversionResult(int[] nArray, int n4, int[] nArray2, int[] nArray3) {
        if (n4 < 0) {
            Nat.add(nArray.length, nArray2, nArray, nArray3);
        } else {
            System.arraycopy(nArray2, 0, nArray3, 0, nArray.length);
        }
    }

    private static int inversionStep(int[] nArray, int[] nArray2, int n4, int[] nArray3, int n5) {
        int n6 = nArray.length;
        int n7 = 0;
        while (nArray2[0] == 0) {
            Nat.shiftDownWord(n4, nArray2, 0);
            n7 += 32;
        }
        int n8 = Mod.getTrailingZeroes(nArray2[0]);
        if (n8 > 0) {
            Nat.shiftDownBits(n4, nArray2, n8, 0);
            n7 += n8;
        }
        for (n8 = 0; n8 < n7; ++n8) {
            if ((nArray3[0] & 1) != 0) {
                n5 = n5 < 0 ? (n5 += Nat.addTo(n6, nArray, nArray3)) : (n5 += Nat.subFrom(n6, nArray, nArray3));
            }
            Nat.shiftDownBit(n6, nArray3, n5);
        }
        return n5;
    }

    private static int getTrailingZeroes(int n4) {
        int n5 = 0;
        while ((n4 & 1) == 0) {
            n4 >>>= 1;
            ++n5;
        }
        return n5;
    }
}

