/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.Matrix;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] byArray) {
        if (byArray.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(byArray, 0);
        this.numColumns = LittleEndianConversions.OS2IP(byArray, 4);
        int n4 = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n4 != byArray.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n5 = this.numColumns >> 5;
        int n6 = this.numColumns & 0x1F;
        int n7 = 8;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n8 = 0;
            while (n8 < n5) {
                this.matrix[i4][n8] = LittleEndianConversions.OS2IP(byArray, n7);
                ++n8;
                n7 += 4;
            }
            for (n8 = 0; n8 < n6; n8 += 8) {
                int[] nArray = this.matrix[i4];
                int n9 = n5;
                nArray[n9] = nArray[n9] ^ (byArray[n7++] & 0xFF) << n8;
            }
        }
    }

    public GF2Matrix(int n4, int[][] nArray) {
        if (nArray[0].length != n4 + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = n4;
        this.numRows = nArray.length;
        this.length = nArray[0].length;
        int n5 = n4 & 0x1F;
        int n6 = n5 == 0 ? -1 : (1 << n5) - 1;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int[] nArray2 = nArray[i4];
            int n7 = this.length - 1;
            nArray2[n7] = nArray2[n7] & n6;
        }
        this.matrix = nArray;
    }

    public GF2Matrix(int n4, char c5) {
        this(n4, c5, new SecureRandom());
    }

    public GF2Matrix(int n4, char c5, SecureRandom secureRandom) {
        if (n4 <= 0) {
            throw new ArithmeticException("Size of matrix is non-positive.");
        }
        switch (c5) {
            case 'Z': {
                this.assignZeroMatrix(n4, n4);
                break;
            }
            case 'I': {
                this.assignUnitMatrix(n4);
                break;
            }
            case 'L': {
                this.assignRandomLowerTriangularMatrix(n4, secureRandom);
                break;
            }
            case 'U': {
                this.assignRandomUpperTriangularMatrix(n4, secureRandom);
                break;
            }
            case 'R': {
                this.assignRandomRegularMatrix(n4, secureRandom);
                break;
            }
            default: {
                throw new ArithmeticException("Unknown matrix type.");
            }
        }
    }

    public GF2Matrix(GF2Matrix gF2Matrix) {
        this.numColumns = gF2Matrix.getNumColumns();
        this.numRows = gF2Matrix.getNumRows();
        this.length = gF2Matrix.length;
        this.matrix = new int[gF2Matrix.matrix.length][];
        for (int i4 = 0; i4 < this.matrix.length; ++i4) {
            this.matrix[i4] = IntUtils.clone(gF2Matrix.matrix[i4]);
        }
    }

    private GF2Matrix(int n4, int n5) {
        if (n5 <= 0 || n4 <= 0) {
            throw new ArithmeticException("size of matrix is non-positive");
        }
        this.assignZeroMatrix(n4, n5);
    }

    private void assignZeroMatrix(int n4, int n5) {
        this.numRows = n4;
        this.numColumns = n5;
        this.length = n5 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.length; ++i5) {
                this.matrix[i4][i5] = 0;
            }
        }
    }

    private void assignUnitMatrix(int n4) {
        int n5;
        int n6;
        this.numRows = n4;
        this.numColumns = n4;
        this.length = n4 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (n6 = 0; n6 < this.numRows; ++n6) {
            for (n5 = 0; n5 < this.length; ++n5) {
                this.matrix[n6][n5] = 0;
            }
        }
        for (n6 = 0; n6 < this.numRows; ++n6) {
            n5 = n6 & 0x1F;
            this.matrix[n6][n6 >>> 5] = 1 << n5;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n4, SecureRandom secureRandom) {
        this.numRows = n4;
        this.numColumns = n4;
        this.length = n4 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n5;
            int n6 = i4 >>> 5;
            int n7 = i4 & 0x1F;
            int n8 = 31 - n7;
            n7 = 1 << n7;
            for (n5 = 0; n5 < n6; ++n5) {
                this.matrix[i4][n5] = secureRandom.nextInt();
            }
            this.matrix[i4][n6] = secureRandom.nextInt() >>> n8 | n7;
            for (n5 = n6 + 1; n5 < this.length; ++n5) {
                this.matrix[i4][n5] = 0;
            }
        }
    }

    private void assignRandomUpperTriangularMatrix(int n4, SecureRandom secureRandom) {
        this.numRows = n4;
        this.numColumns = n4;
        this.length = n4 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int n5 = n4 & 0x1F;
        int n6 = n5 == 0 ? -1 : (1 << n5) - 1;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n7;
            int n8;
            int n9 = i4 >>> 5;
            int n10 = n8 = i4 & 0x1F;
            n8 = 1 << n8;
            for (n7 = 0; n7 < n9; ++n7) {
                this.matrix[i4][n7] = 0;
            }
            this.matrix[i4][n9] = secureRandom.nextInt() << n10 | n8;
            for (n7 = n9 + 1; n7 < this.length; ++n7) {
                this.matrix[i4][n7] = secureRandom.nextInt();
            }
            int[] nArray = this.matrix[i4];
            int n11 = this.length - 1;
            nArray[n11] = nArray[n11] & n6;
        }
    }

    private void assignRandomRegularMatrix(int n4, SecureRandom secureRandom) {
        this.numRows = n4;
        this.numColumns = n4;
        this.length = n4 + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        GF2Matrix gF2Matrix = new GF2Matrix(n4, 'L', secureRandom);
        GF2Matrix gF2Matrix2 = new GF2Matrix(n4, 'U', secureRandom);
        GF2Matrix gF2Matrix3 = (GF2Matrix)gF2Matrix.rightMultiply(gF2Matrix2);
        Permutation permutation = new Permutation(n4, secureRandom);
        int[] nArray = permutation.getVector();
        for (int i4 = 0; i4 < n4; ++i4) {
            System.arraycopy(gF2Matrix3.matrix[i4], 0, this.matrix[nArray[i4]], 0, this.length);
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n4, SecureRandom secureRandom) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        GF2Matrix[] gF2MatrixArray = new GF2Matrix[2];
        int n11 = n4 + 31 >> 5;
        GF2Matrix gF2Matrix = new GF2Matrix(n4, 'L', secureRandom);
        GF2Matrix gF2Matrix2 = new GF2Matrix(n4, 'U', secureRandom);
        GF2Matrix gF2Matrix3 = (GF2Matrix)gF2Matrix.rightMultiply(gF2Matrix2);
        Permutation permutation = new Permutation(n4, secureRandom);
        int[] nArray = permutation.getVector();
        int[][] nArray2 = new int[n4][n11];
        for (int i4 = 0; i4 < n4; ++i4) {
            System.arraycopy(gF2Matrix3.matrix[nArray[i4]], 0, nArray2[i4], 0, n11);
        }
        gF2MatrixArray[0] = new GF2Matrix(n4, nArray2);
        GF2Matrix gF2Matrix4 = new GF2Matrix(n4, 'I');
        for (int i5 = 0; i5 < n4; ++i5) {
            n10 = i5 & 0x1F;
            n9 = i5 >>> 5;
            n8 = 1 << n10;
            for (n7 = i5 + 1; n7 < n4; ++n7) {
                n6 = gF2Matrix.matrix[n7][n9] & n8;
                if (n6 == 0) continue;
                for (n5 = 0; n5 <= n9; ++n5) {
                    int[] nArray3 = gF2Matrix4.matrix[n7];
                    int n12 = n5;
                    nArray3[n12] = nArray3[n12] ^ gF2Matrix4.matrix[i5][n5];
                }
            }
        }
        GF2Matrix gF2Matrix5 = new GF2Matrix(n4, 'I');
        for (n10 = n4 - 1; n10 >= 0; --n10) {
            n9 = n10 & 0x1F;
            n8 = n10 >>> 5;
            n7 = 1 << n9;
            for (n6 = n10 - 1; n6 >= 0; --n6) {
                n5 = gF2Matrix2.matrix[n6][n8] & n7;
                if (n5 == 0) continue;
                for (int i6 = n8; i6 < n11; ++i6) {
                    int[] nArray4 = gF2Matrix5.matrix[n6];
                    int n13 = i6;
                    nArray4[n13] = nArray4[n13] ^ gF2Matrix5.matrix[n10][i6];
                }
            }
        }
        gF2MatrixArray[1] = (GF2Matrix)gF2Matrix5.rightMultiply(gF2Matrix4.rightMultiply(permutation));
        return gF2MatrixArray;
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int n4) {
        return this.matrix[n4];
    }

    public byte[] getEncoded() {
        int n4 = this.numColumns + 7 >>> 3;
        n4 *= this.numRows;
        byte[] byArray = new byte[n4 += 8];
        LittleEndianConversions.I2OSP(this.numRows, byArray, 0);
        LittleEndianConversions.I2OSP(this.numColumns, byArray, 4);
        int n5 = this.numColumns >>> 5;
        int n6 = this.numColumns & 0x1F;
        int n7 = 8;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n8 = 0;
            while (n8 < n5) {
                LittleEndianConversions.I2OSP(this.matrix[i4][n8], byArray, n7);
                ++n8;
                n7 += 4;
            }
            for (n8 = 0; n8 < n6; n8 += 8) {
                byArray[n7++] = (byte)(this.matrix[i4][n5] >>> n8 & 0xFF);
            }
        }
        return byArray;
    }

    public double getHammingWeight() {
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = this.numColumns & 0x1F;
        int n5 = n4 == 0 ? this.length : this.length - 1;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n6;
            int n7;
            int n8;
            for (n8 = 0; n8 < n5; ++n8) {
                n7 = this.matrix[i4][n8];
                for (n6 = 0; n6 < 32; ++n6) {
                    int n9 = n7 >>> n6 & 1;
                    d5 += (double)n9;
                    d6 += 1.0;
                }
            }
            n8 = this.matrix[i4][this.length - 1];
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n8 >>> n7 & 1;
                d5 += (double)n6;
                d6 += 1.0;
            }
        }
        return d5 / d6;
    }

    public boolean isZero() {
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.length; ++i5) {
                if (this.matrix[i4][i5] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int n4 = this.numRows + 31 >> 5;
        int[][] nArray = new int[this.numRows][n4];
        int n5 = (1 << (this.numRows & 0x1F)) - 1;
        if (n5 == 0) {
            n5 = -1;
        }
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            System.arraycopy(this.matrix[i4], 0, nArray[i4], 0, n4);
            int[] nArray2 = nArray[i4];
            int n6 = n4 - 1;
            nArray2[n6] = nArray2[n6] & n5;
        }
        return new GF2Matrix(this.numRows, nArray);
    }

    public GF2Matrix extendLeftCompactForm() {
        int n4 = this.numColumns + this.numRows;
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, n4);
        int n5 = this.numRows - 1 + this.numColumns;
        int n6 = this.numRows - 1;
        while (n6 >= 0) {
            System.arraycopy(this.matrix[n6], 0, gF2Matrix.matrix[n6], 0, this.length);
            int[] nArray = gF2Matrix.matrix[n6];
            int n7 = n5 >> 5;
            nArray[n7] = nArray[n7] | 1 << (n5 & 0x1F);
            --n6;
            --n5;
        }
        return gF2Matrix;
    }

    public GF2Matrix getRightSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int n4 = this.numRows >> 5;
        int n5 = this.numRows & 0x1F;
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numColumns - this.numRows);
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            if (n5 != 0) {
                int n6 = n4;
                for (int i5 = 0; i5 < gF2Matrix.length - 1; ++i5) {
                    gF2Matrix.matrix[i4][i5] = this.matrix[i4][n6++] >>> n5 | this.matrix[i4][n6] << 32 - n5;
                }
                gF2Matrix.matrix[i4][gF2Matrix.length - 1] = this.matrix[i4][n6++] >>> n5;
                if (n6 >= this.length) continue;
                int[] nArray = gF2Matrix.matrix[i4];
                int n7 = gF2Matrix.length - 1;
                nArray[n7] = nArray[n7] | this.matrix[i4][n6] << 32 - n5;
                continue;
            }
            System.arraycopy(this.matrix[i4], n4, gF2Matrix.matrix[i4], 0, gF2Matrix.length);
        }
        return gF2Matrix;
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numRows + this.numColumns);
        int n4 = this.numRows >> 5;
        int n5 = this.numRows & 0x1F;
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            int[] nArray = gF2Matrix.matrix[i4];
            int n6 = i4 >> 5;
            nArray[n6] = nArray[n6] | 1 << (i4 & 0x1F);
            if (n5 != 0) {
                int n7;
                int n8 = n4;
                for (n7 = 0; n7 < this.length - 1; ++n7) {
                    int n9 = this.matrix[i4][n7];
                    int[] nArray2 = gF2Matrix.matrix[i4];
                    int n10 = n8++;
                    nArray2[n10] = nArray2[n10] | n9 << n5;
                    int[] nArray3 = gF2Matrix.matrix[i4];
                    int n11 = n8;
                    nArray3[n11] = nArray3[n11] | n9 >>> 32 - n5;
                }
                n7 = this.matrix[i4][this.length - 1];
                int[] nArray4 = gF2Matrix.matrix[i4];
                int n12 = n8++;
                nArray4[n12] = nArray4[n12] | n7 << n5;
                if (n8 >= gF2Matrix.length) continue;
                int[] nArray5 = gF2Matrix.matrix[i4];
                int n13 = n8;
                nArray5[n13] = nArray5[n13] | n7 >>> 32 - n5;
                continue;
            }
            System.arraycopy(this.matrix[i4], 0, gF2Matrix.matrix[i4], n4, this.length);
        }
        return gF2Matrix;
    }

    public Matrix computeTranspose() {
        int[][] nArray = new int[this.numColumns][this.numRows + 31 >>> 5];
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            for (int i5 = 0; i5 < this.numColumns; ++i5) {
                int n4 = i5 >>> 5;
                int n5 = i5 & 0x1F;
                int n6 = this.matrix[i4][n4] >>> n5 & 1;
                int n7 = i4 >>> 5;
                int n8 = i4 & 0x1F;
                if (n6 != 1) continue;
                int[] nArray2 = nArray[i5];
                int n9 = n7;
                nArray2[n9] = nArray2[n9] | 1 << n8;
            }
        }
        return new GF2Matrix(this.numRows, nArray);
    }

    public Matrix computeInverse() {
        int n4;
        int n5;
        int n6;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] nArray = new int[this.numRows][this.length];
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            nArray[i4] = IntUtils.clone(this.matrix[i4]);
        }
        int[][] nArray2 = new int[this.numRows][this.length];
        for (n6 = this.numRows - 1; n6 >= 0; --n6) {
            n5 = n6 >> 5;
            n4 = n6 & 0x1F;
            nArray2[n6][n5] = 1 << n4;
        }
        for (n6 = 0; n6 < this.numRows; ++n6) {
            int n7;
            n5 = n6 >> 5;
            n4 = 1 << (n6 & 0x1F);
            if ((nArray[n6][n5] & n4) == 0) {
                n7 = 0;
                for (int i5 = n6 + 1; i5 < this.numRows; ++i5) {
                    if ((nArray[i5][n5] & n4) == 0) continue;
                    n7 = 1;
                    GF2Matrix.swapRows(nArray, n6, i5);
                    GF2Matrix.swapRows(nArray2, n6, i5);
                    i5 = this.numRows;
                }
                if (n7 == 0) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            for (n7 = this.numRows - 1; n7 >= 0; --n7) {
                if (n7 == n6 || (nArray[n7][n5] & n4) == 0) continue;
                GF2Matrix.addToRow(nArray[n6], nArray[n7], n5);
                GF2Matrix.addToRow(nArray2[n6], nArray2[n7], 0);
            }
        }
        return new GF2Matrix(this.numColumns, nArray2);
    }

    public Matrix leftMultiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (nArray.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[][] nArrayArray = new int[this.numRows][];
        for (int i4 = this.numRows - 1; i4 >= 0; --i4) {
            nArrayArray[i4] = IntUtils.clone(this.matrix[nArray[i4]]);
        }
        return new GF2Matrix(this.numRows, nArrayArray);
    }

    public Vector leftMultiply(Vector vector) {
        int n4;
        int n5;
        int n6;
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.length];
        int n7 = this.numRows >> 5;
        int n8 = 1 << (this.numRows & 0x1F);
        int n9 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = 1;
            do {
                if ((n4 = nArray[n6] & n5) != 0) {
                    for (int i4 = 0; i4 < this.length; ++i4) {
                        int n10 = i4;
                        nArray2[n10] = nArray2[n10] ^ this.matrix[n9][i4];
                    }
                }
                ++n9;
            } while ((n5 <<= 1) != 0);
        }
        for (n6 = 1; n6 != n8; n6 <<= 1) {
            n5 = nArray[n7] & n6;
            if (n5 != 0) {
                for (n4 = 0; n4 < this.length; ++n4) {
                    int n11 = n4;
                    nArray2[n11] = nArray2[n11] ^ this.matrix[n9][n4];
                }
            }
            ++n9;
        }
        return new GF2Vector(nArray2, this.numColumns);
    }

    public Vector leftMultiplyLeftCompactForm(Vector vector) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + this.numColumns + 31 >>> 5];
        int n9 = this.numRows >>> 5;
        int n10 = 0;
        for (n8 = 0; n8 < n9; ++n8) {
            n7 = 1;
            do {
                if ((n6 = nArray[n8] & n7) != 0) {
                    for (n5 = 0; n5 < this.length; ++n5) {
                        int n11 = n5;
                        nArray2[n11] = nArray2[n11] ^ this.matrix[n10][n5];
                    }
                    n5 = this.numColumns + n10 >>> 5;
                    n4 = this.numColumns + n10 & 0x1F;
                    int n12 = n5;
                    nArray2[n12] = nArray2[n12] | 1 << n4;
                }
                ++n10;
            } while ((n7 <<= 1) != 0);
        }
        n8 = 1 << (this.numRows & 0x1F);
        for (n7 = 1; n7 != n8; n7 <<= 1) {
            n6 = nArray[n9] & n7;
            if (n6 != 0) {
                for (n5 = 0; n5 < this.length; ++n5) {
                    int n13 = n5;
                    nArray2[n13] = nArray2[n13] ^ this.matrix[n10][n5];
                }
                n5 = this.numColumns + n10 >>> 5;
                n4 = this.numColumns + n10 & 0x1F;
                int n14 = n5;
                nArray2[n14] = nArray2[n14] | 1 << n4;
            }
            ++n10;
        }
        return new GF2Vector(nArray2, this.numRows + this.numColumns);
    }

    public Matrix rightMultiply(Matrix matrix) {
        if (!(matrix instanceof GF2Matrix)) {
            throw new ArithmeticException("matrix is not defined over GF(2)");
        }
        if (matrix.numRows != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix gF2Matrix = (GF2Matrix)matrix;
        GF2Matrix gF2Matrix2 = new GF2Matrix(this.numRows, matrix.numColumns);
        int n4 = this.numColumns & 0x1F;
        int n5 = n4 == 0 ? this.length : this.length - 1;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            for (n9 = 0; n9 < n5; ++n9) {
                n8 = this.matrix[i4][n9];
                for (n7 = 0; n7 < 32; ++n7) {
                    n6 = n8 & 1 << n7;
                    if (n6 != 0) {
                        for (int i5 = 0; i5 < gF2Matrix.length; ++i5) {
                            int[] nArray = gF2Matrix2.matrix[i4];
                            int n11 = i5;
                            nArray[n11] = nArray[n11] ^ gF2Matrix.matrix[n10][i5];
                        }
                    }
                    ++n10;
                }
            }
            n9 = this.matrix[i4][this.length - 1];
            for (n8 = 0; n8 < n4; ++n8) {
                n7 = n9 & 1 << n8;
                if (n7 != 0) {
                    for (n6 = 0; n6 < gF2Matrix.length; ++n6) {
                        int[] nArray = gF2Matrix2.matrix[i4];
                        int n12 = n6;
                        nArray[n12] = nArray[n12] ^ gF2Matrix.matrix[n10][n6];
                    }
                }
                ++n10;
            }
        }
        return gF2Matrix2;
    }

    public Matrix rightMultiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (nArray.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix gF2Matrix = new GF2Matrix(this.numRows, this.numColumns);
        for (int i4 = this.numColumns - 1; i4 >= 0; --i4) {
            int n4 = i4 >>> 5;
            int n5 = i4 & 0x1F;
            int n6 = nArray[i4] >>> 5;
            int n7 = nArray[i4] & 0x1F;
            for (int i5 = this.numRows - 1; i5 >= 0; --i5) {
                int[] nArray2 = gF2Matrix.matrix[i5];
                int n8 = n4;
                nArray2[n8] = nArray2[n8] | (this.matrix[i5][n6] >>> n7 & 1) << n5;
            }
        }
        return gF2Matrix;
    }

    public Vector rightMultiply(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + 31 >>> 5];
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < this.length; ++n4) {
                n5 ^= this.matrix[i4][n4] & nArray[n4];
            }
            n4 = 0;
            for (int i5 = 0; i5 < 32; ++i5) {
                n4 ^= n5 >>> i5 & 1;
            }
            if (n4 != 1) continue;
            int n6 = i4 >>> 5;
            nArray2[n6] = nArray2[n6] | 1 << (i4 & 0x1F);
        }
        return new GF2Vector(nArray2, this.numRows);
    }

    public Vector rightMultiplyRightCompactForm(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vector.length != this.numColumns + this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = ((GF2Vector)vector).getVecArray();
        int[] nArray2 = new int[this.numRows + 31 >>> 5];
        int n4 = this.numRows >> 5;
        int n5 = this.numRows & 0x1F;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n6;
            int n7;
            int n8 = nArray[i4 >> 5] >>> (i4 & 0x1F) & 1;
            int n9 = n4;
            if (n5 != 0) {
                n7 = 0;
                for (n6 = 0; n6 < this.length - 1; ++n6) {
                    n7 = nArray[n9++] >>> n5 | nArray[n9] << 32 - n5;
                    n8 ^= this.matrix[i4][n6] & n7;
                }
                n7 = nArray[n9++] >>> n5;
                if (n9 < nArray.length) {
                    n7 |= nArray[n9] << 32 - n5;
                }
                n8 ^= this.matrix[i4][this.length - 1] & n7;
            } else {
                for (n7 = 0; n7 < this.length; ++n7) {
                    n8 ^= this.matrix[i4][n7] & nArray[n9++];
                }
            }
            n7 = 0;
            for (n6 = 0; n6 < 32; ++n6) {
                n7 ^= n8 & 1;
                n8 >>>= 1;
            }
            if (n7 != 1) continue;
            int n10 = i4 >> 5;
            nArray2[n10] = nArray2[n10] | 1 << (i4 & 0x1F);
        }
        return new GF2Vector(nArray2, this.numRows);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix gF2Matrix = (GF2Matrix)object;
        if (this.numRows != gF2Matrix.numRows || this.numColumns != gF2Matrix.numColumns || this.length != gF2Matrix.length) {
            return false;
        }
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            if (IntUtils.equals(this.matrix[i4], gF2Matrix.matrix[i4])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n4 = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            n4 = n4 * 31 + this.matrix[i4].hashCode();
        }
        return n4;
    }

    public String toString() {
        int n4 = this.numColumns & 0x1F;
        int n5 = n4 == 0 ? this.length : this.length - 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            int n6;
            int n7;
            int n8;
            stringBuffer.append(i4 + ": ");
            for (n8 = 0; n8 < n5; ++n8) {
                n7 = this.matrix[i4][n8];
                for (n6 = 0; n6 < 32; ++n6) {
                    int n9 = n7 >>> n6 & 1;
                    if (n9 == 0) {
                        stringBuffer.append('0');
                        continue;
                    }
                    stringBuffer.append('1');
                }
                stringBuffer.append(' ');
            }
            n8 = this.matrix[i4][this.length - 1];
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n8 >>> n7 & 1;
                if (n6 == 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append('1');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static void swapRows(int[][] nArray, int n4, int n5) {
        int[] nArray2 = nArray[n4];
        nArray[n4] = nArray[n5];
        nArray[n5] = nArray2;
    }

    private static void addToRow(int[] nArray, int[] nArray2, int n4) {
        for (int i4 = nArray2.length - 1; i4 >= n4; --i4) {
            nArray2[i4] = nArray[i4] ^ nArray2[i4];
        }
    }
}

