/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import java.util.Random;
import java.util.Vector;
import org.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nField;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import org.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public class GF2nONBField
extends GF2nField {
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private int mType;
    int[][] mMult;

    public GF2nONBField(int n4, SecureRandom secureRandom) throws RuntimeException {
        super(secureRandom);
        if (n4 < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = n4;
        this.mLength = this.mDegree / 64;
        this.mBit = this.mDegree & 0x3F;
        if (this.mBit == 0) {
            this.mBit = 64;
        } else {
            ++this.mLength;
        }
        this.computeType();
        if (this.mType < 3) {
            this.mMult = new int[this.mDegree][2];
            for (int i4 = 0; i4 < this.mDegree; ++i4) {
                this.mMult[i4][0] = -1;
                this.mMult[i4][1] = -1;
            }
        } else {
            throw new RuntimeException("\nThe type of this field is " + this.mType);
        }
        this.computeMultMatrix();
        this.computeFieldPolynomial();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    int getONBLength() {
        return this.mLength;
    }

    int getONBBit() {
        return this.mBit;
    }

    protected GF2nElement getRandomRoot(GF2Polynomial gF2Polynomial) {
        GF2nPolynomial gF2nPolynomial = new GF2nPolynomial(gF2Polynomial, this);
        int n4 = gF2nPolynomial.getDegree();
        while (n4 > 1) {
            GF2nPolynomial gF2nPolynomial2;
            int n5;
            do {
                GF2nONBElement gF2nONBElement = new GF2nONBElement(this, this.random);
                GF2nPolynomial gF2nPolynomial3 = new GF2nPolynomial(2, GF2nONBElement.ZERO(this));
                gF2nPolynomial3.set(1, gF2nONBElement);
                GF2nPolynomial gF2nPolynomial4 = new GF2nPolynomial(gF2nPolynomial3);
                for (int i4 = 1; i4 <= this.mDegree - 1; ++i4) {
                    gF2nPolynomial4 = gF2nPolynomial4.multiplyAndReduce(gF2nPolynomial4, gF2nPolynomial);
                    gF2nPolynomial4 = gF2nPolynomial4.add(gF2nPolynomial3);
                }
                gF2nPolynomial2 = gF2nPolynomial4.gcd(gF2nPolynomial);
                n5 = gF2nPolynomial2.getDegree();
                n4 = gF2nPolynomial.getDegree();
            } while (n5 == 0 || n5 == n4);
            gF2nPolynomial = n5 << 1 > n4 ? gF2nPolynomial.quotient(gF2nPolynomial2) : new GF2nPolynomial(gF2nPolynomial2);
            n4 = gF2nPolynomial.getDegree();
        }
        return gF2nPolynomial.at(0);
    }

    protected void computeCOBMatrix(GF2nField gF2nField) {
        GF2nElement gF2nElement;
        int n4;
        if (this.mDegree != gF2nField.mDegree) {
            throw new IllegalArgumentException("GF2nField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[this.mDegree];
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            gF2PolynomialArray[n4] = new GF2Polynomial(this.mDegree);
        }
        while ((gF2nElement = gF2nField.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        GF2nPolynomialElement[] gF2nPolynomialElementArray = new GF2nPolynomialElement[this.mDegree];
        gF2nPolynomialElementArray[0] = (GF2nElement)gF2nElement.clone();
        for (n4 = 1; n4 < this.mDegree; ++n4) {
            gF2nPolynomialElementArray[n4] = ((GF2nElement)gF2nPolynomialElementArray[n4 - 1]).square();
        }
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            for (int i4 = 0; i4 < this.mDegree; ++i4) {
                if (!((GF2nElement)gF2nPolynomialElementArray[n4]).testBit(i4)) continue;
                gF2PolynomialArray[this.mDegree - i4 - 1].setBit(this.mDegree - n4 - 1);
            }
        }
        this.fields.addElement(gF2nField);
        this.matrices.addElement(gF2PolynomialArray);
        gF2nField.fields.addElement(this);
        gF2nField.matrices.addElement(this.invertMatrix(gF2PolynomialArray));
    }

    protected void computeFieldPolynomial() {
        if (this.mType == 1) {
            this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1, "ALL");
        } else if (this.mType == 2) {
            GF2Polynomial gF2Polynomial = new GF2Polynomial(this.mDegree + 1, "ONE");
            GF2Polynomial gF2Polynomial2 = new GF2Polynomial(this.mDegree + 1, "X");
            gF2Polynomial2.addToThis(gF2Polynomial);
            for (int i4 = 1; i4 < this.mDegree; ++i4) {
                GF2Polynomial gF2Polynomial3 = gF2Polynomial;
                gF2Polynomial = gF2Polynomial2;
                gF2Polynomial2 = gF2Polynomial.shiftLeft();
                gF2Polynomial2.addToThis(gF2Polynomial3);
            }
            this.fieldPolynomial = gF2Polynomial2;
        }
    }

    int[][] invMatrix(int[][] nArray) {
        int n4;
        int[][] nArray2 = new int[this.mDegree][this.mDegree];
        nArray2 = nArray;
        int[][] nArray3 = new int[this.mDegree][this.mDegree];
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            nArray3[n4][n4] = 1;
        }
        for (n4 = 0; n4 < this.mDegree; ++n4) {
            for (int i4 = n4; i4 < this.mDegree; ++i4) {
                nArray2[this.mDegree - 1 - n4][i4] = nArray2[n4][n4];
            }
        }
        return null;
    }

    private void computeType() throws RuntimeException {
        if ((this.mDegree & 7) == 0) {
            throw new RuntimeException("The extension degree is divisible by 8!");
        }
        int n4 = 0;
        int n5 = 0;
        this.mType = 1;
        int n6 = 0;
        while (n6 != 1) {
            n4 = this.mType * this.mDegree + 1;
            if (IntegerFunctions.isPrime(n4)) {
                n5 = IntegerFunctions.order(2, n4);
                n6 = IntegerFunctions.gcd(this.mType * this.mDegree / n5, this.mDegree);
            }
            ++this.mType;
        }
        --this.mType;
        if (this.mType == 1 && IntegerFunctions.isPrime(n4 = (this.mDegree << 1) + 1) && (n6 = IntegerFunctions.gcd((this.mDegree << 1) / (n5 = IntegerFunctions.order(2, n4)), this.mDegree)) == 1) {
            ++this.mType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeMultMatrix() {
        int n4;
        int n5;
        if ((this.mType & 7) == 0) throw new RuntimeException("bisher nur fuer Gausssche Normalbasen implementiert");
        int n6 = this.mType * this.mDegree + 1;
        int[] nArray = new int[n6];
        int n7 = this.mType == 1 ? 1 : (this.mType == 2 ? n6 - 1 : this.elementOfOrder(this.mType, n6));
        int n8 = 1;
        for (n5 = 0; n5 < this.mType; ++n5) {
            int n9 = n8;
            for (n4 = 0; n4 < this.mDegree; ++n4) {
                nArray[n9] = n4;
                if ((n9 = (n9 << 1) % n6) >= 0) continue;
                n9 += n6;
            }
            if ((n8 = n7 * n8 % n6) >= 0) continue;
            n8 += n6;
        }
        if (this.mType == 1) {
            for (n5 = 1; n5 < n6 - 1; ++n5) {
                if (this.mMult[nArray[n5 + 1]][0] == -1) {
                    this.mMult[nArray[n5 + 1]][0] = nArray[n6 - n5];
                    continue;
                }
                this.mMult[nArray[n5 + 1]][1] = nArray[n6 - n5];
            }
            n5 = this.mDegree >> 1;
            for (n4 = 1; n4 <= n5; ++n4) {
                if (this.mMult[n4 - 1][0] == -1) {
                    this.mMult[n4 - 1][0] = n5 + n4 - 1;
                } else {
                    this.mMult[n4 - 1][1] = n5 + n4 - 1;
                }
                if (this.mMult[n5 + n4 - 1][0] == -1) {
                    this.mMult[n5 + n4 - 1][0] = n4 - 1;
                    continue;
                }
                this.mMult[n5 + n4 - 1][1] = n4 - 1;
            }
            return;
        } else {
            if (this.mType != 2) throw new RuntimeException("only type 1 or type 2 implemented");
            for (n5 = 1; n5 < n6 - 1; ++n5) {
                if (this.mMult[nArray[n5 + 1]][0] == -1) {
                    this.mMult[nArray[n5 + 1]][0] = nArray[n6 - n5];
                    continue;
                }
                this.mMult[nArray[n5 + 1]][1] = nArray[n6 - n5];
            }
        }
    }

    private int elementOfOrder(int n4, int n5) {
        Random random = new Random();
        int n6 = 0;
        while (n6 == 0) {
            n6 = random.nextInt();
            if ((n6 %= n5 - 1) >= 0) continue;
            n6 += n5 - 1;
        }
        int n7 = IntegerFunctions.order(n6, n5);
        while (n7 % n4 != 0 || n7 == 0) {
            while (n6 == 0) {
                n6 = random.nextInt();
                if ((n6 %= n5 - 1) >= 0) continue;
                n6 += n5 - 1;
            }
            n7 = IntegerFunctions.order(n6, n5);
        }
        int n8 = n6;
        n7 = n4 / n7;
        for (int i4 = 2; i4 <= n7; ++i4) {
            n8 *= n6;
        }
        return n8;
    }
}

