/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = gF2mField;
        this.p = polynomialGF2mSmallM;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    private void computeSquaringMatrix() {
        int[] nArray;
        int n4;
        int n5 = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[n5];
        for (n4 = 0; n4 < n5 >> 1; ++n4) {
            nArray = new int[(n4 << 1) + 1];
            nArray[n4 << 1] = 1;
            this.sqMatrix[n4] = new PolynomialGF2mSmallM(this.field, nArray);
        }
        for (n4 = n5 >> 1; n4 < n5; ++n4) {
            nArray = new int[(n4 << 1) + 1];
            nArray[n4 << 1] = 1;
            PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, nArray);
            this.sqMatrix[n4] = polynomialGF2mSmallM.mod(this.p);
        }
    }

    private void computeSquareRootMatrix() {
        int n4;
        int n5 = this.p.getDegree();
        PolynomialGF2mSmallM[] polynomialGF2mSmallMArray = new PolynomialGF2mSmallM[n5];
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            polynomialGF2mSmallMArray[n4] = new PolynomialGF2mSmallM(this.sqMatrix[n4]);
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[n5];
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            this.sqRootMatrix[n4] = new PolynomialGF2mSmallM(this.field, n4);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n6;
            int n7;
            if (polynomialGF2mSmallMArray[n4].getCoefficient(n4) == 0) {
                n7 = 0;
                for (n6 = n4 + 1; n6 < n5; ++n6) {
                    if (polynomialGF2mSmallMArray[n6].getCoefficient(n4) == 0) continue;
                    n7 = 1;
                    PolynomialRingGF2m.swapColumns(polynomialGF2mSmallMArray, n4, n6);
                    PolynomialRingGF2m.swapColumns(this.sqRootMatrix, n4, n6);
                    n6 = n5;
                }
                if (n7 == 0) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            n7 = polynomialGF2mSmallMArray[n4].getCoefficient(n4);
            n6 = this.field.inverse(n7);
            polynomialGF2mSmallMArray[n4].multThisWithElement(n6);
            this.sqRootMatrix[n4].multThisWithElement(n6);
            for (int i4 = 0; i4 < n5; ++i4) {
                if (i4 == n4 || (n7 = polynomialGF2mSmallMArray[i4].getCoefficient(n4)) == 0) continue;
                PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n4].multWithElement(n7);
                PolynomialGF2mSmallM polynomialGF2mSmallM2 = this.sqRootMatrix[n4].multWithElement(n7);
                polynomialGF2mSmallMArray[i4].addToThis(polynomialGF2mSmallM);
                this.sqRootMatrix[i4].addToThis(polynomialGF2mSmallM2);
            }
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] polynomialGF2mSmallMArray, int n4, int n5) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = polynomialGF2mSmallMArray[n4];
        polynomialGF2mSmallMArray[n4] = polynomialGF2mSmallMArray[n5];
        polynomialGF2mSmallMArray[n5] = polynomialGF2mSmallM;
    }
}

