<?php 
function analysis_db( $sql ) {
	$db = new PDO("pgsql:dbname=analysis;host=10.8.16.2", "spiritking", "2DH93@d{COw8Sr_C" );
	$rs = $db->query($sql);
	return $rs->fetchall(PDO::FETCH_ASSOC);
}

/**
create table player_dyeing_item_comp (set_id integer, player_id integer, item_id integer, unlockvalue integer, color_id text, color_name text, color_expo text, color_coin text, color_coins integer default 0);
create index dyeing_set_id on player_dyeing_item_comp using btree (set_id);
create index dyeing_pid on player_dyeing_item_comp using btree (player_id); 
create index dyeing_item_id on player_dyeing_item_comp using btree (item_id);

                             Table "public.player_dyeing_item_comp"
   Column    |  Type   | Collation | Nullable | Default | Storage  | Stats target | Description
-------------+---------+-----------+----------+---------+----------+--------------+-------------
 set_id      | integer |           |          |         | plain    |              |
 player_id   | integer |           |          |         | plain    |              |
 item_id     | integer |           |          |         | plain    |              |
 unlockvalue | integer |           |          |         | plain    |              |
 color_id    | text    |           |          |         | extended |              |
 color_name  | text    |           |          |         | extended |              |
 color_expo  | text    |           |          |         | extended |              |
 color_coin  | text    |           |          |         | extended |              |
 color_coins | integer |           |          | 0       | plain    |              |
Indexes:
    "dyeing_item_id" btree (item_id)
    "dyeing_pid" btree (player_id)
    "dyeing_set_id" btree (set_id)

s1_player_dyeing_item_51034_51035_51036.csv
s2_player_dyeing_item_51034_51035_51036.csv
s3_player_dyeing_item_51034_51035_51036.csv
s5_player_dyeing_item_51034_51035_51036.csv
s20_player_dyeing_item_51034_51035_51036.csv
**/

function highestPowerof2($n) { 
    $p = (int)log($n, 2); 
    return (int)pow(2, $p);  
} 
  
function recursive($set_id,$player_id,$item_id,$num) {
	$color_name_arr = array(49001=>'卡其',49002=>'咖啡',49003=>'酒紅',49004=>'紅',49005=>'桃紅',49006=>'櫻粉',49007=>'粉紅',49008=>'珊瑚粉',49009=>'深綠',49010=>'淡綠',49011=>'蘋果綠',49012=>'淡黃',49013=>'黃',49014=>'橘黃',49015=>'橘',49016=>'天空藍',49017=>'藍',49018=>'寶藍',49019=>'深藍',49020=>'深紫',49021=>'淡紫',49022=>'紫',49023=>'黑',49024=>'白',49025=>'灰');
	
	$color_coin_arr = array(49001=>100,49002=>100,49003=>200,49004=>400,49005=>100,49006=>100,49007=>200,49008=>200,49009=>100,49010=>100,49011=>200,49012=>200,49013=>400,49014=>100,49015=>100,49016=>100,49017=>200,49018=>400,49019=>200,49020=>200,49021=>100,49022=>200,49023=>400,49024=>400,49025=>200);
	
	$color_expo_arr = array(49001=>1,49002=>2,49003=>4,49004=>8,49005=>16,49006=>32,49007=>64,49008=>128,49009=>256,49010=>512,49011=>1024,49012=>2048,49013=>4096,49014=>8192,49015=>16384,49016=>32768,49017=>65536,49018=>131072,49019=>262144,49020=>524288,49021=>1048576,49022=>2097152,49023=>4194304,49024=>8388608,49025=>16777216);
	
	if ($num > 0) {
		$max_pow = highestPowerof2($num);

		echo "$max_pow\n";
		$color = array_search($max_pow, $color_expo_arr);;
		$color_id = $color . '+';
		$color_name = $color_name_arr[$color] . '+';
		$color_coin = $color_coin_arr[$color] . '+';
		$color_coins = $color_coin_arr[$color];
		$sql_update = "UPDATE player_dyeing_item_comp SET color_id = CONCAT(color_id,'$color_id'), color_name = CONCAT(color_name,'$color_name'), color_expo = CONCAT(color_expo,'$max_pow+'), color_coin = CONCAT(color_coin,'$color_coin'), color_coins = color_coins + $color_coins WHERE set_id = $set_id AND player_id = $player_id AND item_id = $item_id";
		analysis_db($sql_update);
		$split = $num - $max_pow;

		$res = recursive($set_id,$player_id,$item_id,$split);
		return $res;
	}
}

$files = glob("s*_player_dyeing_item_51034_51035_51036_apk3", GLOB_BRACE);
foreach($files as $file) {
	$set_id = str_replace(array("s","_player_dyeing_item_51034_51035_51036_apk3"),"", $file);
	$fp = fopen($file,"r");
	while(!feof($fp)) {
		list($player_id,$item_id,$unlockvalue) = split(",",fgets($fp));
		if($player_id) {
			echo "$file,$set_id,$player_id,$item_id,$unlockvalue";
			$sql_check = "SELECT COUNT(*) FROM player_dyeing_item_comp WHERE set_id = $set_id AND player_id = $player_id AND item_id = $item_id AND unlockvalue = $unlockvalue";
			$res = analysis_db($sql_check);
			if($res['0']['count'] == 0) {
				$sql_insert = "INSERT INTO player_dyeing_item_comp (set_id, player_id, item_id, unlockvalue) VALUES ($set_id, $player_id, $item_id, $unlockvalue)";
				analysis_db($sql_insert);
			}
			recursive($set_id,$player_id,$item_id,$unlockvalue);
		
		}
	}
	fclose($fp);
}

$sql_update_final = "UPDATE player_dyeing_item_comp SET color_id = RTRIM(color_id,'+'), color_name = RTRIM(color_name,'+'), color_expo = RTRIM(color_expo,'+'), color_coin = RTRIM(color_coin,'+')";
analysis_db($sql_update_final);
?> 
