/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.util.ByteBufferSink;
import com.android.apksig.internal.util.ChainedDataSource;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class VerityTreeBuilder
implements AutoCloseable {
    private static final int CHUNK_SIZE = 4096;
    private static final int DIGEST_PARALLELISM = Math.min(32, Runtime.getRuntime().availableProcessors());
    private static final int MAX_OUTSTANDING_CHUNKS = 4;
    private static final int MAX_PREFETCH_CHUNKS = 1024;
    private static final int MIN_CHUNKS_PER_WORKER = 8;
    private static final String JCA_ALGORITHM = "SHA-256";
    private final byte[] mSalt;
    private final MessageDigest mMd;
    private final ExecutorService mExecutor = new ThreadPoolExecutor(DIGEST_PARALLELISM, DIGEST_PARALLELISM, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(4), new ThreadPoolExecutor.CallerRunsPolicy());

    public VerityTreeBuilder(byte[] salt) throws NoSuchAlgorithmException {
        this.mSalt = salt;
        this.mMd = VerityTreeBuilder.getNewMessageDigest();
    }

    @Override
    public void close() {
        this.mExecutor.shutdownNow();
    }

    public byte[] generateVerityTreeRootHash(DataSource beforeApkSigningBlock, DataSource centralDir, DataSource eocd) throws IOException {
        if (beforeApkSigningBlock.size() % 4096L != 0L) {
            throw new IllegalStateException("APK Signing Block size not a multiple of 4096: " + beforeApkSigningBlock.size());
        }
        long centralDirOffsetForDigesting = beforeApkSigningBlock.size();
        ByteBuffer eocdBuf = ByteBuffer.allocate((int)eocd.size());
        eocdBuf.order(ByteOrder.LITTLE_ENDIAN);
        eocd.copyTo(0L, (int)eocd.size(), eocdBuf);
        eocdBuf.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(eocdBuf, centralDirOffsetForDigesting);
        return this.generateVerityTreeRootHash(new ChainedDataSource(beforeApkSigningBlock, centralDir, DataSources.asDataSource(eocdBuf)));
    }

    public byte[] generateVerityTreeRootHash(DataSource fileSource) throws IOException {
        ByteBuffer verityBuffer = this.generateVerityTree(fileSource);
        return this.getRootHashFromTree(verityBuffer);
    }

    public ByteBuffer generateVerityTree(DataSource fileSource) throws IOException {
        int digestSize = this.mMd.getDigestLength();
        int[] levelOffset = VerityTreeBuilder.calculateLevelOffset(fileSource.size(), digestSize);
        ByteBuffer verityBuffer = ByteBuffer.allocate(levelOffset[levelOffset.length - 1]);
        for (int i4 = levelOffset.length - 2; i4 >= 0; --i4) {
            DataSource src;
            ByteBufferSink middleBufferSink = new ByteBufferSink(VerityTreeBuilder.slice(verityBuffer, levelOffset[i4], levelOffset[i4 + 1]));
            if (i4 == levelOffset.length - 2) {
                src = fileSource;
                this.digestDataByChunks(src, middleBufferSink);
            } else {
                src = DataSources.asDataSource(VerityTreeBuilder.slice(verityBuffer.asReadOnlyBuffer(), levelOffset[i4 + 1], levelOffset[i4 + 2]));
                this.digestDataByChunks(src, middleBufferSink);
            }
            long totalOutput = VerityTreeBuilder.divideRoundup(src.size(), 4096L) * (long)digestSize;
            int incomplete = (int)(totalOutput % 4096L);
            if (incomplete <= 0) continue;
            byte[] padding = new byte[4096 - incomplete];
            middleBufferSink.consume(padding, 0, padding.length);
        }
        return verityBuffer;
    }

    public byte[] getRootHashFromTree(ByteBuffer verityBuffer) throws IOException {
        ByteBuffer firstPage = VerityTreeBuilder.slice(verityBuffer.asReadOnlyBuffer(), 0, 4096);
        return this.saltedDigest(firstPage);
    }

    private static int[] calculateLevelOffset(long dataSize, int digestSize) {
        ArrayList<Long> levelSize = new ArrayList<Long>();
        while (true) {
            long chunkCount = VerityTreeBuilder.divideRoundup(dataSize, 4096L);
            long size = 4096L * VerityTreeBuilder.divideRoundup(chunkCount * (long)digestSize, 4096L);
            levelSize.add(size);
            if (chunkCount * (long)digestSize <= 4096L) break;
            dataSize = chunkCount * (long)digestSize;
        }
        int[] levelOffset = new int[levelSize.size() + 1];
        levelOffset[0] = 0;
        for (int i4 = 0; i4 < levelSize.size(); ++i4) {
            levelOffset[i4 + 1] = levelOffset[i4] + Math.toIntExact((Long)levelSize.get(levelSize.size() - i4 - 1));
        }
        return levelOffset;
    }

    private void digestDataByChunks(DataSource dataSource, DataSink dataSink) throws IOException {
        int readSize;
        long size = dataSource.size();
        int chunks = (int)VerityTreeBuilder.divideRoundup(size, 4096L);
        int parallelism = Math.max(Math.min(chunks / 8, DIGEST_PARALLELISM), 1);
        int ioSizeChunks = 1024;
        byte[][] hashes = new byte[chunks][];
        Phaser tasks = new Phaser(1);
        long maxReadSize = 0x400000L;
        int startChunkIndex = 0;
        for (long readOffset = 0L; readOffset < size; readOffset += (long)readSize) {
            long readLimit = Math.min(readOffset + 0x400000L, size);
            readSize = (int)(readLimit - readOffset);
            int bufferSizeChunks = (int)VerityTreeBuilder.divideRoundup(readSize, 4096L);
            ByteBuffer buffer = ByteBuffer.allocate(bufferSizeChunks * 4096);
            dataSource.copyTo(readOffset, readSize, buffer);
            buffer.rewind();
            int readChunkIndex = startChunkIndex;
            Runnable task = () -> {
                MessageDigest md = this.cloneMessageDigest();
                int offset = 0;
                int finish = buffer.capacity();
                int chunkIndex = readChunkIndex;
                while (offset < finish) {
                    ByteBuffer chunk = VerityTreeBuilder.slice(buffer, offset, offset + 4096);
                    hashes[chunkIndex] = this.saltedDigest(md, chunk);
                    offset += 4096;
                    ++chunkIndex;
                }
                tasks.arriveAndDeregister();
            };
            tasks.register();
            this.mExecutor.execute(task);
            startChunkIndex += bufferSizeChunks;
        }
        tasks.arriveAndAwaitAdvance();
        for (byte[] hash : hashes) {
            dataSink.consume(hash, 0, hash.length);
        }
    }

    private byte[] saltedDigest(ByteBuffer data) {
        return this.saltedDigest(this.mMd, data);
    }

    private byte[] saltedDigest(MessageDigest md, ByteBuffer data) {
        md.reset();
        if (this.mSalt != null) {
            md.update(this.mSalt);
        }
        md.update(data);
        return md.digest();
    }

    private static long divideRoundup(long dividend, long divisor) {
        return (dividend + divisor - 1L) / divisor;
    }

    private static ByteBuffer slice(ByteBuffer buffer, int begin, int end) {
        ByteBuffer b5 = buffer.duplicate();
        b5.position(0);
        b5.limit(end);
        b5.position(begin);
        return b5.slice();
    }

    private static MessageDigest getNewMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(JCA_ALGORITHM);
    }

    private MessageDigest cloneMessageDigest() {
        try {
            return (MessageDigest)this.mMd.clone();
        }
        catch (CloneNotSupportedException ignored) {
            try {
                return VerityTreeBuilder.getNewMessageDigest();
            }
            catch (NoSuchAlgorithmException e5) {
                throw new IllegalStateException("Failed to obtain an instance of a previously available message digest", e5);
            }
        }
    }
}

