/*
 * Decompiled with CFR 0.152.
 */
package com.android.support;

import com.android.support.InvalidDataException;
import com.android.support.MigrationParserVisitor;
import com.android.utils.XmlUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"ATTR_ARTIFACT_NAME", "", "ATTR_GROUP_NAME", "ATTR_NEW_ARTIFACT_NAME", "ATTR_NEW_BASE_VERSION_NAME", "ATTR_NEW_GROUP_NAME", "ATTR_NEW_NAME", "ATTR_OLD_ARTIFACT_NAME", "ATTR_OLD_GROUP_NAME", "ATTR_OLD_NAME", "ATTR_TYPE", "MIGRATE_DEPENDENCY_NAME", "MIGRATE_ENTRY_NAME", "ROOT_ELEMENT", "TYPE_CLASS", "TYPE_PACKAGE", "UPGRADE_DEPENDENCY_NAME", "parseMigrationFile", "", "visitor", "Lcom/android/support/MigrationParserVisitor;", "common"})
public final class AndroidxMigrationParserKt {
    @NotNull
    private static final String ROOT_ELEMENT = "migration-map";
    @NotNull
    private static final String MIGRATE_ENTRY_NAME = "migrate";
    @NotNull
    private static final String ATTR_OLD_NAME = "old-name";
    @NotNull
    private static final String ATTR_NEW_NAME = "new-name";
    @NotNull
    private static final String ATTR_TYPE = "type";
    @NotNull
    private static final String TYPE_CLASS = "CLASS";
    @NotNull
    private static final String TYPE_PACKAGE = "PACKAGE";
    @NotNull
    private static final String MIGRATE_DEPENDENCY_NAME = "migrate-dependency";
    @NotNull
    private static final String ATTR_OLD_GROUP_NAME = "old-group-name";
    @NotNull
    private static final String ATTR_OLD_ARTIFACT_NAME = "old-artifact-name";
    @NotNull
    private static final String ATTR_NEW_GROUP_NAME = "new-group-name";
    @NotNull
    private static final String ATTR_NEW_ARTIFACT_NAME = "new-artifact-name";
    @NotNull
    private static final String ATTR_NEW_BASE_VERSION_NAME = "base-version";
    @NotNull
    private static final String UPGRADE_DEPENDENCY_NAME = "upgrade-dependency";
    @NotNull
    private static final String ATTR_GROUP_NAME = "group-name";
    @NotNull
    private static final String ATTR_ARTIFACT_NAME = "artifact-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void parseMigrationFile(@NotNull MigrationParserVisitor visitor) {
        Intrinsics.checkParameterIsNotNull(visitor, "visitor");
        Closeable closeable = MigrationParserVisitor.class.getResourceAsStream("migrateToAndroidx/migration.xml");
        if (closeable == null) {
            Intrinsics.throwNpe();
        }
        InputStream stream = closeable;
        closeable = stream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl3 = false;
            Document document = XmlUtils.parseDocument(new InputStreamReader(stream), false);
            Intrinsics.checkExpressionValueIsNotNull(document, "parseDocument(InputStreamReader(stream), false)");
            Document document2 = document;
            Element root = document2.getDocumentElement();
            if (!Intrinsics.areEqual(ROOT_ELEMENT, root.getNodeName())) {
                throw new InvalidDataException("Migration file does not start with <migration-map>");
            }
            Iterable<Element> iterable = XmlUtils.getSubTags(root);
            Intrinsics.checkExpressionValueIsNotNull(iterable, "getSubTags(root)");
            Iterable<Element> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Element> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Element element$iv;
                Element node = element$iv = iterator2.next();
                boolean bl4 = false;
                if (Intrinsics.areEqual(node.getNodeName(), MIGRATE_ENTRY_NAME)) {
                    String oldName = node.getAttribute(ATTR_OLD_NAME);
                    String newName = node.getAttribute(ATTR_NEW_NAME);
                    String type = node.getAttribute(ATTR_TYPE);
                    String string = type;
                    if (Intrinsics.areEqual(string, TYPE_PACKAGE)) {
                        Intrinsics.checkExpressionValueIsNotNull(oldName, "oldName");
                        Intrinsics.checkExpressionValueIsNotNull(newName, "newName");
                        visitor.visitPackage(oldName, newName);
                        continue;
                    }
                    if (Intrinsics.areEqual(string, TYPE_CLASS)) {
                        Intrinsics.checkExpressionValueIsNotNull(oldName, "oldName");
                        Intrinsics.checkExpressionValueIsNotNull(newName, "newName");
                        visitor.visitClass(oldName, newName);
                        continue;
                    }
                    throw new InvalidDataException(Intrinsics.stringPlus("Invalid type ", type));
                }
                if (Intrinsics.areEqual(node.getNodeName(), MIGRATE_DEPENDENCY_NAME)) {
                    String oldGroupName = node.getAttribute(ATTR_OLD_GROUP_NAME);
                    String oldArtifactName = node.getAttribute(ATTR_OLD_ARTIFACT_NAME);
                    String newGroupName = node.getAttribute(ATTR_NEW_GROUP_NAME);
                    String newArtifactName = node.getAttribute(ATTR_NEW_ARTIFACT_NAME);
                    String newBaseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                    Intrinsics.checkExpressionValueIsNotNull(oldGroupName, "oldGroupName");
                    Intrinsics.checkExpressionValueIsNotNull(oldArtifactName, "oldArtifactName");
                    Intrinsics.checkExpressionValueIsNotNull(newGroupName, "newGroupName");
                    Intrinsics.checkExpressionValueIsNotNull(newArtifactName, "newArtifactName");
                    Intrinsics.checkExpressionValueIsNotNull(newBaseVersion, "newBaseVersion");
                    visitor.visitGradleCoordinate(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion);
                    continue;
                }
                if (!Intrinsics.areEqual(node.getNodeName(), UPGRADE_DEPENDENCY_NAME)) continue;
                String groupName = node.getAttribute(ATTR_GROUP_NAME);
                String artifactName = node.getAttribute(ATTR_ARTIFACT_NAME);
                String baseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                Intrinsics.checkExpressionValueIsNotNull(groupName, "groupName");
                Intrinsics.checkExpressionValueIsNotNull(artifactName, "artifactName");
                Intrinsics.checkExpressionValueIsNotNull(baseVersion, "baseVersion");
                visitor.visitGradleCoordinateUpgrade(groupName, artifactName, baseVersion);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

