/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.apkzlib.zfile.ZFiles;
import com.android.tools.build.apkzlib.zip.AlignmentRule;
import com.android.tools.build.apkzlib.zip.AlignmentRules;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.inject.Inject;

final class ApkzlibApkSerializerHelper
extends ApkSerializerHelper {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    static final AlignmentRule APK_ALIGNMENT_RULE = AlignmentRules.compose(AlignmentRules.constantForSuffix(".so", 4096), AlignmentRules.constant(4));
    private final Aapt2Command aapt2Command;
    private final Version bundletoolVersion;
    private final ImmutableList<PathMatcher> uncompressedPathMatchers;
    private final ApkSigner apkSigner;
    private final boolean enableSparseEncoding;

    @Inject
    ApkzlibApkSerializerHelper(Aapt2Command aapt2Command, Version bundletoolVersion, Config.BundleConfig bundleConfig, ApkSigner apkSigner) {
        this.aapt2Command = aapt2Command;
        this.bundletoolVersion = bundletoolVersion;
        this.uncompressedPathMatchers = bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
        this.apkSigner = apkSigner;
        this.enableSparseEncoding = bundleConfig.getOptimizations().getResourceOptimizations().getSparseEncoding().equals(Config.ResourceOptimizations.SparseEncoding.ENFORCED);
    }

    @Override
    public Path writeToZipFile(ModuleSplit split, Path outputPath) {
        try (TempDirectory tempDirectory = new TempDirectory();){
            this.writeToZipFile(split, outputPath, tempDirectory);
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
        return outputPath;
    }

    private void writeToZipFile(ModuleSplit split, Path outputPath, TempDirectory tempDir) throws IOException {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        FileUtils.createParentDirectories(outputPath);
        split = this.apkSigner.signEmbeddedApks(split);
        Path partialProtoApk = tempDir.getPath().resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk);
        Path binaryApk = tempDir.getPath().resolve("binary.apk");
        if (this.enableSparseEncoding && split.getResourceTable().isPresent()) {
            Path interimApk = tempDir.getPath().resolve("interim.apk");
            this.aapt2Command.convertApkProtoToBinary(partialProtoApk, interimApk);
            this.aapt2Command.optimizeToSparseResourceTables(interimApk, binaryApk);
        } else {
            this.aapt2Command.convertApkProtoToBinary(partialProtoApk, binaryApk);
        }
        Preconditions.checkState(Files.exists(binaryApk, new LinkOption[0]), "No APK created by aapt2 convert command.");
        try (ZFile zOutputApk = ZFiles.apk(outputPath.toFile(), ApkzlibApkSerializerHelper.createZFileOptions(tempDir.getPath()).setAlignmentRule(APK_ALIGNMENT_RULE).setCoverEmptySpaceUsingExtraField(true).setNoTimestamps(true), Optional.absent(), null, null, false);
             ZFile zAapt2Files = ZFile.openReadOnly(binaryApk.toFile(), ApkzlibApkSerializerHelper.createZFileOptions(tempDir.getPath()));){
            zOutputApk.mergeFrom(zAapt2Files, Predicates.alwaysFalse());
            this.addNonAapt2Files(zOutputApk, split);
            zOutputApk.sortZipContents();
        }
        this.apkSigner.signApk(outputPath, split);
    }

    private Path writeProtoApk(ModuleSplit split, Path outputPath) throws IOException {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkzlibApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (!ApkzlibApkSerializerHelper.requiresAapt2Conversion(pathInApk)) continue;
            ZipBuilder.EntryOption[] entryOptions = this.entryOptionForPath(pathInApk, !extractNativeLibs, entry.getForceUncompressed());
            zipBuilder.addFile(pathInApk, entry.getContent(), entryOptions);
        }
        split.getResourceTable().ifPresent(resourceTable -> zipBuilder.addFileWithProtoContent(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath(), (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        zipBuilder.addFileWithProtoContent(ZipPath.create("AndroidManifest.xml"), split.getAndroidManifest().getManifestRoot().getProto(), new ZipBuilder.EntryOption[0]);
        zipBuilder.writeTo(outputPath);
        return outputPath;
    }

    private ZipBuilder.EntryOption[] entryOptionForPath(ZipPath path, boolean uncompressNativeLibs, boolean forceUncompressed) {
        if (this.mayCompress(path, uncompressNativeLibs, forceUncompressed)) {
            return new ZipBuilder.EntryOption[0];
        }
        return new ZipBuilder.EntryOption[]{ZipBuilder.EntryOption.UNCOMPRESSED};
    }

    private boolean mayCompress(ZipPath path, boolean uncompressNativeLibs, boolean forceUncompressed) {
        if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path.toString()))) {
            return false;
        }
        if (forceUncompressed) {
            return false;
        }
        if (!VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(this.bundletoolVersion) && NO_COMPRESSION_EXTENSIONS.contains(FileUtils.getFileExtension(path))) {
            return false;
        }
        return !uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(path.toString()).matches();
    }

    private void addNonAapt2Files(ZFile zFile, ModuleSplit split) throws IOException {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkzlibApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (ApkzlibApkSerializerHelper.requiresAapt2Conversion(pathInApk)) continue;
            boolean mayCompress = this.mayCompress(pathInApk, !extractNativeLibs, entry.getForceUncompressed());
            this.addFile(zFile, pathInApk, entry, mayCompress);
        }
    }

    void addFile(ZFile zFile, ZipPath pathInApk, ModuleEntry entry, boolean mayCompress) throws IOException {
        try (InputStream entryInputStream = entry.getContent().openStream();){
            zFile.add(pathInApk.toString(), entryInputStream, mayCompress);
        }
    }

    private static ZFileOptions createZFileOptions(Path tempDir) {
        ZFileOptions options = new ZFileOptions();
        return options;
    }
}

