/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.tools.build.bundletool.commands.CheckTransparencyCommand;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.transparency.ApkTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ApkModeTransparencyChecker {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransparencyCheckResult checkTransparency(CheckTransparencyCommand command) {
        try (TempDirectory tempDir = new TempDirectory("apk-transparency-checker");){
            TransparencyCheckResult transparencyCheckResult = ApkTransparencyCheckUtils.checkTransparency(ApkModeTransparencyChecker.extractAllApksFromZip(command.getApkZipPath().get(), tempDir));
            return transparencyCheckResult;
        }
        catch (IOException e5) {
            throw new UncheckedIOException("An error occurred when processing the file.", e5);
        }
    }

    private static ImmutableList<Path> extractAllApksFromZip(Path zipOfApksPath, TempDirectory tempDirectory) throws IOException {
        ImmutableList.Builder allExtractedApkPaths = ImmutableList.builder();
        Path zipExtractedSubDirectory = tempDirectory.getPath().resolve("extracted");
        Files.createDirectory(zipExtractedSubDirectory, new FileAttribute[0]);
        try (ZipFile zipOfApks = ZipUtils.openZipFile(zipOfApksPath);){
            ImmutableList listOfApksToExtract = zipOfApks.stream().filter(zipEntry -> !zipEntry.isDirectory() && zipEntry.getName().toLowerCase(Locale.ROOT).endsWith(".apk")).collect(ImmutableList.toImmutableList());
            for (ZipEntry apkToExtract : listOfApksToExtract) {
                Path extractedApkPath = zipExtractedSubDirectory.resolve(ZipPath.create(apkToExtract.getName()).toString());
                Files.createDirectories(extractedApkPath.getParent(), new FileAttribute[0]);
                InputStream inputStream = zipOfApks.getInputStream(apkToExtract);
                Throwable throwable = null;
                try {
                    OutputStream outputApk = Files.newOutputStream(extractedApkPath, new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        ByteStreams.copy(inputStream, outputApk);
                        allExtractedApkPaths.add(extractedApkPath);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputApk == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputApk.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        outputApk.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return allExtractedApkPaths.build();
    }

    private ApkModeTransparencyChecker() {
    }
}

