/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.LongAddable;
import com.google.common.cache.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@GwtCompatible(emulated=true)
final class LongAdder
extends Striped64
implements Serializable,
LongAddable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v4, long x4) {
        return v4 + x4;
    }

    @Override
    public void add(long x4) {
        long b5;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || !this.casBase(b5 = this.base, b5 + x4)) {
            long v4;
            Striped64.Cell a5;
            int n4;
            boolean uncontended = true;
            int[] hc = (int[])threadHashCode.get();
            if (hc == null || as == null || (n4 = as.length) < 1 || (a5 = as[n4 - 1 & hc[0]]) == null || !(uncontended = a5.cas(v4 = a5.value, v4 + x4))) {
                this.retryUpdate(x4, hc, uncontended);
            }
        }
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    @Override
    public long sum() {
        long sum = this.base;
        Striped64.Cell[] as = this.cells;
        if (as != null) {
            for (Striped64.Cell a5 : as) {
                if (a5 == null) continue;
                sum += a5.value;
            }
        }
        return sum;
    }

    public void reset() {
        this.internalReset(0L);
    }

    public long sumThenReset() {
        long sum = this.base;
        Striped64.Cell[] as = this.cells;
        this.base = 0L;
        if (as != null) {
            for (Striped64.Cell a5 : as) {
                if (a5 == null) continue;
                sum += a5.value;
                a5.value = 0L;
            }
        }
        return sum;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    private void writeObject(ObjectOutputStream s4) throws IOException {
        s4.defaultWriteObject();
        s4.writeLong(this.sum());
    }

    private void readObject(ObjectInputStream s4) throws IOException, ClassNotFoundException {
        s4.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = s4.readLong();
    }
}

