/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@CanIgnoreReturnValue
abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b5) {
        return this.putByte(b5 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d5) {
        return this.putLong(Double.doubleToRawLongBits(d5));
    }

    @Override
    public final Hasher putFloat(float f5) {
        return this.putInt(Float.floatToRawIntBits(f5));
    }

    @Override
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i4 = 0; i4 < len; ++i4) {
            this.putChar(charSequence.charAt(i4));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        for (int i4 = 0; i4 < len; ++i4) {
            this.putByte(bytes[off + i4]);
        }
        return this;
    }

    @Override
    public Hasher putBytes(ByteBuffer b5) {
        if (b5.hasArray()) {
            this.putBytes(b5.array(), b5.arrayOffset() + b5.position(), b5.remaining());
            Java8Compatibility.position(b5, b5.limit());
        } else {
            for (int remaining = b5.remaining(); remaining > 0; --remaining) {
                this.putByte(b5.get());
            }
        }
        return this;
    }

    @Override
    public Hasher putShort(short s4) {
        this.putByte((byte)s4);
        this.putByte((byte)(s4 >>> 8));
        return this;
    }

    @Override
    public Hasher putInt(int i4) {
        this.putByte((byte)i4);
        this.putByte((byte)(i4 >>> 8));
        this.putByte((byte)(i4 >>> 16));
        this.putByte((byte)(i4 >>> 24));
        return this;
    }

    @Override
    public Hasher putLong(long l4) {
        for (int i4 = 0; i4 < 64; i4 += 8) {
            this.putByte((byte)(l4 >>> i4));
        }
        return this;
    }

    @Override
    public Hasher putChar(char c5) {
        this.putByte((byte)c5);
        this.putByte((byte)(c5 >>> 8));
        return this;
    }

    @Override
    public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

