/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int seed) {
        this.seed = seed;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        int n4 = this.seed;
        return new StringBuilder(31).append("Hashing.murmur3_32(").append(n4).append(")").toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            Murmur3_32HashFunction other = (Murmur3_32HashFunction)object;
            return this.seed == other.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int input) {
        int k12 = Murmur3_32HashFunction.mixK1(input);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        return Murmur3_32HashFunction.fmix(h12, 4);
    }

    @Override
    public HashCode hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k12 = Murmur3_32HashFunction.mixK1(low);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        k12 = Murmur3_32HashFunction.mixK1(high);
        h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        return Murmur3_32HashFunction.fmix(h12, 8);
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        int h12 = this.seed;
        for (int i4 = 1; i4 < input.length(); i4 += 2) {
            int k12 = input.charAt(i4 - 1) | input.charAt(i4) << 16;
            k12 = Murmur3_32HashFunction.mixK1(k12);
            h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        }
        if ((input.length() & 1) == 1) {
            int k13 = input.charAt(input.length() - 1);
            k13 = Murmur3_32HashFunction.mixK1(k13);
            h12 ^= k13;
        }
        return Murmur3_32HashFunction.fmix(h12, 2 * input.length());
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        if (Charsets.UTF_8.equals(charset)) {
            int k12;
            int utf16Length = input.length();
            int h12 = this.seed;
            int i4 = 0;
            int len = 0;
            while (i4 + 4 <= utf16Length) {
                char c02 = input.charAt(i4);
                char c12 = input.charAt(i4 + 1);
                char c22 = input.charAt(i4 + 2);
                char c32 = input.charAt(i4 + 3);
                if (c02 >= '\u0080' || c12 >= '\u0080' || c22 >= '\u0080' || c32 >= '\u0080') break;
                k12 = c02 | c12 << 8 | c22 << 16 | c32 << 24;
                k12 = Murmur3_32HashFunction.mixK1(k12);
                h12 = Murmur3_32HashFunction.mixH1(h12, k12);
                i4 += 4;
                len += 4;
            }
            long buffer = 0L;
            int shift = 0;
            while (i4 < utf16Length) {
                char c5 = input.charAt(i4);
                if (c5 < '\u0080') {
                    buffer |= (long)c5 << shift;
                    shift += 8;
                    ++len;
                } else if (c5 < '\u0800') {
                    buffer |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c5) << shift;
                    shift += 16;
                    len += 2;
                } else if (c5 < '\ud800' || c5 > '\udfff') {
                    buffer |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c5) << shift;
                    shift += 24;
                    len += 3;
                } else {
                    int codePoint = Character.codePointAt(input, i4);
                    if (codePoint == c5) {
                        return this.hashBytes(input.toString().getBytes(charset));
                    }
                    ++i4;
                    buffer |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint) << shift;
                    len += 4;
                }
                if (shift >= 32) {
                    k12 = Murmur3_32HashFunction.mixK1((int)buffer);
                    h12 = Murmur3_32HashFunction.mixH1(h12, k12);
                    buffer >>>= 32;
                    shift -= 32;
                }
                ++i4;
            }
            int k13 = Murmur3_32HashFunction.mixK1((int)buffer);
            return Murmur3_32HashFunction.fmix(h12 ^= k13, len);
        }
        return this.hashBytes(input.toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        int k12;
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        int h12 = this.seed;
        int i4 = 0;
        while (i4 + 4 <= len) {
            k12 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(input, off + i4));
            h12 = Murmur3_32HashFunction.mixH1(h12, k12);
            i4 += 4;
        }
        k12 = 0;
        int shift = 0;
        while (i4 < len) {
            k12 ^= UnsignedBytes.toInt(input[off + i4]) << shift;
            ++i4;
            shift += 8;
        }
        return Murmur3_32HashFunction.fmix(h12 ^= Murmur3_32HashFunction.mixK1(k12), len);
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Ints.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int mixK1(int k12) {
        k12 *= -862048943;
        k12 = Integer.rotateLeft(k12, 15);
        return k12 *= 461845907;
    }

    private static int mixH1(int h12, int k12) {
        h12 ^= k12;
        h12 = Integer.rotateLeft(h12, 13);
        h12 = h12 * 5 + -430675100;
        return h12;
    }

    private static HashCode fmix(int h12, int length) {
        h12 ^= length;
        h12 ^= h12 >>> 16;
        h12 *= -2048144789;
        h12 ^= h12 >>> 13;
        h12 *= -1028477387;
        h12 ^= h12 >>> 16;
        return HashCode.fromInt(h12);
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return (0xF0L | (long)(codePoint >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c5) {
        return (0x1E0 | c5 >>> 12) & 0xFF | (0x80 | 0x3F & c5 >>> 6) << 8 | (0x80 | 0x3F & c5) << 16;
    }

    private static long charToTwoUtf8Bytes(char c5) {
        return (0x3C0 | c5 >>> 6) & 0xFF | (0x80 | 0x3F & c5) << 8;
    }

    @CanIgnoreReturnValue
    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        Murmur3_32Hasher(int seed) {
            this.h1 = seed;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int nBytes, long update) {
            this.buffer |= (update & 0xFFFFFFFFL) << this.shift;
            this.shift += nBytes * 8;
            this.length += nBytes;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        @Override
        public Hasher putByte(byte b5) {
            this.update(1, b5 & 0xFF);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes, int off, int len) {
            Preconditions.checkPositionIndexes(off, off + len, bytes.length);
            int i4 = 0;
            while (i4 + 4 <= len) {
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(bytes, off + i4));
                i4 += 4;
            }
            while (i4 < len) {
                this.putByte(bytes[off + i4]);
                ++i4;
            }
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer buffer) {
            ByteOrder bo = buffer.order();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.remaining() >= 4) {
                this.putInt(buffer.getInt());
            }
            while (buffer.hasRemaining()) {
                this.putByte(buffer.get());
            }
            buffer.order(bo);
            return this;
        }

        @Override
        public Hasher putInt(int i4) {
            this.update(4, i4);
            return this;
        }

        @Override
        public Hasher putLong(long l4) {
            this.update(4, (int)l4);
            this.update(4, l4 >>> 32);
            return this;
        }

        @Override
        public Hasher putChar(char c5) {
            this.update(2, c5);
            return this;
        }

        @Override
        public Hasher putString(CharSequence input, Charset charset) {
            if (Charsets.UTF_8.equals(charset)) {
                int utf16Length = input.length();
                int i4 = 0;
                while (i4 + 4 <= utf16Length) {
                    char c02 = input.charAt(i4);
                    char c12 = input.charAt(i4 + 1);
                    char c22 = input.charAt(i4 + 2);
                    char c32 = input.charAt(i4 + 3);
                    if (c02 >= '\u0080' || c12 >= '\u0080' || c22 >= '\u0080' || c32 >= '\u0080') break;
                    this.update(4, c02 | c12 << 8 | c22 << 16 | c32 << 24);
                    i4 += 4;
                }
                while (i4 < utf16Length) {
                    char c5 = input.charAt(i4);
                    if (c5 < '\u0080') {
                        this.update(1, c5);
                    } else if (c5 < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c5));
                    } else if (c5 < '\ud800' || c5 > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c5));
                    } else {
                        int codePoint = Character.codePointAt(input, i4);
                        if (codePoint == c5) {
                            this.putBytes(input.subSequence(i4, utf16Length).toString().getBytes(charset));
                            return this;
                        }
                        ++i4;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint));
                    }
                    ++i4;
                }
                return this;
            }
            return super.putString(input, charset);
        }

        @Override
        public HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

