/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;
import sun.misc.Unsafe;

@GwtIncompatible
abstract class Striped64
extends Number {
    static final ThreadLocal<int[]> threadHashCode = new ThreadLocal();
    static final Random rng = new Random();
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell @Nullable [] cells;
    volatile transient long base;
    volatile transient int busy;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;

    Striped64() {
    }

    final boolean casBase(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, baseOffset, cmp, val);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void retryUpdate(long x4, int @Nullable [] hc, boolean wasUncontended) {
        int h4;
        if (hc == null) {
            hc = new int[1];
            threadHashCode.set(hc);
            int r4 = rng.nextInt();
            hc[0] = r4 == 0 ? 1 : r4;
            h4 = hc[0];
        } else {
            h4 = hc[0];
        }
        boolean collide = false;
        while (true) {
            long v4;
            int n4;
            Cell[] as = this.cells;
            if (this.cells != null && (n4 = as.length) > 0) {
                Cell a5 = as[n4 - 1 & h4];
                if (a5 == null) {
                    if (this.busy == 0) {
                        Cell r5 = new Cell(x4);
                        if (this.busy == 0 && this.casBusy()) {
                            boolean created = false;
                            try {
                                int j4;
                                int m4;
                                Cell[] rs = this.cells;
                                if (this.cells != null && (m4 = rs.length) > 0 && rs[j4 = m4 - 1 & h4] == null) {
                                    rs[j4] = r5;
                                    created = true;
                                }
                            }
                            finally {
                                this.busy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v4 = a5.value;
                    if (a5.cas(v4, this.fn(v4, x4))) return;
                    if (n4 >= NCPU || this.cells != as) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.busy == 0 && this.casBusy()) {
                        try {
                            if (this.cells == as) {
                                Cell[] rs = new Cell[n4 << 1];
                                for (int i4 = 0; i4 < n4; ++i4) {
                                    rs[i4] = as[i4];
                                }
                                this.cells = rs;
                            }
                        }
                        finally {
                            this.busy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h4 ^= h4 << 13;
                h4 ^= h4 >>> 17;
                h4 ^= h4 << 5;
                hc[0] = h4;
                continue;
            }
            if (this.busy == 0 && this.cells == as && this.casBusy()) {
                boolean init = false;
                try {
                    if (this.cells == as) {
                        Cell[] rs = new Cell[2];
                        rs[h4 & 1] = new Cell(x4);
                        this.cells = rs;
                        init = true;
                    }
                }
                finally {
                    this.busy = 0;
                }
                if (!init) continue;
                return;
            }
            v4 = this.base;
            if (this.casBase(v4, this.fn(v4, x4))) return;
        }
    }

    final void internalReset(long initialValue) {
        Cell[] as = this.cells;
        this.base = initialValue;
        if (as != null) {
            for (Cell a5 : as) {
                if (a5 == null) continue;
                a5.value = initialValue;
            }
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k4 = Unsafe.class;
                        for (Field f5 : k4.getDeclaredFields()) {
                            f5.setAccessible(true);
                            Object x4 = f5.get(null);
                            if (!k4.isInstance(x4)) continue;
                            return (Unsafe)k4.cast(x4);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e5) {
                throw new RuntimeException("Could not initialize intrinsics", e5.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = Striped64.getUnsafe();
            Class<Striped64> sk = Striped64.class;
            baseOffset = UNSAFE.objectFieldOffset(sk.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(sk.getDeclaredField("busy"));
        }
        catch (Exception e5) {
            throw new Error(e5);
        }
    }

    static final class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long x4) {
            this.value = x4;
        }

        final boolean cas(long cmp, long val) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                Class<Cell> ak = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(ak.getDeclaredField("value"));
            }
            catch (Exception e5) {
                throw new Error(e5);
            }
        }
    }
}

