/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x4) {
        if (x4 <= 0) {
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(role).length()).append(role).append(" (").append(x4).append(") must be > 0").toString());
        }
        return x4;
    }

    static long checkPositive(@Nullable String role, long x4) {
        if (x4 <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(role).length()).append(role).append(" (").append(x4).append(") must be > 0").toString());
        }
        return x4;
    }

    static BigInteger checkPositive(@Nullable String role, BigInteger x4) {
        if (x4.signum() <= 0) {
            String string = String.valueOf(x4);
            throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(role).length() + String.valueOf(string).length()).append(role).append(" (").append(string).append(") must be > 0").toString());
        }
        return x4;
    }

    static int checkNonNegative(@Nullable String role, int x4) {
        if (x4 < 0) {
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(role).length()).append(role).append(" (").append(x4).append(") must be >= 0").toString());
        }
        return x4;
    }

    static long checkNonNegative(@Nullable String role, long x4) {
        if (x4 < 0L) {
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(role).length()).append(role).append(" (").append(x4).append(") must be >= 0").toString());
        }
        return x4;
    }

    static BigInteger checkNonNegative(@Nullable String role, BigInteger x4) {
        if (x4.signum() < 0) {
            String string = String.valueOf(x4);
            throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(role).length() + String.valueOf(string).length()).append(role).append(" (").append(string).append(") must be >= 0").toString());
        }
        return x4;
    }

    static double checkNonNegative(@Nullable String role, double x4) {
        if (!(x4 >= 0.0)) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(role).length()).append(role).append(" (").append(x4).append(") must be >= 0").toString());
        }
        return x4;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            String string = String.valueOf((Object)mode);
            throw new ArithmeticException(new StringBuilder(83 + String.valueOf(string).length()).append("rounded value is out of range for input ").append(input).append(" and rounding mode ").append(string).toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a5, int b5) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(36 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a5).append(", ").append(b5).append(")").toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a5, long b5) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(54 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a5).append(", ").append(b5).append(")").toString());
        }
    }

    private MathPreconditions() {
    }
}

