/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class ImmutableDoubleArray
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final transient int start;
    private final int end;

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double e02) {
        return new ImmutableDoubleArray(new double[]{e02});
    }

    public static ImmutableDoubleArray of(double e02, double e12) {
        return new ImmutableDoubleArray(new double[]{e02, e12});
    }

    public static ImmutableDoubleArray of(double e02, double e12, double e22) {
        return new ImmutableDoubleArray(new double[]{e02, e12, e22});
    }

    public static ImmutableDoubleArray of(double e02, double e12, double e22, double e32) {
        return new ImmutableDoubleArray(new double[]{e02, e12, e22, e32});
    }

    public static ImmutableDoubleArray of(double e02, double e12, double e22, double e32, double e42) {
        return new ImmutableDoubleArray(new double[]{e02, e12, e22, e32, e42});
    }

    public static ImmutableDoubleArray of(double e02, double e12, double e22, double e32, double e42, double e5) {
        return new ImmutableDoubleArray(new double[]{e02, e12, e22, e32, e42, e5});
    }

    public static ImmutableDoubleArray of(double first, double ... rest) {
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        double[] array = new double[rest.length + 1];
        array[0] = first;
        System.arraycopy(rest, 0, array, 1, rest.length);
        return new ImmutableDoubleArray(array);
    }

    public static ImmutableDoubleArray copyOf(double[] values2) {
        return values2.length == 0 ? EMPTY : new ImmutableDoubleArray(Arrays.copyOf(values2, values2.length));
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> values2) {
        return values2.isEmpty() ? EMPTY : new ImmutableDoubleArray(Doubles.toArray(values2));
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> values2) {
        if (values2 instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection)values2);
        }
        return ImmutableDoubleArray.builder().addAll(values2).build();
    }

    public static ImmutableDoubleArray copyOf(DoubleStream stream) {
        double[] array = stream.toArray();
        return array.length == 0 ? EMPTY : new ImmutableDoubleArray(array);
    }

    public static Builder builder(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initialCapacity: %s", initialCapacity);
        return new Builder(initialCapacity);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableDoubleArray(double[] array) {
        this(array, 0, array.length);
    }

    private ImmutableDoubleArray(double[] array, int start, int end) {
        this.array = array;
        this.start = start;
        this.end = end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public double get(int index) {
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + index];
    }

    public int indexOf(double target) {
        for (int i4 = this.start; i4 < this.end; ++i4) {
            if (!ImmutableDoubleArray.areEqual(this.array[i4], target)) continue;
            return i4 - this.start;
        }
        return -1;
    }

    public int lastIndexOf(double target) {
        for (int i4 = this.end - 1; i4 >= this.start; --i4) {
            if (!ImmutableDoubleArray.areEqual(this.array[i4], target)) continue;
            return i4 - this.start;
        }
        return -1;
    }

    public boolean contains(double target) {
        return this.indexOf(target) >= 0;
    }

    public void forEach(DoubleConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i4 = this.start; i4 < this.end; ++i4) {
            consumer.accept(this.array[i4]);
        }
    }

    public DoubleStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public double[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableDoubleArray subArray(int startIndex, int endIndex) {
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        return startIndex == endIndex ? EMPTY : new ImmutableDoubleArray(this.array, this.start + startIndex, this.start + endIndex);
    }

    private Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Double> asList() {
        return new AsList(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        ImmutableDoubleArray that = (ImmutableDoubleArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i4 = 0; i4 < this.length(); ++i4) {
            if (ImmutableDoubleArray.areEqual(this.get(i4), that.get(i4))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(double a5, double b5) {
        return Double.doubleToLongBits(a5) == Double.doubleToLongBits(b5);
    }

    public int hashCode() {
        int hash = 1;
        for (int i4 = this.start; i4 < this.end; ++i4) {
            hash *= 31;
            hash += Doubles.hashCode(this.array[i4]);
        }
        return hash;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i4 = this.start + 1; i4 < this.end; ++i4) {
            builder.append(", ").append(this.array[i4]);
        }
        builder.append(']');
        return builder.toString();
    }

    public ImmutableDoubleArray trimmed() {
        return this.isPartialView() ? new ImmutableDoubleArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Double>
    implements RandomAccess,
    Serializable {
        private final ImmutableDoubleArray parent;

        private AsList(ImmutableDoubleArray parent) {
            this.parent = parent;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Double get(int index) {
            return this.parent.get(index);
        }

        @Override
        public boolean contains(Object target) {
            return this.indexOf(target) >= 0;
        }

        @Override
        public int indexOf(Object target) {
            return target instanceof Double ? this.parent.indexOf((Double)target) : -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            return target instanceof Double ? this.parent.lastIndexOf((Double)target) : -1;
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            return this.parent.subArray(fromIndex, toIndex).asList();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AsList) {
                AsList that = (AsList)object;
                return this.parent.equals(that.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List that = (List)object;
            if (this.size() != that.size()) {
                return false;
            }
            int i4 = this.parent.start;
            for (Object element : that) {
                if (element instanceof Double && ImmutableDoubleArray.areEqual(this.parent.array[i4++], (Double)element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private double[] array;
        private int count = 0;

        Builder(int initialCapacity) {
            this.array = new double[initialCapacity];
        }

        public Builder add(double value) {
            this.ensureRoomFor(1);
            this.array[this.count] = value;
            ++this.count;
            return this;
        }

        public Builder addAll(double[] values2) {
            this.ensureRoomFor(values2.length);
            System.arraycopy(values2, 0, this.array, this.count, values2.length);
            this.count += values2.length;
            return this;
        }

        public Builder addAll(Iterable<Double> values2) {
            if (values2 instanceof Collection) {
                return this.addAll((Collection)values2);
            }
            for (Double value : values2) {
                this.add(value);
            }
            return this;
        }

        public Builder addAll(Collection<Double> values2) {
            this.ensureRoomFor(values2.size());
            for (Double value : values2) {
                this.array[this.count++] = value;
            }
            return this;
        }

        public Builder addAll(DoubleStream stream) {
            Spliterator.OfDouble spliterator = stream.spliterator();
            long size = spliterator.getExactSizeIfKnown();
            if (size > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(size));
            }
            spliterator.forEachRemaining(this::add);
            return this;
        }

        public Builder addAll(ImmutableDoubleArray values2) {
            this.ensureRoomFor(values2.length());
            System.arraycopy(values2.array, values2.start, this.array, this.count, values2.length());
            this.count += values2.length();
            return this;
        }

        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, newCount));
            }
        }

        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        @CheckReturnValue
        public ImmutableDoubleArray build() {
            return this.count == 0 ? EMPTY : new ImmutableDoubleArray(this.array, 0, this.count);
        }
    }
}

