/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i4 = 0; i4 < len; ++i4) {
            longArray[i4] = Double.doubleToRawLongBits(array[i4]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i4) {
        return Double.longBitsToDouble(this.longs.get(i4));
    }

    public final void set(int i4, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i4, next);
    }

    public final void lazySet(int i4, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet(i4, next);
    }

    public final double getAndSet(int i4, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i4, next));
    }

    public final boolean compareAndSet(int i4, double expect, double update) {
        return this.longs.compareAndSet(i4, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i4, double expect, double update) {
        return this.longs.weakCompareAndSet(i4, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int i4, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i4, current = this.longs.get(i4), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return currentVal;
    }

    @CanIgnoreReturnValue
    public double addAndGet(int i4, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i4, current = this.longs.get(i4), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b5 = new StringBuilder(19 * (iMax + 1));
        b5.append('[');
        int i4 = 0;
        while (true) {
            b5.append(Double.longBitsToDouble(this.longs.get(i4)));
            if (i4 == iMax) {
                return b5.append(']').toString();
            }
            b5.append(',').append(' ');
            ++i4;
        }
    }

    private void writeObject(ObjectOutputStream s4) throws IOException {
        s4.defaultWriteObject();
        int length = this.length();
        s4.writeInt(length);
        for (int i4 = 0; i4 < length; ++i4) {
            s4.writeDouble(this.get(i4));
        }
    }

    private void readObject(ObjectInputStream s4) throws IOException, ClassNotFoundException {
        s4.defaultReadObject();
        int length = s4.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i4 = 0; i4 < length; ++i4) {
            builder.add(Double.doubleToRawLongBits(s4.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

