/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.Internal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable = true;

    AbstractProtobufList() {
    }

    @Override
    public boolean equals(Object o4) {
        if (o4 == this) {
            return true;
        }
        if (!(o4 instanceof List)) {
            return false;
        }
        if (!(o4 instanceof RandomAccess)) {
            return super.equals(o4);
        }
        List other = (List)o4;
        int size = this.size();
        if (size != other.size()) {
            return false;
        }
        for (int i4 = 0; i4 < size; ++i4) {
            if (this.get(i4).equals(other.get(i4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int size = this.size();
        int hashCode = 1;
        for (int i4 = 0; i4 < size; ++i4) {
            hashCode = 31 * hashCode + this.get(i4).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(E e5) {
        this.ensureIsMutable();
        return super.add(e5);
    }

    @Override
    public void add(int index, E element) {
        this.ensureIsMutable();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c5) {
        this.ensureIsMutable();
        return super.addAll(c5);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c5) {
        this.ensureIsMutable();
        return super.addAll(index, c5);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        this.isMutable = false;
    }

    @Override
    public E remove(int index) {
        this.ensureIsMutable();
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o4) {
        this.ensureIsMutable();
        return super.remove(o4);
    }

    @Override
    public boolean removeAll(Collection<?> c5) {
        this.ensureIsMutable();
        return super.removeAll(c5);
    }

    @Override
    public boolean retainAll(Collection<?> c5) {
        this.ensureIsMutable();
        return super.retainAll(c5);
    }

    @Override
    public E set(int index, E element) {
        this.ensureIsMutable();
        return super.set(index, element);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

