/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Generator;

public class BERGenerator
extends ASN1Generator {
    private boolean _tagged = false;
    private boolean _isExplicit;
    private int _tagNo;

    protected BERGenerator(OutputStream outputStream) {
        super(outputStream);
    }

    protected BERGenerator(OutputStream outputStream, int n4, boolean bl) {
        super(outputStream);
        this._tagged = true;
        this._isExplicit = bl;
        this._tagNo = n4;
    }

    public OutputStream getRawOutputStream() {
        return this._out;
    }

    private void writeHdr(int n4) throws IOException {
        this._out.write(n4);
        this._out.write(128);
    }

    protected void writeBERHeader(int n4) throws IOException {
        if (this._tagged) {
            int n5 = this._tagNo | 0x80;
            if (this._isExplicit) {
                this.writeHdr(n5 | 0x20);
                this.writeHdr(n4);
            } else if ((n4 & 0x20) != 0) {
                this.writeHdr(n5 | 0x20);
            } else {
                this.writeHdr(n5);
            }
        } else {
            this.writeHdr(n4);
        }
    }

    protected void writeBEREnd() throws IOException {
        this._out.write(0);
        this._out.write(0);
        if (this._tagged && this._isExplicit) {
            this._out.write(0);
            this._out.write(0);
        }
    }
}

