/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Arrays;

public class KeccakDigest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = KeccakDigest.keccakInitializeRoundConstants();
    private static int[] KeccakRhoOffsets = KeccakDigest.keccakInitializeRhoOffsets();
    protected byte[] state = new byte[200];
    protected byte[] dataQueue = new byte[192];
    protected int rate;
    protected int bitsInQueue;
    protected int fixedOutputLength;
    protected boolean squeezing;
    protected int bitsAvailableForSqueezing;
    protected byte[] chunk;
    protected byte[] oneByte;
    long[] C = new long[5];
    long[] tempA = new long[25];
    long[] chiC = new long[5];

    private static long[] keccakInitializeRoundConstants() {
        long[] lArray = new long[24];
        byte[] byArray = new byte[]{1};
        for (int i4 = 0; i4 < 24; ++i4) {
            lArray[i4] = 0L;
            for (int i5 = 0; i5 < 7; ++i5) {
                int n4 = (1 << i5) - 1;
                if (!KeccakDigest.LFSR86540(byArray)) continue;
                int n5 = i4;
                lArray[n5] = lArray[n5] ^ 1L << n4;
            }
        }
        return lArray;
    }

    private static boolean LFSR86540(byte[] byArray) {
        boolean bl = (byArray[0] & 1) != 0;
        byArray[0] = (byArray[0] & 0x80) != 0 ? (byte)(byArray[0] << 1 ^ 0x71) : (byte)(byArray[0] << 1);
        return bl;
    }

    private static int[] keccakInitializeRhoOffsets() {
        int[] nArray = new int[25];
        nArray[0] = 0;
        int n4 = 1;
        int n5 = 0;
        for (int i4 = 0; i4 < 24; ++i4) {
            nArray[n4 % 5 + 5 * (n5 % 5)] = (i4 + 1) * (i4 + 2) / 2 % 64;
            int n6 = (0 * n4 + 1 * n5) % 5;
            int n7 = (2 * n4 + 3 * n5) % 5;
            n4 = n6;
            n5 = n7;
        }
        return nArray;
    }

    private void clearDataQueueSection(int n4, int n5) {
        for (int i4 = n4; i4 != n4 + n5; ++i4) {
            this.dataQueue[i4] = 0;
        }
    }

    public KeccakDigest() {
        this(288);
    }

    public KeccakDigest(int n4) {
        this.init(n4);
    }

    public KeccakDigest(KeccakDigest keccakDigest) {
        System.arraycopy(keccakDigest.state, 0, this.state, 0, keccakDigest.state.length);
        System.arraycopy(keccakDigest.dataQueue, 0, this.dataQueue, 0, keccakDigest.dataQueue.length);
        this.rate = keccakDigest.rate;
        this.bitsInQueue = keccakDigest.bitsInQueue;
        this.fixedOutputLength = keccakDigest.fixedOutputLength;
        this.squeezing = keccakDigest.squeezing;
        this.bitsAvailableForSqueezing = keccakDigest.bitsAvailableForSqueezing;
        this.chunk = Arrays.clone(keccakDigest.chunk);
        this.oneByte = Arrays.clone(keccakDigest.oneByte);
    }

    public String getAlgorithmName() {
        return "Keccak-" + this.fixedOutputLength;
    }

    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    public void update(byte by) {
        this.oneByte[0] = by;
        this.absorb(this.oneByte, 0, 8L);
    }

    public void update(byte[] byArray, int n4, int n5) {
        this.absorb(byArray, n4, (long)n5 * 8L);
    }

    public int doFinal(byte[] byArray, int n4) {
        this.squeeze(byArray, n4, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    protected int doFinal(byte[] byArray, int n4, byte by, int n5) {
        if (n5 > 0) {
            this.oneByte[0] = by;
            this.absorb(this.oneByte, 0, n5);
        }
        this.squeeze(byArray, n4, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    public void reset() {
        this.init(this.fixedOutputLength);
    }

    public int getByteLength() {
        return this.rate / 8;
    }

    private void init(int n4) {
        switch (n4) {
            case 288: {
                this.initSponge(1024, 576);
                break;
            }
            case 128: {
                this.initSponge(1344, 256);
                break;
            }
            case 224: {
                this.initSponge(1152, 448);
                break;
            }
            case 256: {
                this.initSponge(1088, 512);
                break;
            }
            case 384: {
                this.initSponge(832, 768);
                break;
            }
            case 512: {
                this.initSponge(576, 1024);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitLength must be one of 128, 224, 256, 288, 384, or 512.");
            }
        }
    }

    private void initSponge(int n4, int n5) {
        if (n4 + n5 != 1600) {
            throw new IllegalStateException("rate + capacity != 1600");
        }
        if (n4 <= 0 || n4 >= 1600 || n4 % 64 != 0) {
            throw new IllegalStateException("invalid rate value");
        }
        this.rate = n4;
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.dataQueue, (byte)0);
        this.bitsInQueue = 0;
        this.squeezing = false;
        this.bitsAvailableForSqueezing = 0;
        this.fixedOutputLength = n5 / 2;
        this.chunk = new byte[n4 / 8];
        this.oneByte = new byte[1];
    }

    private void absorbQueue() {
        this.KeccakAbsorb(this.state, this.dataQueue, this.rate / 8);
        this.bitsInQueue = 0;
    }

    protected void absorb(byte[] byArray, int n4, long l4) {
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        long l5 = 0L;
        while (l5 < l4) {
            if (this.bitsInQueue == 0 && l4 >= (long)this.rate && l5 <= l4 - (long)this.rate) {
                long l6 = (l4 - l5) / (long)this.rate;
                for (long i4 = 0L; i4 < l6; ++i4) {
                    System.arraycopy(byArray, (int)((long)n4 + l5 / 8L + i4 * (long)this.chunk.length), this.chunk, 0, this.chunk.length);
                    this.KeccakAbsorb(this.state, this.chunk, this.chunk.length);
                }
                l5 += l6 * (long)this.rate;
                continue;
            }
            int n5 = (int)(l4 - l5);
            if (n5 + this.bitsInQueue > this.rate) {
                n5 = this.rate - this.bitsInQueue;
            }
            int n6 = n5 % 8;
            System.arraycopy(byArray, n4 + (int)(l5 / 8L), this.dataQueue, this.bitsInQueue / 8, (n5 -= n6) / 8);
            this.bitsInQueue += n5;
            l5 += (long)n5;
            if (this.bitsInQueue == this.rate) {
                this.absorbQueue();
            }
            if (n6 <= 0) continue;
            int n7 = (1 << n6) - 1;
            this.dataQueue[this.bitsInQueue / 8] = (byte)(byArray[n4 + (int)(l5 / 8L)] & n7);
            this.bitsInQueue += n6;
            l5 += (long)n6;
        }
    }

    private void padAndSwitchToSqueezingPhase() {
        if (this.bitsInQueue + 1 == this.rate) {
            int n4 = this.bitsInQueue / 8;
            this.dataQueue[n4] = (byte)(this.dataQueue[n4] | 1 << this.bitsInQueue % 8);
            this.absorbQueue();
            this.clearDataQueueSection(0, this.rate / 8);
        } else {
            this.clearDataQueueSection((this.bitsInQueue + 7) / 8, this.rate / 8 - (this.bitsInQueue + 7) / 8);
            int n5 = this.bitsInQueue / 8;
            this.dataQueue[n5] = (byte)(this.dataQueue[n5] | 1 << this.bitsInQueue % 8);
        }
        int n6 = (this.rate - 1) / 8;
        this.dataQueue[n6] = (byte)(this.dataQueue[n6] | 1 << (this.rate - 1) % 8);
        this.absorbQueue();
        if (this.rate == 1024) {
            this.KeccakExtract1024bits(this.state, this.dataQueue);
            this.bitsAvailableForSqueezing = 1024;
        } else {
            this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
            this.bitsAvailableForSqueezing = this.rate;
        }
        this.squeezing = true;
    }

    protected void squeeze(byte[] byArray, int n4, long l4) {
        int n5;
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        if (l4 % 8L != 0L) {
            throw new IllegalStateException("outputLength not a multiple of 8");
        }
        for (long i4 = 0L; i4 < l4; i4 += (long)n5) {
            if (this.bitsAvailableForSqueezing == 0) {
                this.keccakPermutation(this.state);
                if (this.rate == 1024) {
                    this.KeccakExtract1024bits(this.state, this.dataQueue);
                    this.bitsAvailableForSqueezing = 1024;
                } else {
                    this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
                    this.bitsAvailableForSqueezing = this.rate;
                }
            }
            if ((long)(n5 = this.bitsAvailableForSqueezing) > l4 - i4) {
                n5 = (int)(l4 - i4);
            }
            System.arraycopy(this.dataQueue, (this.rate - this.bitsAvailableForSqueezing) / 8, byArray, n4 + (int)(i4 / 8L), n5 / 8);
            this.bitsAvailableForSqueezing -= n5;
        }
    }

    private void fromBytesToWords(long[] lArray, byte[] byArray) {
        for (int i4 = 0; i4 < 25; ++i4) {
            lArray[i4] = 0L;
            int n4 = i4 * 8;
            for (int i5 = 0; i5 < 8; ++i5) {
                int n5 = i4;
                lArray[n5] = lArray[n5] | ((long)byArray[n4 + i5] & 0xFFL) << 8 * i5;
            }
        }
    }

    private void fromWordsToBytes(byte[] byArray, long[] lArray) {
        for (int i4 = 0; i4 < 25; ++i4) {
            int n4 = i4 * 8;
            for (int i5 = 0; i5 < 8; ++i5) {
                byArray[n4 + i5] = (byte)(lArray[i4] >>> 8 * i5 & 0xFFL);
            }
        }
    }

    private void keccakPermutation(byte[] byArray) {
        long[] lArray = new long[byArray.length / 8];
        this.fromBytesToWords(lArray, byArray);
        this.keccakPermutationOnWords(lArray);
        this.fromWordsToBytes(byArray, lArray);
    }

    private void keccakPermutationAfterXor(byte[] byArray, byte[] byArray2, int n4) {
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5 = i4;
            byArray[n5] = (byte)(byArray[n5] ^ byArray2[i4]);
        }
        this.keccakPermutation(byArray);
    }

    private void keccakPermutationOnWords(long[] lArray) {
        for (int i4 = 0; i4 < 24; ++i4) {
            this.theta(lArray);
            this.rho(lArray);
            this.pi(lArray);
            this.chi(lArray);
            this.iota(lArray, i4);
        }
    }

    private void theta(long[] lArray) {
        int n4;
        for (n4 = 0; n4 < 5; ++n4) {
            this.C[n4] = 0L;
            for (int i4 = 0; i4 < 5; ++i4) {
                int n5 = n4;
                this.C[n5] = this.C[n5] ^ lArray[n4 + 5 * i4];
            }
        }
        for (n4 = 0; n4 < 5; ++n4) {
            long l4 = this.C[(n4 + 1) % 5] << 1 ^ this.C[(n4 + 1) % 5] >>> 63 ^ this.C[(n4 + 4) % 5];
            for (int i5 = 0; i5 < 5; ++i5) {
                int n6 = n4 + 5 * i5;
                lArray[n6] = lArray[n6] ^ l4;
            }
        }
    }

    private void rho(long[] lArray) {
        for (int i4 = 0; i4 < 5; ++i4) {
            for (int i5 = 0; i5 < 5; ++i5) {
                int n4 = i4 + 5 * i5;
                lArray[n4] = KeccakRhoOffsets[n4] != 0 ? lArray[n4] << KeccakRhoOffsets[n4] ^ lArray[n4] >>> 64 - KeccakRhoOffsets[n4] : lArray[n4];
            }
        }
    }

    private void pi(long[] lArray) {
        System.arraycopy(lArray, 0, this.tempA, 0, this.tempA.length);
        for (int i4 = 0; i4 < 5; ++i4) {
            for (int i5 = 0; i5 < 5; ++i5) {
                lArray[i5 + 5 * ((2 * i4 + 3 * i5) % 5)] = this.tempA[i4 + 5 * i5];
            }
        }
    }

    private void chi(long[] lArray) {
        for (int i4 = 0; i4 < 5; ++i4) {
            int n4;
            for (n4 = 0; n4 < 5; ++n4) {
                this.chiC[n4] = lArray[n4 + 5 * i4] ^ (lArray[(n4 + 1) % 5 + 5 * i4] ^ 0xFFFFFFFFFFFFFFFFL) & lArray[(n4 + 2) % 5 + 5 * i4];
            }
            for (n4 = 0; n4 < 5; ++n4) {
                lArray[n4 + 5 * i4] = this.chiC[n4];
            }
        }
    }

    private void iota(long[] lArray, int n4) {
        lArray[0] = lArray[0] ^ KeccakRoundConstants[n4];
    }

    private void KeccakAbsorb(byte[] byArray, byte[] byArray2, int n4) {
        this.keccakPermutationAfterXor(byArray, byArray2, n4);
    }

    private void KeccakExtract1024bits(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 128);
    }

    private void KeccakExtract(byte[] byArray, byte[] byArray2, int n4) {
        System.arraycopy(byArray, 0, byArray2, 0, n4 * 8);
    }
}

